/*
 * Decompiled with CFR 0.152.
 */
package WebseitenPfadGenerator;

import WebseitenPfadGenerator.FileNode;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FileTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon folderIcon;
    private Icon fileIcon;
    private Icon htmlIcon;
    private Icon imageIcon;

    public FileTreeCellRenderer() {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        this.folderIcon = UIManager.getIcon("Tree.closedIcon");
        this.fileIcon = UIManager.getIcon("Tree.leafIcon");
        if (this.folderIcon == null) {
            this.folderIcon = fsv.getSystemIcon(new File(System.getProperty("user.home")));
        }
        if (this.fileIcon == null) {
            this.fileIcon = fsv.getSystemIcon(new File("dummy.txt"));
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (userObject instanceof FileNode) {
            FileNode fileNode = (FileNode)userObject;
            File file = fileNode.getFile();
            this.setText(file.getName());
            if (file.isDirectory()) {
                this.setIcon(this.folderIcon);
            } else {
                String fileName = file.getName().toLowerCase();
                if (fileName.endsWith(".html") || fileName.endsWith(".htm")) {
                    this.setIcon(this.htmlIcon != null ? this.htmlIcon : this.fileIcon);
                } else if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg") || fileName.endsWith(".png") || fileName.endsWith(".gif") || fileName.endsWith(".svg")) {
                    this.setIcon(this.imageIcon != null ? this.imageIcon : this.fileIcon);
                } else {
                    this.setIcon(this.fileIcon);
                }
            }
        } else if (userObject instanceof File) {
            File file = (File)userObject;
            this.setText(file.getName());
            if (file.isDirectory()) {
                this.setIcon(this.folderIcon);
            } else {
                this.setIcon(this.fileIcon);
            }
        } else {
            this.setText(node.toString());
            this.setIcon(this.folderIcon);
        }
        return this;
    }
}

