/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.input;

import com.sun.jfx.incubator.scene.control.input.EventCriteria;
import com.sun.jfx.incubator.scene.control.input.EventHandlerPriority;
import com.sun.jfx.incubator.scene.control.input.KeyEventMapper;
import com.sun.jfx.incubator.scene.control.input.PHList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.Control;
import javafx.scene.input.KeyCode;
import jfx.incubator.scene.control.input.FunctionTag;
import jfx.incubator.scene.control.input.KeyBinding;

public abstract sealed class SkinInputMap {
    final HashMap<Object, Object> map = new HashMap();
    public final KeyEventMapper kmapper = new KeyEventMapper();

    public final <T extends Event> void addHandler(EventType<T> eventType, EventHandler<T> eventHandler) {
        this.putHandler(eventType, EventHandlerPriority.SKIN_HIGH, eventHandler);
    }

    public final <T extends Event> void addHandler(final EventCriteria<T> eventCriteria, final EventHandler<T> eventHandler) {
        EventType<T> eventType = eventCriteria.getEventType();
        this.putHandler(eventType, EventHandlerPriority.SKIN_HIGH, new EventHandler<T>(){

            @Override
            public void handle(T t) {
                if (eventCriteria.isEventAcceptable(t)) {
                    eventHandler.handle(t);
                }
            }
        });
    }

    private <T extends Event> void putHandler(EventType<T> eventType, EventHandlerPriority eventHandlerPriority, EventHandler<T> eventHandler) {
        PHList pHList;
        Object object = this.map.get(eventType);
        if (object instanceof PHList) {
            PHList pHList2;
            pHList = pHList2 = (PHList)object;
        } else {
            pHList = new PHList();
            this.map.put(eventType, pHList);
        }
        pHList.add(eventHandlerPriority, eventHandler);
    }

    public final void registerKey(KeyBinding keyBinding, FunctionTag functionTag) {
        this.map.put(keyBinding, functionTag);
        this.kmapper.addType(keyBinding);
    }

    public final void registerKey(KeyCode keyCode, FunctionTag functionTag) {
        this.registerKey(KeyBinding.of(keyCode), functionTag);
    }

    public Object resolve(KeyBinding keyBinding) {
        return this.map.get(keyBinding);
    }

    public final Set<KeyBinding> getKeyBindings() {
        return this.collectKeyBindings(null, null);
    }

    public final Set<KeyBinding> getKeyBindingsFor(FunctionTag functionTag) {
        return this.collectKeyBindings(null, functionTag);
    }

    public Set<KeyBinding> collectKeyBindings(Set<KeyBinding> set, FunctionTag functionTag) {
        if (set == null) {
            set = new HashSet<KeyBinding>();
        }
        for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
            Object object = entry.getKey();
            if (!(object instanceof KeyBinding)) continue;
            KeyBinding keyBinding = (KeyBinding)object;
            if (functionTag != null && functionTag != entry.getValue()) continue;
            set.add(keyBinding);
        }
        return set;
    }

    public final void duplicateMapping(KeyBinding keyBinding, KeyBinding keyBinding2) {
        Object object = this.map.get(keyBinding);
        if (object != null) {
            this.map.put(keyBinding2, object);
        }
    }

    public final boolean execute(Object object, FunctionTag functionTag) {
        Object object2 = this.map.get(functionTag);
        if (object2 instanceof Runnable) {
            Runnable runnable = (Runnable)object2;
            runnable.run();
            return true;
        }
        if (object2 instanceof BooleanSupplier) {
            BooleanSupplier booleanSupplier = (BooleanSupplier)object2;
            return booleanSupplier.getAsBoolean();
        }
        if (object2 instanceof Stateless.FHandler) {
            Stateless.FHandler fHandler = (Stateless.FHandler)object2;
            fHandler.handleFunction(object);
            return true;
        }
        if (object2 instanceof Stateless.FHandlerConditional) {
            Stateless.FHandlerConditional fHandlerConditional = (Stateless.FHandlerConditional)object2;
            return fHandlerConditional.handleFunction(object);
        }
        return false;
    }

    public void unbind(FunctionTag functionTag) {
        Iterator<Map.Entry<Object, Object>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (functionTag != entry.getValue()) continue;
            iterator.remove();
        }
    }

    public void forEach(TriConsumer triConsumer) {
        for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
            Object object = entry.getKey();
            if (!(object instanceof EventType)) continue;
            EventType eventType = (EventType)object;
            object = (PHList)entry.getValue();
            ((PHList)object).forEach((EventHandlerPriority eventHandlerPriority, EventHandler<T> eventHandler) -> {
                triConsumer.accept(eventType, eventHandlerPriority, eventHandler);
                return true;
            });
        }
    }

    public static Stateful create() {
        return new Stateful();
    }

    public static <C extends Control> Stateless<C> createStateless() {
        return new Stateless();
    }

    public static final class Stateless<C extends Control>
    extends SkinInputMap {
        Stateless() {
        }

        public final void registerFunction(FunctionTag functionTag, FHandler<C> fHandler) {
            this.map.put(functionTag, fHandler);
        }

        public final void registerFunction(FunctionTag functionTag, FHandlerConditional<C> fHandlerConditional) {
            this.map.put(functionTag, fHandlerConditional);
        }

        public final void register(FunctionTag functionTag, KeyBinding keyBinding, FHandler<C> fHandler) {
            this.registerFunction(functionTag, fHandler);
            this.registerKey(keyBinding, functionTag);
        }

        public final void register(FunctionTag functionTag, KeyCode keyCode, FHandler<C> fHandler) {
            this.registerFunction(functionTag, fHandler);
            this.registerKey(KeyBinding.of(keyCode), functionTag);
        }

        public static interface FHandler<C> {
            public void handleFunction(C var1);
        }

        public static interface FHandlerConditional<C> {
            public boolean handleFunction(C var1);
        }
    }

    @FunctionalInterface
    public static interface TriConsumer<T extends Event> {
        public void accept(EventType<T> var1, EventHandlerPriority var2, EventHandler<T> var3);
    }

    public static final class Stateful
    extends SkinInputMap {
        Stateful() {
        }

        public final void registerFunction(FunctionTag functionTag, Runnable runnable) {
            this.map.put(functionTag, runnable);
        }

        public final void registerFunction(FunctionTag functionTag, BooleanSupplier booleanSupplier) {
            this.map.put(functionTag, booleanSupplier);
        }

        public final void register(FunctionTag functionTag, KeyBinding keyBinding, Runnable runnable) {
            this.registerFunction(functionTag, runnable);
            this.registerKey(keyBinding, functionTag);
        }

        public final void register(FunctionTag functionTag, KeyCode keyCode, Runnable runnable) {
            this.registerFunction(functionTag, runnable);
            this.registerKey(KeyBinding.of(keyCode), functionTag);
        }
    }
}

