/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.SegmentStyledInput;
import com.sun.jfx.incubator.scene.control.richtext.SegmentStyledOutput;
import java.io.Closeable;
import java.io.IOException;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.StyledInput;
import jfx.incubator.scene.control.richtext.model.StyledOutput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;

public class UndoableChange {
    private final StyledTextModel model;
    private final TextPos start;
    private final StyledSegment[] undo;
    private StyledSegment[] redo;
    private final TextPos endBefore;
    private TextPos endAfter;
    private UndoableChange prev;
    private UndoableChange next;

    private UndoableChange(StyledTextModel styledTextModel, TextPos textPos, TextPos textPos2, StyledSegment[] styledSegmentArray) {
        this.model = styledTextModel;
        this.start = textPos;
        this.endBefore = textPos2;
        this.undo = styledSegmentArray;
    }

    public static UndoableChange create(StyledTextModel styledTextModel, TextPos textPos, TextPos textPos2) {
        try {
            SegmentStyledOutput segmentStyledOutput = new SegmentStyledOutput(128);
            styledTextModel.export(textPos, textPos2, segmentStyledOutput);
            StyledSegment[] styledSegmentArray = segmentStyledOutput.getSegments();
            return new UndoableChange(styledTextModel, textPos, textPos2, styledSegmentArray);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static UndoableChange createHead() {
        return new UndoableChange(null, null, null, null);
    }

    public String toString() {
        return "UndoableChange{start=" + String.valueOf(this.start) + ", endBefore=" + String.valueOf(this.endBefore) + ", endAfter=" + String.valueOf(this.endAfter);
    }

    public void setEndAfter(TextPos textPos) {
        this.endAfter = textPos;
    }

    public void undo(StyleResolver styleResolver) throws IOException {
        Closeable closeable;
        if (this.redo == null) {
            closeable = new SegmentStyledOutput(128);
            this.model.export(this.start, this.endAfter, (StyledOutput)closeable);
            this.redo = ((SegmentStyledOutput)closeable).getSegments();
        }
        closeable = new SegmentStyledInput(this.undo);
        this.model.replace(styleResolver, this.start, this.endAfter, (StyledInput)closeable, false);
    }

    public void redo(StyleResolver styleResolver) throws IOException {
        SegmentStyledInput segmentStyledInput = new SegmentStyledInput(this.redo);
        this.model.replace(styleResolver, this.start, this.endBefore, segmentStyledInput, false);
    }

    public UndoableChange getPrev() {
        return this.prev;
    }

    public void setPrev(UndoableChange undoableChange) {
        this.prev = undoableChange;
    }

    public UndoableChange getNext() {
        return this.next;
    }

    public void setNext(UndoableChange undoableChange) {
        this.next = undoableChange;
    }

    public TextPos[] getSelectionBefore() {
        return new TextPos[]{this.start, this.endBefore};
    }

    public TextPos[] getSelectionAfter() {
        return new TextPos[]{this.start, this.endAfter};
    }
}

