/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import model.Block;
import model.Chapter;
import model.Page;
import util.HtmlToJsonConverter;

public class CmsApplication
extends Application {
    private Chapter currentChapter;
    private ListView<String> pageListView;
    private VBox blockEditorPane;
    private ScrollPane blockScrollPane;
    private VBox blockDetailsEditorPane;
    private ScrollPane blockDetailsScrollPane;
    private Label editorTitleLabel;
    private Button saveBlockButton;
    private Button cancelBlockButton;
    private HBox editorButtons;
    private Gson gson;
    private String originalHtmlBaseUrl;
    private static final List<String> AVAILABLE_BLOCK_TYPES = List.of("text-block", "heading-block", "code-block", "definition-block", "task-block", "collapsible-block", "test-block", "video-block", "text-image-block", "image-row-block", "gallery-block", "table-block", "download-link-block", "subtopics-container", "teacher-content-block");

    @Override
    public void start(Stage primaryStage) {
        block11: {
            this.gson = new GsonBuilder().setPrettyPrinting().create();
            primaryStage.setTitle("Einfaches CMS - Kapitel Editor");
            BorderPane root = new BorderPane();
            this.pageListView = new ListView();
            this.pageListView.setPrefWidth(250.0);
            this.pageListView.setMinWidth(150.0);
            root.setLeft(this.pageListView);
            this.blockEditorPane = new VBox(10.0);
            this.blockEditorPane.setPadding(new Insets(10.0));
            this.blockScrollPane = new ScrollPane(this.blockEditorPane);
            this.blockScrollPane.setFitToWidth(true);
            this.blockScrollPane.setFitToHeight(true);
            root.setCenter(this.blockScrollPane);
            this.blockDetailsEditorPane = new VBox(10.0);
            this.blockDetailsEditorPane.setPadding(new Insets(10.0));
            this.editorTitleLabel = new Label("Block Details Editor");
            this.editorTitleLabel.setStyle("-fx-font-weight: bold;");
            this.saveBlockButton = new Button("\u00c4nderungen speichern");
            this.cancelBlockButton = new Button("Abbrechen");
            this.editorButtons = new HBox(10.0, this.saveBlockButton, this.cancelBlockButton);
            this.editorButtons.setAlignment(Pos.CENTER_RIGHT);
            System.out.println("Debug (start): editorTitleLabel is null? " + (this.editorTitleLabel == null));
            System.out.println("Debug (start): saveBlockButton is null? " + (this.saveBlockButton == null));
            System.out.println("Debug (start): cancelBlockButton is null? " + (this.cancelBlockButton == null));
            System.out.println("Debug (start): editorButtons is null? " + (this.editorButtons == null));
            if (this.editorButtons != null) {
                System.out.println("Debug (start): editorButtons has children? " + !this.editorButtons.getChildren().isEmpty());
                if (!this.editorButtons.getChildren().isEmpty()) {
                    System.out.println("Debug (start): First child (save) in editorButtons is null? " + (this.editorButtons.getChildren().get(0) == null));
                    System.out.println("Debug (start): Second child (cancel) in editorButtons is null? " + (this.editorButtons.getChildren().get(1) == null));
                }
            }
            this.blockDetailsEditorPane.getChildren().addAll((Node[])new Node[]{this.editorTitleLabel, this.editorButtons});
            this.blockDetailsScrollPane = new ScrollPane(this.blockDetailsEditorPane);
            this.blockDetailsScrollPane.setPrefWidth(400.0);
            this.blockDetailsScrollPane.setMinWidth(200.0);
            this.blockDetailsScrollPane.setFitToWidth(true);
            root.setRight(this.blockDetailsScrollPane);
            Scene scene = new Scene(root, 1400.0, 700.0);
            primaryStage.setScene(scene);
            primaryStage.show();
            String greenfootHtmlPath = "C:\\Users\\kmast\\OneDrive\\Desktop\\LIfT Webseite mit KI\\Website\\praktische-informatik\\programmierung-mit-greenfoot-seite.html";
            File originalHtmlFile = new File(greenfootHtmlPath);
            File parentDir = originalHtmlFile.getParentFile();
            if (parentDir != null && parentDir.exists()) {
                try {
                    this.originalHtmlBaseUrl = parentDir.toURI().toURL().toString();
                    System.out.println("Basis-URL des Original-HTML-Ordners: " + this.originalHtmlBaseUrl);
                    HtmlToJsonConverter converter = new HtmlToJsonConverter();
                    this.currentChapter = converter.convertHtmlToChapterWithOnePage(greenfootHtmlPath);
                    if (this.currentChapter != null) {
                        System.out.println("Kapitel aus HTML konvertiert und geladen: '" + this.currentChapter.getChapterTitle() + "'");
                        this.updatePageListView();
                        if (this.currentChapter.getPages() != null && !this.currentChapter.getPages().isEmpty()) {
                            Page firstPage = this.currentChapter.getPages().get(0);
                            if (!this.pageListView.getItems().isEmpty()) {
                                this.pageListView.getSelectionModel().selectFirst();
                            }
                            System.out.println("Zeige Bl\u00f6cke f\u00fcr Seite: " + firstPage.getPageTitle());
                            this.displayPageBlocks(firstPage);
                        } else {
                            System.err.println("Keine Seiten im geladenen Kapitel gefunden.");
                            this.blockEditorPane.getChildren().add(new Label("Keine Seiten zum Anzeigen gefunden."));
                        }
                        break block11;
                    }
                    System.err.println("Fehler beim Konvertieren der HTML-Datei.");
                    this.blockEditorPane.getChildren().add(new Label("Fehler beim Laden des Kapitels."));
                }
                catch (MalformedURLException e2) {
                    System.err.println("Fehler beim Erstellen der Basis-URL: " + e2.getMessage());
                    e2.printStackTrace();
                    this.blockEditorPane.getChildren().add(new Label("Fehler beim Erstellen der Basis-URL."));
                }
                catch (IOException e3) {
                    System.err.println("Fehler beim Lesen oder Parsen der HTML-Datei: " + e3.getMessage());
                    e3.printStackTrace();
                    this.blockEditorPane.getChildren().add(new Label("Fehler beim Lesen der HTML-Datei."));
                }
            } else {
                System.err.println("Original HTML Datei oder Elternordner nicht gefunden/existiert nicht.");
                this.blockEditorPane.getChildren().add(new Label("HTML-Quelldatei nicht gefunden."));
            }
        }
        this.pageListView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            Page selectedPage;
            if (newValue != null && !newValue.equals(oldValue) && this.currentChapter != null && this.currentChapter.getPages() != null && (selectedPage = this.findPageByTitle((String)newValue)) != null) {
                System.out.println("Listener: Zeige Bl\u00f6cke f\u00fcr Seite: " + selectedPage.getPageTitle());
                this.displayPageBlocks(selectedPage);
                this.clearBlockDetailsEditor();
            }
        });
        this.saveBlockButton.setOnAction(e -> System.out.println("'\u00c4nderungen speichern' Button geklickt."));
        this.cancelBlockButton.setOnAction(e -> {
            System.out.println("'Abbrechen' Button geklickt.");
            this.clearBlockDetailsEditor();
        });
    }

    private void displayPageBlocks(Page page) {
        this.blockEditorPane.getChildren().clear();
        if (page == null || page.getBlocks() == null) {
            this.blockEditorPane.getChildren().add(new Label("Keine Bl\u00f6cke auf dieser Seite."));
            this.blockEditorPane.getChildren().add(this.createAddBlockButton(page, 0));
            return;
        }
        List<Block> blocks = page.getBlocks();
        this.blockEditorPane.getChildren().add(this.createAddBlockButton(page, 0));
        int i = 0;
        while (i < blocks.size()) {
            Block block = blocks.get(i);
            HBox blockRepresentation = this.createBlockRepresentation(page, block, i);
            this.blockEditorPane.getChildren().add(blockRepresentation);
            this.blockEditorPane.getChildren().add(this.createAddBlockButton(page, i + 1));
            ++i;
        }
    }

    private HBox createBlockRepresentation(Page page, Block block, int index) {
        HBox hbox = new HBox(10.0);
        hbox.setAlignment(Pos.CENTER_LEFT);
        hbox.setPadding(new Insets(5.0));
        hbox.setStyle("-fx-border-color: lightgray; -fx-border-width: 0 0 1 0;");
        Label typeLabel = new Label("Block Typ: " + block.getType());
        typeLabel.setPrefWidth(180.0);
        typeLabel.setMinWidth(100.0);
        Button editButton = new Button("Anpassen");
        editButton.setOnAction(e -> this.openBlockEditor(page, block, index));
        Button deleteButton = new Button("L\u00f6schen");
        deleteButton.setOnAction(e -> this.deleteBlock(page, block, index));
        Button moveUpButton = new Button("\u2191");
        moveUpButton.setOnAction(e -> this.moveBlockUp(page, block, index));
        Button moveDownButton = new Button("\u2193");
        moveDownButton.setOnAction(e -> this.moveBlockDown(page, block, index));
        if (index == 0) {
            moveUpButton.setDisable(true);
        }
        if (page != null && page.getBlocks() != null && index == page.getBlocks().size() - 1) {
            moveDownButton.setDisable(true);
        }
        hbox.getChildren().addAll((Node[])new Node[]{typeLabel, editButton, deleteButton, moveUpButton, moveDownButton});
        return hbox;
    }

    private Button createAddBlockButton(Page page, int index) {
        Button addButton = new Button("+ Block hinzuf\u00fcgen");
        addButton.setMaxWidth(Double.MAX_VALUE);
        addButton.setAlignment(Pos.CENTER);
        addButton.setOnAction(e -> this.selectBlockTypeAndAdd(page, index));
        return addButton;
    }

    private String getStringData(Map<String, Object> data, String key) {
        if (data != null && data.containsKey(key) && data.get(key) != null) {
            return data.get(key).toString();
        }
        return "";
    }

    private Boolean getBooleanData(Map<String, Object> data, String key, Boolean defaultValue) {
        if (data != null && data.containsKey(key) && data.get(key) instanceof Boolean) {
            return (Boolean)data.get(key);
        }
        return defaultValue;
    }

    private Number getNumberData(Map<String, Object> data, String key, Number defaultValue) {
        if (data != null && data.containsKey(key) && data.get(key) instanceof Number) {
            return (Number)data.get(key);
        }
        return defaultValue;
    }

    private void openBlockEditor(Page page, Block block, int index) {
        System.out.println("\nDebug (openBlockEditor): Betrete openBlockEditor f\u00fcr Index " + index + " (" + (block != null ? block.getType() : "null Block") + ")");
        System.out.println("Debug (openBlockEditor): editorTitleLabel is null? " + (this.editorTitleLabel == null));
        System.out.println("Debug (openBlockEditor): editorButtons is null? " + (this.editorButtons == null));
        if (this.editorButtons != null) {
            System.out.println("Debug (openBlockEditor): editorButtons has children? " + !this.editorButtons.getChildren().isEmpty());
            if (!this.editorButtons.getChildren().isEmpty()) {
                System.out.println("Debug (openBlockEditor): First child (save) in editorButtons is null? " + (this.editorButtons.getChildren().get(0) == null));
                System.out.println("Debug (openBlockEditor): Second child (cancel) in editorButtons is null? " + (this.editorButtons.getChildren().get(1) == null));
            }
        } else {
            System.out.println("Debug (openBlockEditor): editorButtons ist null, kann Kinder nicht pr\u00fcfen.");
        }
        this.blockDetailsEditorPane.getChildren().clear();
        this.blockDetailsEditorPane.getChildren().addAll((Node[])new Node[]{this.editorTitleLabel, new HBox(10.0), this.editorButtons});
        if (block == null) {
            this.editorTitleLabel.setText("Block Details Editor: Kein Block ausgew\u00e4hlt");
            return;
        }
        this.editorTitleLabel.setText("Block Details Editor: " + block.getType() + " (Index: " + index + ")");
        String type = block.getType();
        Map<String, Object> data = block.getData();
        VBox inputFieldsBox = new VBox(10.0);
        inputFieldsBox.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        switch (type) {
            case "text-block": {
                Label contentLabel = new Label("Inhalt (HTML):");
                TextArea contentArea = new TextArea(this.getStringData(data, "content"));
                contentArea.setWrapText(true);
                contentArea.setPrefRowCount(10);
                contentArea.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("content", newValue);
                });
                inputFieldsBox.getChildren().addAll((Node[])new Node[]{contentLabel, contentArea});
                break;
            }
            case "heading-block": {
                Label levelLabel = new Label("Level (h1-h6):");
                TextField levelField = new TextField(this.getStringData(data, "level"));
                levelField.setPrefColumnCount(3);
                Label textLabel = new Label("Text:");
                TextField textField = new TextField(this.getStringData(data, "text"));
                textField.setPrefColumnCount(30);
                levelField.textProperty().addListener((obs, oldValue, newValue) -> {
                    try {
                        int level = Integer.parseInt(newValue);
                        data.put("level", level);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Ung\u00fcltiges Heading Level Format: " + newValue);
                    }
                });
                textField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("text", newValue);
                });
                inputFieldsBox.getChildren().addAll((Node[])new Node[]{levelLabel, levelField, textLabel, textField});
                break;
            }
            case "code-block": {
                Label codeHeaderLabel = new Label("Header:");
                TextField codeHeaderField = new TextField(this.getStringData(data, "header"));
                codeHeaderField.setPrefColumnCount(30);
                codeHeaderField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("header", newValue);
                });
                Label codeLanguageLabel = new Label("Sprache (z.B. java, python):");
                TextField codeLanguageField = new TextField(this.getStringData(data, "language"));
                codeLanguageField.setPrefColumnCount(15);
                codeLanguageField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("language", newValue);
                });
                Label codeContentLabel = new Label("Code:");
                TextArea codeContentArea = new TextArea(this.getStringData(data, "code"));
                codeContentArea.setWrapText(true);
                codeContentArea.setPrefRowCount(15);
                codeContentArea.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("code", newValue);
                });
                inputFieldsBox.getChildren().addAll((Node[])new Node[]{codeHeaderLabel, codeHeaderField, codeLanguageLabel, codeLanguageField, codeContentLabel, codeContentArea});
                break;
            }
            case "definition-block": {
                Label defIconLabel = new Label("Icon Pfad:");
                Label defIconPathValueLabel = new Label(this.getStringData(data, "iconUrl"));
                defIconPathValueLabel.setStyle("-fx-font-style: italic; -fx-text-fill: gray;");
                Label defPrefixLabel = new Label("Pr\u00e4fix:");
                TextField defPrefixField = new TextField(this.getStringData(data, "prefix"));
                defPrefixField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("prefix", newValue);
                });
                Label defTermLabel = new Label("Begriff:");
                TextField defTermField = new TextField(this.getStringData(data, "term"));
                defTermField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("term", newValue);
                });
                Label defTermColorLabel = new Label("Themenfarbe (Klasse):");
                ChoiceBox<String> defTermColorChoice = new ChoiceBox<String>(FXCollections.observableArrayList("term-practical", "term-theoretical", "term-applied", "term-technical", "term-partner", "term-lehrplan"));
                String currentTermColorClass = this.getStringData(data, "termColorClass");
                if (AVAILABLE_BLOCK_TYPES.contains(currentTermColorClass)) {
                    defTermColorChoice.setValue(currentTermColorClass);
                } else {
                    defTermColorChoice.setValue("term-practical");
                }
                defTermColorChoice.valueProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("termColorClass", newValue);
                });
                Label defContentLabel = new Label("Definition Text (HTML erlaubt):");
                TextArea defContentArea = new TextArea(this.getStringData(data, "definitionContent"));
                defContentArea.setWrapText(true);
                defContentArea.setPrefRowCount(5);
                defContentArea.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("definitionContent", newValue);
                });
                inputFieldsBox.getChildren().addAll((Node[])new Node[]{defIconLabel, defIconPathValueLabel, defPrefixLabel, defPrefixField, defTermLabel, defTermField, defTermColorLabel, defTermColorChoice, defContentLabel, defContentArea});
                break;
            }
            case "image-block": {
                Label imageUrlLabel = new Label("Bild URL / Pfad:");
                TextField imageUrlField = new TextField(this.getStringData(data, "imageUrl"));
                imageUrlField.setPrefColumnCount(40);
                imageUrlField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("imageUrl", newValue);
                });
                Label imageAltLabel = new Label("Alternativer Text (Alt Text):");
                TextField imageAltField = new TextField(this.getStringData(data, "imageAlt"));
                imageAltField.setPrefColumnCount(40);
                imageAltField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("imageAlt", newValue);
                });
                Label imageWidthLabel = new Label("Breite (z.B. 10% oder 150px):");
                TextField imageWidthField = new TextField(this.getStringData(data, "imageWidth"));
                imageWidthField.setPrefColumnCount(10);
                imageWidthField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("imageWidth", newValue);
                });
                Label imageFloatLabel = new Label("Float:");
                ChoiceBox<String> imageFloatChoice = new ChoiceBox<String>(FXCollections.observableArrayList("none", "left", "right"));
                imageFloatChoice.setValue(this.getStringData(data, "imageFloat"));
                imageFloatChoice.valueProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("imageFloat", newValue);
                });
                inputFieldsBox.getChildren().addAll((Node[])new Node[]{imageUrlLabel, imageUrlField, imageAltLabel, imageAltField, imageWidthLabel, imageWidthField, imageFloatLabel, imageFloatChoice});
                break;
            }
            case "download-link-block": {
                Label downloadIconLabel = new Label("Icon Pfad:");
                Label downloadIconPathValueLabel = new Label(this.getStringData(data, "iconUrl"));
                downloadIconPathValueLabel.setStyle("-fx-font-style: italic; -fx-text-fill: gray;");
                Label linkUrlLabel = new Label("Link URL / Pfad:");
                TextField linkUrlField = new TextField(this.getStringData(data, "linkUrl"));
                linkUrlField.setPrefColumnCount(40);
                linkUrlField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("linkUrl", newValue);
                });
                Label fileNameLabel = new Label("Dateiname (f\u00fcr Download):");
                TextField fileNameField = new TextField(this.getStringData(data, "fileName"));
                fileNameField.setPrefColumnCount(40);
                fileNameField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("fileName", newValue);
                });
                Label linkTextLabel = new Label("Link Text:");
                TextField linkTextField = new TextField(this.getStringData(data, "linkText"));
                linkTextField.setPrefColumnCount(40);
                linkTextField.textProperty().addListener((obs, oldValue, newValue) -> {
                    String string = data.put("linkText", newValue);
                });
                inputFieldsBox.getChildren().addAll((Node[])new Node[]{downloadIconLabel, downloadIconPathValueLabel, linkUrlLabel, linkUrlField, fileNameLabel, fileNameField, linkTextLabel, linkTextField});
                break;
            }
            default: {
                inputFieldsBox.getChildren().add(new Label("Kein spezifischer Editor f\u00fcr diesen Block-Typ (" + type + ") verf\u00fcgbar."));
                inputFieldsBox.getChildren().add(new Label("Datenstruktur (nur zur Ansicht):"));
                TextArea rawDataArea = new TextArea(this.gson.toJson(data));
                rawDataArea.setEditable(false);
                rawDataArea.setWrapText(true);
                rawDataArea.setPrefRowCount(5);
                inputFieldsBox.getChildren().addAll((Node[])new Node[]{rawDataArea});
            }
        }
        this.blockDetailsEditorPane.getChildren().add(2, inputFieldsBox);
    }

    private void clearBlockDetailsEditor() {
        this.blockDetailsEditorPane.getChildren().clear();
        this.blockDetailsEditorPane.getChildren().addAll((Node[])new Node[]{this.editorTitleLabel, new HBox(10.0), this.editorButtons});
        this.editorTitleLabel.setText("Block Details Editor");
    }

    private void deleteBlock(Page page, Block block, int index) {
        System.out.println("Aktion: L\u00f6sche Block Index " + index + " (" + block.getType() + ").");
        if (page != null && page.getBlocks() != null) {
            if (index >= 0 && index < page.getBlocks().size()) {
                Block removedBlock = page.getBlocks().remove(index);
                System.out.println("Block '" + removedBlock.getType() + "' bei Index " + index + " aus Daten gel\u00f6scht.");
                this.displayPageBlocks(page);
                System.out.println("UI aktualisiert nach L\u00f6schen.");
            } else {
                System.err.println("Fehler: Ung\u00fcltiger Index " + index + " zum L\u00f6schen.");
            }
        } else {
            System.err.println("Fehler: Seite oder Blockliste ist null beim Versuch zu l\u00f6schen.");
        }
    }

    private void moveBlockUp(Page page, Block block, int index) {
        System.out.println("Aktion: Verschiebe Block nach oben Index " + index + " (" + block.getType() + ").");
        if (page != null && page.getBlocks() != null) {
            if (index > 0 && index < page.getBlocks().size()) {
                Block blockToMove = page.getBlocks().remove(index);
                page.getBlocks().add(index - 1, blockToMove);
                System.out.println("Block von Index " + index + " nach " + (index - 1) + " verschoben.");
                this.displayPageBlocks(page);
                System.out.println("UI aktualisiert nach Verschieben.");
            } else {
                System.err.println("Fehler: Kann Block bei Index " + index + " nicht nach oben verschieben (bereits ganz oben oder ung\u00fcltiger Index).");
            }
        } else {
            System.err.println("Fehler: Seite oder Blockliste ist null beim Versuch zu verschieben.");
        }
    }

    private void moveBlockDown(Page page, Block block, int index) {
        System.out.println("Aktion: Verschiebe Block nach unten Index " + index + " (" + block.getType() + ").");
        if (page != null && page.getBlocks() != null) {
            if (index >= 0 && index < page.getBlocks().size() - 1) {
                Block blockToMove = page.getBlocks().remove(index);
                page.getBlocks().add(index + 1, blockToMove);
                System.out.println("Block von Index " + index + " nach " + (index + 1) + " verschoben.");
                this.displayPageBlocks(page);
                System.out.println("UI aktualisiert nach Verschieben.");
            } else {
                System.err.println("Fehler: Kann Block bei Index " + index + " nicht nach unten verschieben (bereits ganz unten oder ung\u00fcltiger Index).");
            }
        } else {
            System.err.println("Fehler: Seite oder Blockliste ist null beim Versuch zu verschieben.");
        }
    }

    private void selectBlockTypeAndAdd(Page page, int index) {
        System.out.println("Aktion: W\u00e4hle Block-Typ f\u00fcr neue Block an Position " + index + " aus.");
        ChoiceDialog<String> typeDialog = new ChoiceDialog<String>(AVAILABLE_BLOCK_TYPES.get(0), (Collection<String>)AVAILABLE_BLOCK_TYPES);
        typeDialog.setTitle("Neuen Block hinzuf\u00fcgen");
        typeDialog.setHeaderText("W\u00e4hlen Sie den Typ des Blocks aus:");
        typeDialog.setContentText("Block-Typ:");
        Optional result = typeDialog.showAndWait();
        if (result.isPresent()) {
            String selectedType = (String)result.get();
            System.out.println("Ausgew\u00e4hlter Block-Typ: " + selectedType);
            Block newBlock = new Block(selectedType, new HashMap<String, Object>());
            if (page != null && page.getBlocks() != null) {
                if (index >= 0 && index <= page.getBlocks().size()) {
                    page.getBlocks().add(index, newBlock);
                    System.out.println("Neuer Block vom Typ '" + selectedType + "' an Index " + index + " hinzugef\u00fcgt.");
                    this.displayPageBlocks(page);
                    System.out.println("UI aktualisiert nach Hinzuf\u00fcgen.");
                } else {
                    System.err.println("Fehler: Ung\u00fcltiger Index " + index + " zum Hinzuf\u00fcgen.");
                }
            } else {
                System.err.println("Fehler: Seite oder Blockliste ist null beim Versuch hinzuzuf\u00fcgen.");
            }
        } else {
            System.out.println("Block hinzuf\u00fcgen abgebrochen.");
        }
    }

    private Page findPageByTitle(String title) {
        if (this.currentChapter != null && this.currentChapter.getPages() != null) {
            for (Page page : this.currentChapter.getPages()) {
                if (page.getPageTitle() == null || !page.getPageTitle().equals(title)) continue;
                return page;
            }
        }
        return null;
    }

    private void updatePageListView() {
        ObservableList<String> pageTitles = FXCollections.observableArrayList();
        if (this.currentChapter != null && this.currentChapter.getPages() != null) {
            for (Page page : this.currentChapter.getPages()) {
                if (page.getPageTitle() == null) continue;
                pageTitles.add(page.getPageTitle());
            }
        }
        this.pageListView.setItems(pageTitles);
    }

    private String generateHtmlForPage(Page page) {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html>\n<html lang=\"de\">\n<head>\n");
        html.append("    <meta charset=\"UTF-8\">\n");
        html.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n");
        if (page != null && page.getPageTitle() != null) {
            html.append("    <title>").append(this.escapeHtml(page.getPageTitle())).append("</title>\n");
        } else {
            html.append("    <title>Vorschau</title>\n");
        }
        html.append("    <style>\n");
        try {
            html.append("/* styles.css */\n").append(this.readFileContent("C:\\Users\\kmast\\OneDrive\\Desktop\\LIfT Webseite mit KI\\Website\\styles.css")).append("\n");
            html.append("/* styles_content.css */\n").append(this.readFileContent("C:\\Users\\kmast\\OneDrive\\Desktop\\LIfT Webseite mit KI\\Website\\styles_content.css")).append("\n");
            html.append("/* blocks.css */\n").append(this.readFileContent("C:\\Users\\kmast\\OneDrive\\Desktop\\LIfT Webseite mit KI\\Website\\blocks.css")).append("\n");
        }
        catch (IOException e) {
            System.err.println("Fehler beim Lesen der lokalen CSS-Dateien: " + e.getMessage());
            e.printStackTrace();
            html.append("body { background-color: #ffe0e0 !important; color: red !important; } /* Fehlermarkierung */\n");
        }
        html.append("    </style>\n");
        html.append("    <link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/themes/prism-tomorrow.min.css\">\n");
        html.append("    <link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css\">\n");
        html.append("</head>\n<body>\n");
        html.append("\n");
        html.append("<div class=\"content-page\">\n");
        html.append("<aside class=\"sidebar\">Sidebar Platzhalter</aside>\n");
        html.append("<main class=\"main-content\">\n");
        if (page != null && page.getBlocks() != null) {
            for (Block block : page.getBlocks()) {
                html.append(this.renderBlock(block)).append("\n");
            }
        } else {
            html.append("\n");
            html.append("<p>Keine Bl\u00f6cke f\u00fcr diese Seite in den Daten vorhanden.</p>\n");
        }
        html.append("</main>\n");
        html.append("</div>\n");
        html.append("\n");
        html.append("<footer><p style=\"text-align: center; padding: 1em; background-color: #f0f0f0;\">&copy; 2025 Dein CMS - Vorschau Footer</p></footer>\n");
        html.append("    <script src=\"https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/prism.min.js\"></script>\n");
        html.append("    <script src=\"https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-java.min.js\"></script>\n");
        html.append("    <script src=\"https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/components/prism-python.min.js\"></script>\n");
        try {
            html.append("\n<script>\n").append(this.readFileContent("C:\\Users\\kmast\\OneDrive\\Desktop\\LIfT Webseite mit KI\\Website\\script.js")).append("\n</script>\n");
        }
        catch (IOException e) {
            System.err.println("Fehler beim Lesen der lokalen JS-Datei script.js: " + e.getMessage());
            e.printStackTrace();
            html.append("<script>console.error('Fehler beim Laden von script.js');</script>\n");
        }
        html.append("</body>\n</html>");
        return html.toString();
    }

    private String renderBlock(Block block) {
        if (block == null || block.getType() == null || block.getData() == null) {
            return "\n";
        }
        String type = block.getType();
        Map<String, Object> data = block.getData();
        StringBuilder blockHtml = new StringBuilder();
        switch (type) {
            case "heading-block": {
                if (data.containsKey("level") && data.containsKey("text")) {
                    int level = ((Number)data.get("level")).intValue();
                    String text = data.get("text").toString();
                    if (level >= 1 && level <= 6) {
                        blockHtml.append("<div class=\"heading-block\">\n");
                        blockHtml.append("    <h").append(level).append(">").append(text).append("</h").append(level).append(">\n");
                        blockHtml.append("</div>\n");
                        break;
                    }
                    blockHtml.append("\n");
                    blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Ung\u00fcltiges \u00dcberschriften-Level: ").append(level).append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr heading-block</div>\n");
                break;
            }
            case "text-block": {
                if (data.containsKey("content")) {
                    blockHtml.append("<div class=\"text-block\">\n");
                    blockHtml.append(data.get("content").toString()).append("\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr text-block</div>\n");
                break;
            }
            case "definition-block": {
                if (data.containsKey("iconUrl") && data.containsKey("prefix") && data.containsKey("term") && data.containsKey("termColorClass") && data.containsKey("definitionContent")) {
                    String iconUrl = data.get("iconUrl").toString();
                    String prefix = data.get("prefix").toString();
                    String term = data.get("term").toString();
                    String termColorClass = data.get("termColorClass").toString();
                    String definitionContent = data.get("definitionContent").toString();
                    blockHtml.append("<div class=\"definition-block\">\n");
                    blockHtml.append("    <img src=\"").append(iconUrl).append("\" alt=\"Definition Icon\" class=\"definition-icon-floated\">\n");
                    blockHtml.append("    <div class=\"definition-header\">\n");
                    blockHtml.append("        <div class=\"title-content\">\n");
                    blockHtml.append("            <span class=\"prefix\">").append(prefix).append("</span>\n");
                    blockHtml.append("            <span class=\"").append(termColorClass).append("\">").append(term).append("</span>\n");
                    blockHtml.append("        </div>\n");
                    blockHtml.append("    </div>\n");
                    blockHtml.append("    <div class=\"definition-body\">\n");
                    blockHtml.append(definitionContent).append("\n");
                    blockHtml.append("    </div>\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr definition-block</div>\n");
                break;
            }
            case "code-block": {
                if (data.containsKey("header") && data.containsKey("language") && data.containsKey("code")) {
                    String header = data.get("header").toString();
                    String language = data.get("language").toString();
                    String code = data.get("code").toString();
                    blockHtml.append("<div class=\"code-container\">\n");
                    blockHtml.append("    <div class=\"code-header\">").append(header).append("</div>\n");
                    blockHtml.append("    <pre><code class=\"language-").append(language).append("\">\n");
                    blockHtml.append(this.escapeHtml(code));
                    blockHtml.append("\n</code></pre>\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr code-block</div>\n");
                break;
            }
            case "task-block": {
                if (data.containsKey("iconUrl") && data.containsKey("themeClass") && data.containsKey("title") && data.containsKey("tasks")) {
                    String iconUrl = data.get("iconUrl").toString();
                    String themeClass = data.get("themeClass").toString();
                    String title = data.get("title").toString();
                    List tasksList = (List)data.get("tasks");
                    blockHtml.append("<div class=\"task-block ").append(themeClass).append("\">\n");
                    blockHtml.append("    <img src=\"").append(iconUrl).append("\" alt=\"\u00dcbung Icon\" class=\"task-icon-floated\">\n");
                    blockHtml.append("    <div class=\"task-header\">\n");
                    blockHtml.append("        <span class=\"prefix\">\u00dcbung -</span>\n");
                    blockHtml.append("        <span class=\"title\">").append(title).append("</span>\n");
                    blockHtml.append("    </div>\n");
                    blockHtml.append("    <div class=\"task-body\">\n");
                    if (tasksList != null) {
                        for (Object taskObj : tasksList) {
                            if (!(taskObj instanceof Map)) continue;
                            Map taskData = (Map)taskObj;
                            if (taskData.containsKey("title") && taskData.containsKey("taskContent")) {
                                String taskTitle = taskData.get("title").toString();
                                String taskContent = taskData.get("taskContent").toString();
                                boolean isTeacherContent = taskData.getOrDefault("isTeacherContent", false);
                                blockHtml.append("        <div class=\"task-item\">\n");
                                blockHtml.append("            <h4>").append(taskTitle).append("</h4>\n");
                                blockHtml.append(taskContent).append("\n");
                                if (taskData.containsKey("solutionContent")) {
                                    String solutionContent = taskData.get("solutionContent").toString();
                                    blockHtml.append("            <div class=\"teacher-content solution-box\">\n");
                                    blockHtml.append("                <h5>L\u00f6sung</h5>\n");
                                    blockHtml.append(solutionContent).append("\n");
                                    blockHtml.append("            </div>\n");
                                }
                                blockHtml.append("        </div>\n");
                                continue;
                            }
                            blockHtml.append("\n");
                            blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr task-item</div>\n");
                        }
                    }
                    blockHtml.append("    </div>\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr task-block</div>\n");
                break;
            }
            case "collapsible-block": {
                if (data.containsKey("iconUrl") && data.containsKey("themeClass") && data.containsKey("title") && data.containsKey("content") && data.containsKey("isInitiallyOpen")) {
                    String iconUrl = data.get("iconUrl").toString();
                    String themeClass = data.get("themeClass").toString();
                    String title = data.get("title").toString();
                    String content = data.get("content").toString();
                    boolean isInitiallyOpen = (Boolean)data.get("isInitiallyOpen");
                    String activeClass = isInitiallyOpen ? " active" : "";
                    blockHtml.append("<div class=\"collapsible-task-block ").append(themeClass).append(activeClass).append("\">\n");
                    blockHtml.append("    <img src=\"").append(iconUrl).append("\" alt=\"Icon Beschreibung\" class=\"collapsible-icon-floated\">\n");
                    blockHtml.append("    <div class=\"collapsible-header\">\n");
                    blockHtml.append("        <span class=\"title\">").append(title).append("</span>\n");
                    blockHtml.append("        <i class=\"fas fa-chevron-up toggle-icon\"></i>\n");
                    blockHtml.append("    </div>\n");
                    blockHtml.append("    <div class=\"collapsible-content\">\n");
                    blockHtml.append(content).append("\n");
                    blockHtml.append("    </div>\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr collapsible-block</div>\n");
                break;
            }
            case "test-block": {
                if (data.containsKey("iconUrl") && data.containsKey("themeClass") && data.containsKey("title") && data.containsKey("testItems")) {
                    String iconUrl = data.get("iconUrl").toString();
                    String themeClass = data.get("themeClass").toString();
                    String title = data.get("title").toString();
                    List testItemsList = (List)data.get("testItems");
                    blockHtml.append("<div class=\"test-block ").append(themeClass).append("\">\n");
                    blockHtml.append("    <img src=\"").append(iconUrl).append("\" alt=\"Test Icon\" class=\"test-icon-floated\">\n");
                    blockHtml.append("    <h3>").append(title).append("</h3>\n");
                    if (testItemsList != null) {
                        for (Object itemObj : testItemsList) {
                            if (!(itemObj instanceof Map)) continue;
                            Map itemData = (Map)itemObj;
                            if (itemData.containsKey("title") && itemData.containsKey("taskContent")) {
                                String itemTitle = itemData.get("title").toString();
                                String itemTaskContent = itemData.get("taskContent").toString();
                                blockHtml.append("        <div class=\"test-item\">\n");
                                blockHtml.append("            <h4>").append(itemTitle).append("</h4>\n");
                                blockHtml.append(itemTaskContent).append("\n");
                                if (itemData.containsKey("solutionContent")) {
                                    String itemSolutionContent = itemData.get("solutionContent").toString();
                                    blockHtml.append("            <div class=\"solution-toggle\">L\u00f6sung anzeigen\n");
                                    blockHtml.append("                <i class=\"fas fa-chevron-down toggle-icon\"></i>\n");
                                    blockHtml.append("            </div>\n");
                                    blockHtml.append("            <div class=\"solution-content\">\n");
                                    blockHtml.append(itemSolutionContent).append("\n");
                                    blockHtml.append("            </div>\n");
                                }
                                blockHtml.append("        </div>\n");
                                continue;
                            }
                            blockHtml.append("\n");
                            blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr test-item</div>\n");
                        }
                    }
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr test-block</div>\n");
                break;
            }
            case "video-block": {
                if (data.containsKey("iconUrl") && data.containsKey("themeClass") && data.containsKey("title") && data.containsKey("videoType") && data.containsKey("videoSource")) {
                    String iconUrl = data.get("iconUrl").toString();
                    String themeClass = data.get("themeClass").toString();
                    String title = data.get("title").toString();
                    String videoType = data.get("videoType").toString();
                    String videoSource = data.get("videoSource").toString();
                    String captionContent = data.containsKey("captionContent") ? data.get("captionContent").toString() : "";
                    boolean isInitiallyOpen = (Boolean)data.getOrDefault("isInitiallyOpen", false);
                    String activeClass = isInitiallyOpen ? " active" : "";
                    blockHtml.append("<div class=\"video-block ").append(themeClass).append(activeClass).append("\">\n");
                    blockHtml.append("    <img src=\"").append(iconUrl).append("\" alt=\"Video Icon\" class=\"video-icon-floated\">\n");
                    blockHtml.append("    <div class=\"video-block-toggle\">\n");
                    blockHtml.append("        <span class=\"title\">").append(title).append("</span>\n");
                    blockHtml.append("        <i class=\"fas fa-chevron-down toggle-icon\"></i>\n");
                    blockHtml.append("    </div>\n");
                    blockHtml.append("    <div class=\"video-block-content\">\n");
                    blockHtml.append("        <div class=\"video-container\">\n");
                    if ("youtube".equals(videoType)) {
                        String embedUrl = videoSource;
                        blockHtml.append("            <iframe\n");
                        blockHtml.append("                src=\"").append(embedUrl).append("\"\n");
                        blockHtml.append("                frameborder=\"0\"\n");
                        blockHtml.append("                allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\"\n");
                        blockHtml.append("                allowfullscreen>\n");
                        blockHtml.append("            </iframe>\n");
                    } else if ("local".equals(videoType)) {
                        blockHtml.append("            <video controls>\n");
                        blockHtml.append("                <source src=\"").append(videoSource).append("\" type=\"video/mp4\">");
                        blockHtml.append("                Dein Browser unterst\u00fctzt das Video-Tag nicht.\n");
                        blockHtml.append("            </video>\n");
                    } else {
                        blockHtml.append("\n");
                        blockHtml.append("<p style=\"color: red;\">Unbekannter Video-Typ: ").append(videoType).append("</p>\n");
                    }
                    blockHtml.append("        </div>\n");
                    if (!captionContent.isEmpty()) {
                        blockHtml.append(captionContent).append("\n");
                    }
                    blockHtml.append("    </div>\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr video-block</div>\n");
                break;
            }
            case "text-image-block": {
                if (data.containsKey("imageUrl") && data.containsKey("imageAlt") && data.containsKey("imageWidth") && data.containsKey("imageFloat") && data.containsKey("textContent")) {
                    String imageUrl = data.get("imageUrl").toString();
                    String imageAlt = data.get("imageAlt").toString();
                    String imageWidth = data.get("imageWidth").toString();
                    String imageFloat = data.get("imageFloat").toString();
                    String textContent = data.get("textContent").toString();
                    String floatClass = "";
                    if ("left".equals(imageFloat)) {
                        floatClass = "image-float-left";
                    } else if ("right".equals(imageFloat)) {
                        floatClass = "image-float-right";
                    } else {
                        blockHtml.append("\n");
                        blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Ung\u00fcltiger imageFloat Wert: ").append(imageFloat).append("</div>\n");
                        break;
                    }
                    blockHtml.append("<div class=\"text-image-block\">\n");
                    blockHtml.append("    <img src=\"").append(imageUrl).append("\" alt=\"").append(imageAlt).append("\" class=\"").append(floatClass).append("\" width=\"").append(imageWidth).append("\">\n");
                    blockHtml.append(textContent).append("\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr text-image-block</div>\n");
                break;
            }
            case "image-row-block": {
                if (data.containsKey("images")) {
                    List imagesList = (List)data.get("images");
                    blockHtml.append("<div class=\"image-row-block\">\n");
                    blockHtml.append("    <div class=\"image-row-container\">\n");
                    if (imagesList != null) {
                        for (Object imgObj : imagesList) {
                            if (!(imgObj instanceof Map)) continue;
                            Map imgData = (Map)imgObj;
                            if (imgData.containsKey("imageUrl") && imgData.containsKey("altText")) {
                                String imageUrl = imgData.get("imageUrl").toString();
                                String altText = imgData.get("altText").toString();
                                String caption = imgData.containsKey("caption") ? imgData.get("caption").toString() : "";
                                blockHtml.append("        <figure>\n");
                                blockHtml.append("            <img src=\"").append(imageUrl).append("\" alt=\"").append(altText).append("\">\n");
                                if (!caption.isEmpty()) {
                                    blockHtml.append("            <figcaption>").append(caption).append("</figcaption>\n");
                                }
                                blockHtml.append("        </figure>\n");
                                continue;
                            }
                            blockHtml.append("\n");
                            blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr Bild in image-row-block</div>\n");
                        }
                    }
                    blockHtml.append("    </div>\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr image-row-block</div>\n");
                break;
            }
            case "gallery-block": {
                if (data.containsKey("images")) {
                    String title = data.containsKey("title") ? data.get("title").toString() : "";
                    List imagesList = (List)data.get("images");
                    blockHtml.append("<div class=\"gallery-block\">\n");
                    if (!title.isEmpty()) {
                        blockHtml.append("    <h3>").append(title).append("</h3>\n");
                    }
                    blockHtml.append("    <div class=\"gallery-container\">\n");
                    blockHtml.append("        <div class=\"gallery-images-container\">\n");
                    if (imagesList != null) {
                        for (Object imgObj : imagesList) {
                            if (!(imgObj instanceof Map)) continue;
                            Map imgData = (Map)imgObj;
                            if (imgData.containsKey("imageUrl") && imgData.containsKey("altText")) {
                                String imageUrl = imgData.get("imageUrl").toString();
                                String altText = imgData.get("altText").toString();
                                String caption = imgData.containsKey("caption") ? imgData.get("caption").toString() : "";
                                blockHtml.append("            <div class=\"gallery-image-slide\">\n");
                                blockHtml.append("                <figure>\n");
                                blockHtml.append("                    <img src=\"").append(imageUrl).append("\" alt=\"").append(altText).append("\">\n");
                                if (!caption.isEmpty()) {
                                    blockHtml.append("                    <figcaption>").append(caption).append("</figcaption>\n");
                                }
                                blockHtml.append("                </figure>\n");
                                blockHtml.append("            </div>\n");
                                continue;
                            }
                            blockHtml.append("\n");
                            blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr Bild in gallery-block</div>\n");
                        }
                    }
                    blockHtml.append("        </div>\n");
                    blockHtml.append("        <div class=\"gallery-nav\">\n");
                    blockHtml.append("            <div class=\"gallery-arrow arrow-left\"><i class=\"fas fa-chevron-left\"></i></div>\n");
                    blockHtml.append("            <div class=\"gallery-arrow arrow-right\"><i class=\"fas fa-chevron-right\"></i></div>\n");
                    blockHtml.append("        </div>\n");
                    blockHtml.append("    </div>\n");
                    blockHtml.append("    <div class=\"gallery-dots\"></div>\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr gallery-block</div>\n");
                break;
            }
            case "table-block": {
                if (data.containsKey("tableHtml")) {
                    String tableHtml = data.get("tableHtml").toString();
                    boolean isBordered = (Boolean)data.getOrDefault("isBordered", false);
                    boolean isShaded = (Boolean)data.getOrDefault("isShaded", false);
                    boolean isHeaderHighlighted = (Boolean)data.getOrDefault("isHeaderHighlighted", false);
                    StringBuilder classes = new StringBuilder("table-block");
                    if (isBordered) {
                        classes.append(" bordered");
                    }
                    if (isShaded) {
                        classes.append(" shaded");
                    }
                    if (isHeaderHighlighted) {
                        classes.append(" header-highlight");
                    }
                    blockHtml.append("<div class=\"").append(classes.toString().trim()).append("\">\n");
                    blockHtml.append(tableHtml).append("\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr table-block</div>\n");
                break;
            }
            case "download-link-block": {
                if (data.containsKey("iconUrl") && data.containsKey("linkUrl") && data.containsKey("fileName")) {
                    String iconUrl = data.get("iconUrl").toString();
                    String linkUrl = data.get("linkUrl").toString();
                    String fileName = data.get("fileName").toString();
                    String linkText = data.containsKey("linkText") ? data.get("linkText").toString() : "";
                    blockHtml.append("<p>\n");
                    blockHtml.append("    Hier ist ein wichtiger\n");
                    blockHtml.append("    <a href=\"").append(linkUrl).append("\" download=\"").append(fileName).append("\">\n");
                    blockHtml.append("        <img src=\"").append(iconUrl).append("\" alt=\"Download Symbol\" class=\"download-icon\">\n");
                    if (!linkText.isEmpty()) {
                        blockHtml.append(" ").append(linkText);
                    }
                    blockHtml.append("    </a>\n");
                    blockHtml.append("</p>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr download-link-block</div>\n");
                break;
            }
            case "subtopics-overview-block": {
                if (this.currentChapter != null && this.currentChapter.getPages() != null) {
                    String introText = data.containsKey("introText") ? data.get("introText").toString() : "";
                    blockHtml.append("<div class=\"subtopics-container\">\n");
                    if (!introText.isEmpty()) {
                        blockHtml.append("\n");
                        blockHtml.append("<div style=\"border: 1px dashed blue; padding: 1em; margin: 1em 0;\">");
                        blockHtml.append("<h2>Unterthemen-\u00dcbersicht (Vorschau)</h2>");
                        blockHtml.append("<p>Hier werden die Kacheln f\u00fcr die Seiten des Kapitels angezeigt.</p>");
                        blockHtml.append("<div style=\"display: flex; flex-wrap: wrap; gap: 10px;\">");
                        blockHtml.append("<div style=\"border: 1px solid #ccc; padding: 10px;\">Kachel Seite 1</div>");
                        blockHtml.append("<div style=\"border: 1px solid #ccc; padding: 10px;\">Kachel Seite 2</div>");
                        blockHtml.append("</div>");
                        blockHtml.append("</div>\n");
                    } else {
                        blockHtml.append("\n");
                        blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Chapter/Pages Daten f\u00fcr subtopics-overview-block</div>\n");
                    }
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr subtopics-overview-block</div>\n");
                break;
            }
            case "teacher-content-block": {
                if (data.containsKey("content")) {
                    blockHtml.append("<div class=\"teacher-content\">\n");
                    blockHtml.append(data.get("content").toString()).append("\n");
                    blockHtml.append("</div>\n");
                    break;
                }
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed orange; padding: 0.5em;\">Fehlende Daten f\u00fcr teacher-content-block</div>\n");
                break;
            }
            default: {
                blockHtml.append("\n");
                blockHtml.append("<div style=\"border: 1px dashed red; padding: 1em; margin: 1em 0;\">Unbekannter Block-Typ: <strong>").append(type).append("</strong></div>\n");
            }
        }
        return blockHtml.toString();
    }

    private String escapeHtml(String text) {
        return "";
    }

    private String readFileContent(String filePath) throws IOException {
        return "";
    }

    public static void main(String[] args) {
        CmsApplication.launch(args);
    }
}

