/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import java.util.Objects;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.util.Duration;

public final class TransitionEvent
extends Event {
    private static final long serialVersionUID = 1L;
    public static final EventType<TransitionEvent> ANY = new EventType<Event>(Event.ANY, "TRANSITION");
    public static final EventType<TransitionEvent> RUN = new EventType<TransitionEvent>(ANY, "TRANSITION_RUN");
    public static final EventType<TransitionEvent> START = new EventType<TransitionEvent>(ANY, "TRANSITION_START");
    public static final EventType<TransitionEvent> END = new EventType<TransitionEvent>(ANY, "TRANSITION_END");
    public static final EventType<TransitionEvent> CANCEL = new EventType<TransitionEvent>(ANY, "TRANSITION_CANCEL");
    private final StyleableProperty<?> property;
    private final String propertyName;
    private final Duration elapsedTime;

    @Deprecated(since="24", forRemoval=true)
    public TransitionEvent(EventType<? extends Event> eventType, StyleableProperty<?> styleableProperty, Duration duration) {
        this(eventType, styleableProperty, styleableProperty.getCssMetaData().getProperty(), duration);
    }

    public TransitionEvent(EventType<? extends Event> eventType, StyleableProperty<?> styleableProperty, String string, Duration duration) {
        super(Objects.requireNonNull(eventType, "eventType cannot be null"));
        this.property = Objects.requireNonNull(styleableProperty, "property cannot be null");
        this.propertyName = Objects.requireNonNull(string, "propertyName cannot be null");
        this.elapsedTime = Objects.requireNonNull(duration, "elapsedTime cannot be null");
    }

    public StyleableProperty<?> getProperty() {
        return this.property;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Duration getElapsedTime() {
        return this.elapsedTime;
    }
}

