/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.input;

import com.sun.javafx.ModuleUtil;
import com.sun.jfx.incubator.scene.control.input.EventHandlerPriority;
import com.sun.jfx.incubator.scene.control.input.InputMapHelper;
import com.sun.jfx.incubator.scene.control.input.KeyEventMapper;
import com.sun.jfx.incubator.scene.control.input.PHList;
import com.sun.jfx.incubator.scene.control.input.SkinInputMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.Control;
import javafx.scene.input.KeyEvent;
import jfx.incubator.scene.control.input.FunctionTag;
import jfx.incubator.scene.control.input.KeyBinding;

public final class InputMap {
    private static final Object NULL = new Object();
    private final Control control;
    private final HashMap<Object, Object> map = new HashMap();
    private SkinInputMap skinInputMap;
    private final KeyEventMapper kmapper = new KeyEventMapper();
    private final EventHandler<Event> eventHandler = this::handleEvent;

    public InputMap(Control control) {
        this.control = control;
    }

    public <T extends Event> void addHandler(EventType<T> eventType, EventHandler<T> eventHandler) {
        this.extendHandler(eventType, eventHandler, EventHandlerPriority.USER_HIGH);
    }

    public <T extends Event> void removeHandler(EventType<T> eventType, EventHandler<T> eventHandler) {
        PHList pHList;
        Object object = this.map.get(eventType);
        if (object instanceof PHList && (pHList = (PHList)object).remove(eventHandler)) {
            this.map.remove(eventType);
            this.control.removeEventHandler(eventType, this.eventHandler);
        }
    }

    private <T extends Event> void removeHandler(EventType<T> eventType, EventHandlerPriority eventHandlerPriority) {
        PHList pHList;
        Object object = this.map.get(eventType);
        if (object instanceof PHList && (pHList = (PHList)object).removeHandlers(Set.of(eventHandlerPriority))) {
            this.map.remove(eventType);
            this.control.removeEventHandler(eventType, this.eventHandler);
        }
    }

    private <T extends Event> void extendHandler(EventType<T> eventType, EventHandler<T> eventHandler, EventHandlerPriority eventHandlerPriority) {
        PHList pHList;
        Object object = this.map.get(eventType);
        if (object instanceof PHList) {
            PHList pHList2;
            pHList = pHList2 = (PHList)object;
        } else {
            pHList = new PHList();
            this.map.put(eventType, pHList);
            this.control.addEventHandler(eventType, this.eventHandler);
        }
        pHList.add(eventHandlerPriority, eventHandler);
    }

    private void handleEvent(Event event) {
        if (event == null || event.isConsumed()) {
            return;
        }
        EventType<? extends Event> eventType = event.getEventType();
        Object object = this.map.get(eventType);
        if (object instanceof PHList) {
            PHList pHList = (PHList)object;
            pHList.forEach((eventHandlerPriority, eventHandler) -> {
                if (eventHandler == null) {
                    this.handleKeyBindingEvent(event);
                } else {
                    eventHandler.handle(event);
                }
                return !event.isConsumed();
            });
        }
    }

    private void handleKeyBindingEvent(Event event) {
        boolean bl;
        if (event == null || event.isConsumed()) {
            return;
        }
        KeyBinding keyBinding = KeyBinding.from((KeyEvent)event);
        if (keyBinding != null && (bl = this.execute(event.getSource(), keyBinding))) {
            event.consume();
        }
    }

    private boolean execute(Object object, KeyBinding keyBinding) {
        Object object2 = this.resolve(keyBinding);
        if (object2 instanceof FunctionTag) {
            FunctionTag functionTag = (FunctionTag)object2;
            return this.execute(object, functionTag);
        }
        if (object2 instanceof BooleanSupplier) {
            BooleanSupplier booleanSupplier = (BooleanSupplier)object2;
            return booleanSupplier.getAsBoolean();
        }
        if (object2 instanceof Runnable) {
            Runnable runnable = (Runnable)object2;
            runnable.run();
            return true;
        }
        return false;
    }

    boolean execute(Object object, FunctionTag functionTag) {
        Object object2 = this.map.get(functionTag);
        if (object2 instanceof Runnable) {
            Runnable runnable = (Runnable)object2;
            runnable.run();
            return true;
        }
        return this.executeDefault(object, functionTag);
    }

    boolean executeDefault(Object object, FunctionTag functionTag) {
        if (this.skinInputMap != null) {
            return this.skinInputMap.execute(object, functionTag);
        }
        return false;
    }

    private Object resolve(KeyBinding keyBinding) {
        Object object = this.map.get(keyBinding);
        if (object != null) {
            return object;
        }
        if (this.skinInputMap != null) {
            return this.skinInputMap.resolve(keyBinding);
        }
        return null;
    }

    public void register(KeyBinding keyBinding, Runnable runnable) {
        Objects.requireNonNull(keyBinding, "key binding must not be null");
        Objects.requireNonNull(runnable, "function must not be null");
        this.map.put(keyBinding, runnable);
    }

    public void registerFunction(FunctionTag functionTag, Runnable runnable) {
        Objects.requireNonNull(functionTag, "function tag must not be null");
        Objects.requireNonNull(runnable, "function must not be null");
        this.map.put(functionTag, runnable);
    }

    public void registerKey(KeyBinding keyBinding, FunctionTag functionTag) {
        Objects.requireNonNull(keyBinding, "KeyBinding must not be null");
        Objects.requireNonNull(functionTag, "function tag must not be null");
        this.map.put(keyBinding, functionTag);
        EventType<KeyEvent> eventType = this.kmapper.addType(keyBinding);
        this.extendHandler(eventType, null, EventHandlerPriority.USER_KB);
    }

    public void disableKeyBinding(KeyBinding keyBinding) {
        this.map.put(keyBinding, NULL);
    }

    public void resetKeyBindings() {
        Iterator<Map.Entry<Object, Object>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (!(entry.getKey() instanceof KeyBinding)) continue;
            iterator.remove();
        }
    }

    public void restoreDefaultKeyBinding(KeyBinding keyBinding) {
        Object object = this.map.get(keyBinding);
        if (object != null) {
            this.map.remove(keyBinding);
        }
    }

    public void restoreDefaultFunction(FunctionTag functionTag) {
        Objects.requireNonNull(functionTag, "function tag must not be null");
        this.map.remove(functionTag);
    }

    public Set<KeyBinding> getKeyBindings() {
        return this.collectKeyBindings(null);
    }

    public Set<KeyBinding> getKeyBindingsFor(FunctionTag functionTag) {
        return this.collectKeyBindings(functionTag);
    }

    private Set<KeyBinding> collectKeyBindings(FunctionTag functionTag) {
        HashSet<KeyBinding> hashSet = new HashSet<KeyBinding>();
        for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
            Object object = entry.getKey();
            if (!(object instanceof KeyBinding)) continue;
            KeyBinding keyBinding = (KeyBinding)object;
            if (functionTag != null && functionTag != entry.getValue()) continue;
            hashSet.add(keyBinding);
        }
        if (this.skinInputMap != null) {
            this.skinInputMap.collectKeyBindings(hashSet, functionTag);
        }
        return hashSet;
    }

    public void removeKeyBindingsFor(FunctionTag functionTag) {
        if (this.skinInputMap != null) {
            this.skinInputMap.unbind(functionTag);
        }
        Iterator<Map.Entry<Object, Object>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (functionTag != entry.getValue() || !(entry.getKey() instanceof KeyBinding)) continue;
            iterator.remove();
        }
    }

    private void setSkinInputMap(SkinInputMap skinInputMap) {
        if (this.skinInputMap != null) {
            Iterator<Map.Entry<Object, Object>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                Object object = entry.getKey();
                if (!(object instanceof EventType)) continue;
                EventType eventType2 = (EventType)object;
                object = (PHList)entry.getValue();
                if (!((PHList)object).removeHandlers(EventHandlerPriority.ALL_SKIN)) continue;
                iterator.remove();
                this.control.removeEventHandler(eventType2, this.eventHandler);
            }
        }
        this.skinInputMap = skinInputMap;
        if (this.skinInputMap != null) {
            this.skinInputMap.forEach((eventType, eventHandlerPriority, eventHandler) -> this.extendHandler(eventType, eventHandler, eventHandlerPriority));
            if (!this.kmapper.hasKeyPressed() && this.skinInputMap.kmapper.hasKeyPressed()) {
                this.extendHandler(KeyEvent.KEY_PRESSED, null, EventHandlerPriority.SKIN_KB);
            }
            if (!this.kmapper.hasKeyReleased() && this.skinInputMap.kmapper.hasKeyReleased()) {
                this.extendHandler(KeyEvent.KEY_RELEASED, null, EventHandlerPriority.SKIN_KB);
            }
            if (!this.kmapper.hasKeyTyped() && this.skinInputMap.kmapper.hasKeyTyped()) {
                this.extendHandler(KeyEvent.KEY_TYPED, null, EventHandlerPriority.SKIN_KB);
            }
        }
    }

    private static void initAccessor() {
        InputMapHelper.setAccessor(new InputMapHelper.Accessor(){

            @Override
            public void executeDefault(Object object, InputMap inputMap, FunctionTag functionTag) {
                inputMap.executeDefault(object, functionTag);
            }

            @Override
            public void execute(Object object, InputMap inputMap, FunctionTag functionTag) {
                inputMap.execute(object, functionTag);
            }

            @Override
            public void setSkinInputMap(InputMap inputMap, SkinInputMap skinInputMap) {
                inputMap.setSkinInputMap(skinInputMap);
            }
        });
    }

    static {
        ModuleUtil.incubatorWarning();
        InputMap.initAccessor();
    }
}

