/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.input;

import com.sun.javafx.PlatformUtil;
import java.util.EnumSet;
import java.util.Objects;
import javafx.event.EventType;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class KeyBinding {
    private final Object key;
    private final EnumSet<KCondition> modifiers;

    private KeyBinding(Object object, EnumSet<KCondition> enumSet) {
        this.key = object;
        this.modifiers = enumSet;
    }

    public static KeyBinding of(KeyCode keyCode) {
        return KeyBinding.create((Object)keyCode, KCondition.KEY_PRESSED);
    }

    public static KeyBinding command(KeyCode keyCode) {
        return KeyBinding.create((Object)keyCode, KCondition.KEY_PRESSED, KCondition.COMMAND);
    }

    public static KeyBinding alt(KeyCode keyCode) {
        return KeyBinding.create((Object)keyCode, KCondition.KEY_PRESSED, KCondition.ALT);
    }

    public static KeyBinding control(KeyCode keyCode) {
        return KeyBinding.create((Object)keyCode, KCondition.KEY_PRESSED, KCondition.CTRL);
    }

    public static KeyBinding controlShift(KeyCode keyCode) {
        return KeyBinding.create((Object)keyCode, KCondition.KEY_PRESSED, KCondition.CTRL, KCondition.SHIFT);
    }

    public static KeyBinding option(KeyCode keyCode) {
        return KeyBinding.create((Object)keyCode, KCondition.KEY_PRESSED, KCondition.OPTION);
    }

    public static KeyBinding shift(KeyCode keyCode) {
        return KeyBinding.create((Object)keyCode, KCondition.KEY_PRESSED, KCondition.SHIFT);
    }

    public static KeyBinding shortcut(KeyCode keyCode) {
        return KeyBinding.create((Object)keyCode, KCondition.KEY_PRESSED, KCondition.SHORTCUT);
    }

    public static KeyBinding shiftOption(KeyCode keyCode) {
        return KeyBinding.create((Object)keyCode, KCondition.KEY_PRESSED, KCondition.SHIFT, KCondition.OPTION);
    }

    public static KeyBinding shiftShortcut(KeyCode keyCode) {
        return KeyBinding.create((Object)keyCode, KCondition.KEY_PRESSED, KCondition.SHIFT, KCondition.SHORTCUT);
    }

    public KeyBinding withNewKeyCode(KeyCode keyCode) {
        return new KeyBinding((Object)keyCode, this.modifiers);
    }

    private static KeyBinding create(Object object, KCondition ... kConditionArray) {
        return new Builder(object).init(kConditionArray).build();
    }

    public boolean isKeyPressed() {
        return this.modifiers.contains((Object)KCondition.KEY_PRESSED);
    }

    public boolean isKeyReleased() {
        return this.modifiers.contains((Object)KCondition.KEY_RELEASED);
    }

    public boolean isKeyTyped() {
        return this.modifiers.contains((Object)KCondition.KEY_TYPED);
    }

    public KeyCode getKeyCode() {
        Object object = this.key;
        if (object instanceof KeyCode) {
            KeyCode keyCode = (KeyCode)((Object)object);
            return keyCode;
        }
        return null;
    }

    public static Builder builder(KeyCode keyCode) {
        return new Builder((Object)keyCode);
    }

    public static Builder builder(String string) {
        return new Builder(string);
    }

    public int hashCode() {
        int n = KeyBinding.class.hashCode();
        n = 31 * n + this.key.hashCode();
        n = 31 * n + this.modifiers.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof KeyBinding) {
            KeyBinding keyBinding = (KeyBinding)object;
            return Objects.equals(this.key, keyBinding.key) && this.modifiers.equals(keyBinding.modifiers);
        }
        return false;
    }

    static KeyBinding from(KeyEvent keyEvent) {
        Object object;
        EnumSet<KCondition> enumSet = EnumSet.noneOf(KCondition.class);
        EventType<KeyEvent> eventType = keyEvent.getEventType();
        if (eventType == KeyEvent.KEY_PRESSED) {
            enumSet.add(KCondition.KEY_PRESSED);
            object = keyEvent.getCode();
        } else if (eventType == KeyEvent.KEY_RELEASED) {
            enumSet.add(KCondition.KEY_RELEASED);
            object = keyEvent.getCode();
        } else if (eventType == KeyEvent.KEY_TYPED) {
            enumSet.add(KCondition.KEY_TYPED);
            object = keyEvent.getCharacter();
        } else {
            return null;
        }
        boolean bl = keyEvent.isAltDown();
        boolean bl2 = keyEvent.isControlDown();
        boolean bl3 = keyEvent.isMetaDown();
        boolean bl4 = keyEvent.isShortcutDown();
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = PlatformUtil.isMac();
        boolean bl8 = PlatformUtil.isWindows();
        if (bl7) {
            if (bl) {
                bl = false;
                bl5 = true;
            }
            if (bl4) {
                bl3 = false;
                bl6 = true;
            }
        } else if (bl2) {
            bl4 = false;
        }
        if (bl) {
            enumSet.add(KCondition.ALT);
        }
        if (bl6) {
            enumSet.add(KCondition.COMMAND);
        }
        if (bl2) {
            enumSet.add(KCondition.CTRL);
        }
        if (bl3) {
            enumSet.add(KCondition.META);
        }
        if (bl5) {
            enumSet.add(KCondition.OPTION);
        }
        if (keyEvent.isShiftDown()) {
            enumSet.add(KCondition.SHIFT);
        }
        KeyBinding keyBinding = new KeyBinding(object, enumSet);
        return keyBinding;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("KeyBinding{key=");
        stringBuilder.append(this.key);
        stringBuilder.append(", modifiers=");
        stringBuilder.append(this.modifiers);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static enum KCondition {
        ALT,
        COMMAND,
        CTRL,
        META,
        OPTION,
        SHIFT,
        SHORTCUT,
        WINDOWS,
        KEY_PRESSED,
        KEY_RELEASED,
        KEY_TYPED;

    }

    public static class Builder {
        private final Object key;
        private final EnumSet<KCondition> m = EnumSet.noneOf(KCondition.class);

        Builder(Object object) {
            this.key = object;
        }

        public Builder keyReleased() {
            this.m.remove((Object)KCondition.KEY_PRESSED);
            this.m.remove((Object)KCondition.KEY_TYPED);
            this.m.add(KCondition.KEY_RELEASED);
            return this;
        }

        public Builder keyTyped() {
            this.m.remove((Object)KCondition.KEY_PRESSED);
            this.m.add(KCondition.KEY_TYPED);
            this.m.remove((Object)KCondition.KEY_RELEASED);
            return this;
        }

        public Builder alt() {
            this.m.add(KCondition.ALT);
            return this;
        }

        public Builder command() {
            this.m.add(KCondition.COMMAND);
            return this;
        }

        public Builder control() {
            this.m.add(KCondition.CTRL);
            return this;
        }

        public Builder meta() {
            this.m.add(KCondition.META);
            return this;
        }

        public Builder option() {
            this.m.add(KCondition.OPTION);
            return this;
        }

        public Builder shift() {
            this.m.add(KCondition.SHIFT);
            return this;
        }

        public Builder shortcut() {
            this.m.add(KCondition.SHORTCUT);
            return this;
        }

        private Builder init(KCondition ... kConditionArray) {
            for (KCondition kCondition : kConditionArray) {
                this.m.add(kCondition);
            }
            return this;
        }

        private void replace(KCondition kCondition, KCondition kCondition2) {
            if (this.m.contains((Object)kCondition)) {
                this.m.remove((Object)kCondition);
                this.m.add(kCondition2);
            }
        }

        public KeyBinding build() {
            boolean bl = PlatformUtil.isMac();
            boolean bl2 = PlatformUtil.isWindows();
            boolean bl3 = PlatformUtil.isLinux();
            if (bl) {
                this.replace(KCondition.ALT, KCondition.OPTION);
                this.replace(KCondition.META, KCondition.COMMAND);
                this.replace(KCondition.SHORTCUT, KCondition.COMMAND);
            } else if (bl2) {
                this.replace(KCondition.SHORTCUT, KCondition.CTRL);
            } else if (bl3) {
                this.replace(KCondition.SHORTCUT, KCondition.CTRL);
            }
            if (!bl) {
                if (this.m.contains((Object)KCondition.COMMAND) || this.m.contains((Object)KCondition.OPTION)) {
                    return null;
                }
                this.replace(KCondition.WINDOWS, KCondition.META);
            }
            boolean bl4 = this.m.contains((Object)KCondition.KEY_PRESSED);
            boolean bl5 = this.m.contains((Object)KCondition.KEY_RELEASED);
            boolean bl6 = this.m.contains((Object)KCondition.KEY_TYPED);
            int n = 0;
            KCondition kCondition = null;
            if (bl4) {
                ++n;
                kCondition = KCondition.KEY_PRESSED;
            }
            if (bl5) {
                ++n;
                kCondition = KCondition.KEY_RELEASED;
            }
            if (bl6) {
                ++n;
                kCondition = KCondition.KEY_TYPED;
            }
            if (n > 1) {
                throw new IllegalArgumentException("more than one key event type is specified");
            }
            if (kCondition == null) {
                kCondition = KCondition.KEY_PRESSED;
            }
            this.m.add(kCondition);
            return new KeyBinding(this.key, this.m);
        }
    }
}

