/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.skin;

import com.sun.jfx.incubator.scene.control.richtext.RichTextAreaSkinHelper;
import com.sun.jfx.incubator.scene.control.richtext.util.ListenerHelper;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.util.Locale;
import javafx.scene.text.Font;
import jfx.incubator.scene.control.richtext.CodeArea;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.skin.CellContext;
import jfx.incubator.scene.control.richtext.skin.RichTextAreaSkin;

public class CodeAreaSkin
extends RichTextAreaSkin {
    public CodeAreaSkin(CodeArea codeArea) {
        super(codeArea);
        ListenerHelper listenerHelper = RichTextAreaSkinHelper.getListenerHelper(this);
        listenerHelper.addInvalidationListener(this::refreshLayout, codeArea.fontProperty(), codeArea.lineSpacingProperty(), codeArea.tabSizeProperty());
    }

    @Override
    public void applyStyles(CellContext cellContext, StyleAttributeMap styleAttributeMap, boolean bl) {
        super.applyStyles(cellContext, styleAttributeMap, bl);
        if (bl) {
            double d;
            CodeArea codeArea = (CodeArea)this.getSkinnable();
            Font font = codeArea.getFont();
            if (font != null) {
                d = font.getSize();
                String string = font.getFamily();
                String string2 = font.getName();
                if (RichUtils.isLogicalFont(string)) {
                    String string3 = string2.toLowerCase(Locale.ENGLISH);
                    String string4 = RichUtils.guessFontStyle(string3);
                    String string5 = RichUtils.guessFontWeight(string3);
                    cellContext.addStyle("-fx-font-family:'" + string + "';");
                    cellContext.addStyle("-fx-font-style:" + string4 + ";");
                    cellContext.addStyle("-fx-font-weight:" + string5 + ";");
                } else {
                    cellContext.addStyle("-fx-font-family:'" + string2 + "';");
                }
                cellContext.addStyle("-fx-font-size:" + d + ";");
            }
            d = codeArea.getLineSpacing();
            cellContext.addStyle("-fx-line-spacing:" + d + ";");
            double d2 = codeArea.getTabSize();
            cellContext.addStyle("-fx-tab-size:" + d2 + ";");
        }
    }
}

