/*
 * Decompiled with CFR 0.152.
 */
package HTML_TOOLS;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class HtmlEscaperGUI
extends JFrame {
    private JTextArea inputTextArea;
    private JTextArea outputTextArea;
    private JButton escapeButton;
    private JButton formatButton;
    private static final Set<String> VOID_TAGS = new HashSet<String>();
    private static final Set<String> INLINE_FLOW_TAGS;

    static {
        VOID_TAGS.add("area");
        VOID_TAGS.add("base");
        VOID_TAGS.add("br");
        VOID_TAGS.add("col");
        VOID_TAGS.add("embed");
        VOID_TAGS.add("hr");
        VOID_TAGS.add("img");
        VOID_TAGS.add("input");
        VOID_TAGS.add("link");
        VOID_TAGS.add("meta");
        VOID_TAGS.add("param");
        VOID_TAGS.add("source");
        VOID_TAGS.add("track");
        VOID_TAGS.add("wbr");
        INLINE_FLOW_TAGS = new HashSet<String>();
        INLINE_FLOW_TAGS.add("a");
        INLINE_FLOW_TAGS.add("abbr");
        INLINE_FLOW_TAGS.add("acronym");
        INLINE_FLOW_TAGS.add("b");
        INLINE_FLOW_TAGS.add("bdo");
        INLINE_FLOW_TAGS.add("big");
        INLINE_FLOW_TAGS.add("cite");
        INLINE_FLOW_TAGS.add("code");
        INLINE_FLOW_TAGS.add("dfn");
        INLINE_FLOW_TAGS.add("em");
        INLINE_FLOW_TAGS.add("i");
        INLINE_FLOW_TAGS.add("kbd");
        INLINE_FLOW_TAGS.add("label");
        INLINE_FLOW_TAGS.add("q");
        INLINE_FLOW_TAGS.add("samp");
        INLINE_FLOW_TAGS.add("small");
        INLINE_FLOW_TAGS.add("span");
        INLINE_FLOW_TAGS.add("strong");
        INLINE_FLOW_TAGS.add("sub");
        INLINE_FLOW_TAGS.add("sup");
        INLINE_FLOW_TAGS.add("time");
        INLINE_FLOW_TAGS.add("tt");
        INLINE_FLOW_TAGS.add("var");
        INLINE_FLOW_TAGS.add("button");
        INLINE_FLOW_TAGS.add("textarea");
        INLINE_FLOW_TAGS.add("select");
    }

    public HtmlEscaperGUI() {
        this.setTitle("HTML Sonderzeichen Maskierer & Formatter");
        this.setDefaultCloseOperation(3);
        this.setSize(700, 500);
        this.setLocationRelativeTo(null);
        this.inputTextArea = new JTextArea();
        this.inputTextArea.setLineWrap(true);
        this.inputTextArea.setWrapStyleWord(true);
        JScrollPane inputScrollPane = new JScrollPane(this.inputTextArea);
        inputScrollPane.setBorder(new TitledBorder("Gib hier deinen HTML-Code ein:"));
        this.outputTextArea = new JTextArea();
        this.outputTextArea.setLineWrap(true);
        this.outputTextArea.setWrapStyleWord(true);
        this.outputTextArea.setEditable(false);
        JScrollPane outputScrollPane = new JScrollPane(this.outputTextArea);
        outputScrollPane.setBorder(new TitledBorder("Ausgabe: Maskierter oder formatierter HTML-Code:"));
        this.escapeButton = new JButton("HTML-Sonderzeichen maskieren");
        this.formatButton = new JButton("HTML-Code formatieren");
        JPanel mainPanel = new JPanel(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(0, inputScrollPane, outputScrollPane);
        splitPane.setResizeWeight(0.5);
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 10, 5));
        buttonPanel.add(this.escapeButton);
        buttonPanel.add(this.formatButton);
        mainPanel.add((Component)splitPane, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        this.escapeButton.addActionListener(e -> this.escapeAndDisplay());
        this.formatButton.addActionListener(e -> this.formatAndDisplay());
        this.add(mainPanel);
    }

    private void escapeAndDisplay() {
        String rawHtml = this.inputTextArea.getText();
        String escapedHtml = this.escapeHtml(rawHtml);
        this.outputTextArea.setText(escapedHtml);
        this.outputTextArea.setCaretPosition(0);
    }

    private void formatAndDisplay() {
        String rawHtml = this.inputTextArea.getText();
        String formattedHtml = this.formatHtml(rawHtml);
        this.outputTextArea.setText(formattedHtml);
        this.outputTextArea.setCaretPosition(0);
    }

    private String escapeHtml(String raw) {
        if (raw == null || raw.isEmpty()) {
            return "";
        }
        StringBuilder escaped = new StringBuilder(raw.length() + 50);
        int i = 0;
        while (i < raw.length()) {
            char c = raw.charAt(i);
            switch (c) {
                case '&': {
                    escaped.append("&amp;");
                    break;
                }
                case '<': {
                    escaped.append("&lt;");
                    break;
                }
                case '>': {
                    escaped.append("&gt;");
                    break;
                }
                case '\"': {
                    escaped.append("&quot;");
                    break;
                }
                case '\'': {
                    escaped.append("&#39;");
                    break;
                }
                default: {
                    escaped.append(c);
                }
            }
            ++i;
        }
        return escaped.toString();
    }

    private String formatHtml(String rawHtml) {
        if (rawHtml == null || rawHtml.trim().isEmpty()) {
            return "";
        }
        StringBuilder formattedHtml = new StringBuilder();
        int indentLevel = 0;
        Pattern tagPattern = Pattern.compile("(<([a-zA-Z][a-zA-Z0-9]*)(?:\\s[^>]*)?>)|(</([a-zA-Z][a-zA-Z0-9]*)>)|(<([a-zA-Z][a-zA-Z0-9]*)\\s*/>)|([^<]+)");
        Matcher matcher = tagPattern.matcher(rawHtml);
        String lastNonWhitespaceText = "";
        boolean lastWasBlockEnd = true;
        while (matcher.find()) {
            boolean isBlockTag;
            String token = matcher.group();
            String tagName = null;
            boolean isOpeningTag = false;
            boolean isClosingTag = false;
            boolean isSelfClosingTag = false;
            boolean isText = false;
            if (matcher.group(1) != null) {
                tagName = matcher.group(2).toLowerCase();
                isOpeningTag = true;
                if (VOID_TAGS.contains(tagName)) {
                    isSelfClosingTag = true;
                    isOpeningTag = false;
                }
            } else if (matcher.group(3) != null) {
                tagName = matcher.group(4).toLowerCase();
                isClosingTag = true;
            } else if (matcher.group(5) != null) {
                tagName = matcher.group(6).toLowerCase();
                isSelfClosingTag = true;
            } else if (matcher.group(7) != null) {
                isText = true;
                token = matcher.group(7);
            }
            if (isText) {
                String processedText = token.replaceAll("[\\s]+", " ");
                if (processedText.trim().isEmpty()) continue;
                if (!lastWasBlockEnd && formattedHtml.length() > 0 && !formattedHtml.toString().endsWith("\n")) {
                    formattedHtml.append(" ");
                }
                if (formattedHtml.length() == 0 || formattedHtml.toString().endsWith("\n")) {
                    formattedHtml.append(this.getIndentation(indentLevel));
                }
                formattedHtml.append(processedText.trim());
                lastNonWhitespaceText = processedText.trim();
                lastWasBlockEnd = false;
                continue;
            }
            boolean bl = isBlockTag = !VOID_TAGS.contains(tagName) && !INLINE_FLOW_TAGS.contains(tagName);
            if (isClosingTag) {
                if (--indentLevel < 0) {
                    indentLevel = 0;
                }
                if (formattedHtml.length() > 0 && !formattedHtml.toString().endsWith("\n") && lastNonWhitespaceText.isEmpty()) {
                    formattedHtml.append(token);
                } else {
                    if (formattedHtml.length() > 0 && !formattedHtml.toString().endsWith("\n")) {
                        formattedHtml.append("\n");
                    }
                    formattedHtml.append(this.getIndentation(indentLevel)).append(token);
                }
                if (isBlockTag) {
                    formattedHtml.append("\n");
                    lastWasBlockEnd = true;
                } else {
                    lastWasBlockEnd = false;
                }
            } else if (isOpeningTag) {
                if (isBlockTag) {
                    if (formattedHtml.length() > 0 && !formattedHtml.toString().endsWith("\n") && !lastNonWhitespaceText.isEmpty()) {
                        formattedHtml.append("\n");
                    }
                    if (formattedHtml.length() == 0 || formattedHtml.toString().endsWith("\n")) {
                        formattedHtml.append(this.getIndentation(indentLevel));
                    } else {
                        formattedHtml.append(this.getIndentation(indentLevel));
                    }
                } else if (formattedHtml.length() == 0 || formattedHtml.toString().endsWith("\n")) {
                    formattedHtml.append(this.getIndentation(indentLevel));
                }
                formattedHtml.append(token);
                ++indentLevel;
                if (isBlockTag) {
                    formattedHtml.append("\n");
                    lastWasBlockEnd = true;
                } else {
                    lastWasBlockEnd = false;
                }
            } else if (isSelfClosingTag) {
                if (formattedHtml.length() > 0 && !formattedHtml.toString().endsWith("\n") && !lastWasBlockEnd) {
                    formattedHtml.append("\n");
                }
                formattedHtml.append(this.getIndentation(indentLevel)).append(token);
                if (tagName.equals("br") || tagName.equals("hr") || isBlockTag) {
                    formattedHtml.append("\n");
                    lastWasBlockEnd = true;
                } else {
                    lastWasBlockEnd = false;
                }
            }
            lastNonWhitespaceText = "";
        }
        Object finalOutput = formattedHtml.toString().replaceAll("(?m)^[ \t]*\r?\n", "").replaceAll("(?m)^\\s*$\\n", "").trim();
        if (!((String)finalOutput).isEmpty() && !((String)finalOutput).endsWith("\n")) {
            finalOutput = (String)finalOutput + "\n";
        }
        return finalOutput;
    }

    private String getIndentation(int level) {
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (i < level) {
            indent.append("    ");
            ++i;
        }
        return indent.toString();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new HtmlEscaperGUI().setVisible(true));
    }
}

