// JavaScript für alle interaktiven Blöcke
document.addEventListener('DOMContentLoaded', () => {

    // --- Funktion zum Ausklappen und Anpassen der Höhe ---
    const toggleHeight = (element, isOpening) => {
        if (isOpening) {
            // Setzt die Höhe auf auto, um die korrekte Scroll-Höhe zu messen
            element.style.height = 'auto';
            const targetHeight = element.scrollHeight+5;
            
            // Setzt die Höhe auf 0 zurück, um die Animation zu starten
            element.style.height = '0';
            
            // Erzwingt einen Reflow (erneute Berechnung des Layouts)
            element.offsetWidth; 
            
            // Startet die Animation zur gemessenen Höhe
            element.style.height = targetHeight + 'px';

        } else {
            // Klappt das Element zu
            element.style.height = '0';
        }
    };

    // --- Handler für alle ausklappbaren Header (.collapsible-header und .video-block-toggle) ---
    const allToggles = document.querySelectorAll('.collapsible-header, .video-block-toggle');

    allToggles.forEach(toggle => {
        toggle.addEventListener('click', () => {
            const parentBlock = toggle.closest('.collapsible-task-block, .video-block');
            if (!parentBlock) return;
            
            const content = parentBlock.querySelector('.collapsible-content, .video-block-content');
            
            // Überprüfe den Zustand der Box, BEVOR der Klick verarbeitet wird
            const isCurrentlyActive = parentBlock.classList.contains('active');
            
            if (isCurrentlyActive) {
                // Box ist offen, also klappen wir sie zu.
                toggleHeight(content, false);
            } else {
            // Box ist geschlossen, also klappen wir sie auf.
            // Laden Sie das Video, wenn es ein Videoblock ist
            if (parentBlock.classList.contains('video-block')) {
                const videoElement = parentBlock.querySelector('iframe, video');
                if (videoElement && videoElement.dataset.src) {
                    videoElement.src = videoElement.dataset.src;
                    videoElement.dataset.src = ''; // Verhindert, dass es erneut geladen wird
                }
            }
            toggleHeight(content, true);
            }

            // Schalte die 'active'-Klasse um, NACHDEM die Aktion ausgeführt wurde
            parentBlock.classList.toggle('active');
        });
    });

    // --- Handler für Lösungs-Toggler in Test Blöcken (.solution-toggle) ---
    const solutionToggles = document.querySelectorAll('.solution-toggle');

    solutionToggles.forEach(toggle => {
        toggle.addEventListener('click', () => {
            toggle.classList.toggle('active');
        });
    });

    // --- Handler für Bildergalerie (.gallery-block) ---
    const galleryBlocks = document.querySelectorAll('.gallery-block');

    galleryBlocks.forEach(gallery => {
        const imagesContainer = gallery.querySelector('.gallery-images-container');
        const slides = gallery.querySelectorAll('.gallery-image-slide');
        const dotsContainer = gallery.querySelector('.gallery-dots');
        const arrowLeft = gallery.querySelector('.arrow-left');
        const arrowRight = gallery.querySelector('.arrow-right');

        if (!imagesContainer || slides.length === 0 || !dotsContainer || !arrowLeft || !arrowRight) {
            if (slides.length > 0 && dotsContainer) {
                 for (let i = 0; i < slides.length; i++) {
                    const dot = document.createElement('span');
                    dot.classList.add('gallery-dot');
                    dot.dataset.index = i;
                    dotsContainer.appendChild(dot);
                     dot.addEventListener('click', () => {
                        showSlide(i);
                    });
                 }
                 const dots = dotsContainer.querySelectorAll('.gallery-dot');
                 showSlide(0);
            }
            return;
        }

        const numImages = slides.length;
        let currentImageIndex = 0;

        imagesContainer.style.width = `${numImages * 100}%`;

        slides.forEach(slide => {
            slide.style.width = `${100 / numImages}%`;
        });

        for (let i = 0; i < numImages; i++) {
            const dot = document.createElement('span');
            dot.classList.add('gallery-dot');
            dot.dataset.index = i;
            dotsContainer.appendChild(dot);

            dot.addEventListener('click', () => {
                showSlide(i);
            });
        }
        
        const dots = dotsContainer.querySelectorAll('.gallery-dot');
        function showSlide(index) {
            if (index < 0) {
                index = numImages - 1;
            } else if (index >= numImages) {
                index = 0;
            }

            currentImageIndex = index;
            const offset = -currentImageIndex * (100 / numImages);
            imagesContainer.style.transform = `translateX(${offset}%)`;

            dots.forEach(dot => {
                dot.classList.remove('active');
            });
            if(dots[currentImageIndex]) {
                 dots[currentImageIndex].classList.add('active');
            }
        }
        arrowLeft.addEventListener('click', () => {
            showSlide(currentImageIndex - 1);
        });
        arrowRight.addEventListener('click', () => {
            showSlide(currentImageIndex + 1);
        });
        showSlide(0);
    });
    
    //--Kopieren-Button in den Code-Blöcken--//
    const copyButtons = document.querySelectorAll('.copy-button');

    copyButtons.forEach(button => {
        button.addEventListener('click', () => {
            const codeContainer = button.closest('.code-container');
            const codeElement = codeContainer.querySelector('code');

            if (codeElement) {
                const codeToCopy = codeElement.textContent;
                navigator.clipboard.writeText(codeToCopy)
                    .then(() => {
                        const originalText = button.textContent;
                        button.textContent = 'Kopiert!';
                        setTimeout(() => {
                            button.textContent = originalText;
                        }, 2000);
                    })
                    .catch(err => {
                        console.error('Fehler beim Kopieren des Codes: ', err);
                        const originalText = button.textContent;
                        button.textContent = 'Fehler!';
                         setTimeout(() => {
                            button.textContent = originalText;
                        }, 2000);
                    });
            } else {
                console.error('Kein Code-Element im Container gefunden.');
            }
        });
    });

    /**
     * Passt die Höhe des '.image-row-container' an die Höhe des höchsten FIGURE-Elements darin an (Bild + Bildunterschrift).
     */
    function adjustImageRowHeights() {
        const imageContainers = document.querySelectorAll('.image-row-container');

        imageContainers.forEach(container => {
            const figures = container.querySelectorAll('figure');
            if (figures.length < 2) return;
            let maxFigureHeight = 0;
            figures.forEach(figure => {
                figure.style.height = 'auto';
                if (figure.offsetHeight > maxFigureHeight) {
                    maxFigureHeight = figure.offsetHeight;
                }
            });
            if (maxFigureHeight > 0) {
                container.style.height = `${maxFigureHeight}px`;
            }
        });
    }

    window.addEventListener('load', adjustImageRowHeights);
    window.addEventListener('resize', adjustImageRowHeights);

});
// --- Lehrer-Login Modal ---
    const loginModal = document.getElementById('loginModal');
    const loginBtn = document.getElementById('loginBtn');
    const closeBtn = document.querySelector('.modal .close');
    const submitLoginBtn = document.getElementById('submitLogin');
    const passwordInput = document.getElementById('password');
    const errorMessage = document.getElementById('errorMessage');
    const loginStatus = document.getElementById('loginStatus');
    const teacherWelcome = document.getElementById('teacherWelcome');

    // Funktion zum Öffnen des Modals
    if (loginBtn) {
        loginBtn.addEventListener('click', () => {
            loginModal.style.display = 'block';
            passwordInput.value = ''; // Passwortfeld leeren
            errorMessage.style.display = 'none'; // Fehlermeldung ausblenden
        });
    }

    // Funktion zum Schließen des Modals über das 'x'
    if (closeBtn) {
        closeBtn.addEventListener('click', () => {
            loginModal.style.display = 'none';
        });
    }

    // Funktion zum Schließen des Modals bei Klick außerhalb des Inhalts
    window.addEventListener('click', (event) => {
        if (event.target == loginModal) {
            loginModal.style.display = 'none';
        }
    });

    // Funktion zum Verarbeiten des Logins
    if (submitLoginBtn) {
        submitLoginBtn.addEventListener('click', () => {
            const password = passwordInput.value;

            // Sendet das Passwort an das PHP-Skript
            fetch('/check_login.php', {
                method: 'POST', // Wir senden Daten, also verwenden wir POST
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ password: password }) // Das Passwort wird in JSON verpackt
            })
            .then(response => response.json()) // Die JSON-Antwort vom Server wird ausgelesen
            .then(data => {
                // Die Antwort des Servers wird verarbeitet
                if (data.success) {
                    // Bei korrektem Passwort (Antwort war {"success": true})
                    loginModal.style.display = 'none';
                    document.body.classList.add('teacher-logged-in');
                    loginBtn.style.display = 'none';
                    loginStatus.style.display = 'inline';
                } else {
                    // Bei falschem Passwort (Antwort war {"success": false})
                    errorMessage.style.display = 'block';
                    passwordInput.value = '';
                }
            })
            .catch(error => {
                // Falls ein Fehler bei der Verbindung zum Server auftritt
                console.error('Fehler bei der Kommunikation mit dem Server:', error);
                errorMessage.textContent = 'Verbindungsfehler. Bitte erneut versuchen.';
                errorMessage.style.display = 'block';
            });
        });
    }