/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.platform.mac.convert;

import com.sun.jna.Memory;
import de.jangassen.jfa.appkit.NSData;
import de.jangassen.jfa.appkit.NSImage;
import de.jangassen.jfa.appkit.NSObject;
import de.jangassen.jfa.cleanup.NSCleaner;
import de.jangassen.util.MemoryUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ImageConverter {
    public static Optional<NSImage> convert(Node graphic) {
        Image image;
        if (graphic instanceof ImageView && (image = ((ImageView)graphic).getImage()) != null && image.getUrl() != null) {
            Optional<NSImage> optional;
            block9: {
                InputStream stream = new URL(image.getUrl()).openStream();
                try {
                    NSImage nsImage = ImageConverter.getNsImage(stream.readAllBytes());
                    NSCleaner.register((Object)graphic, (NSObject)nsImage);
                    optional = Optional.of(nsImage);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                stream.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    private static NSImage getNsImage(byte[] imageData) {
        Memory memory = MemoryUtils.toMemory(imageData);
        NSData data = NSData.alloc().initWithBytes(memory, (int)memory.size());
        return NSImage.alloc().initWithData(data);
    }
}

