/*
 * Decompiled with CFR 0.152.
 */
package de.jangassen.util;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;

public final class StageUtils {
    private static ObservableList<Stage> stages;
    private static ObservableList<Window> windows;

    private StageUtils() {
    }

    public static void bringAllToFront() {
        Optional<Stage> focusedStage = StageUtils.getFocusedStage();
        StageUtils.getStages().forEach(Stage::toFront);
        focusedStage.ifPresent(Stage::toFront);
    }

    public static void zoomFocusedStage() {
        StageUtils.getFocusedStage().ifPresent(stage -> {
            ObservableList screens = Screen.getScreensForRectangle((double)stage.getX(), (double)stage.getY(), (double)stage.getWidth(), (double)stage.getHeight());
            if (screens.size() == 1) {
                StageUtils.setStageSize(stage, ((Screen)screens.get(0)).getBounds());
            }
        });
    }

    public static void minimizeFocusedStage() {
        StageUtils.getFocusedStage().ifPresent(stage -> stage.setIconified(true));
    }

    public static void closeCurrentStage() {
        StageUtils.getFocusedStage().ifPresent(Stage::close);
    }

    public static void focusNextStage() {
        ObservableList<Stage> stages = StageUtils.getStages();
        int currentStageIndex = StageUtils.getFocusedStageIndex(stages);
        if (currentStageIndex < stages.size() - 1) {
            ((Stage)stages.get(currentStageIndex + 1)).toFront();
        } else if (!stages.isEmpty()) {
            ((Stage)stages.get(0)).toFront();
        }
    }

    public static ObservableList<Stage> getStages() {
        if (stages == null) {
            windows = Window.getWindows();
            stages = FXCollections.observableArrayList();
            windows.addListener(c -> StageUtils.updateStages());
            StageUtils.updateStages();
        }
        return stages;
    }

    private static void updateStages() {
        List currentStages = windows.stream().filter(Stage.class::isInstance).map(Stage.class::cast).collect(Collectors.toList());
        stages.removeIf(stage -> !currentStages.contains(stage));
        currentStages.stream().filter(currentStage -> !stages.contains(currentStage)).forEach(arg_0 -> stages.add(arg_0));
    }

    public static Optional<Stage> getFocusedStage() {
        return StageUtils.getStages().stream().filter(Window::isFocused).findFirst();
    }

    public static int getFocusedStageIndex(List<Stage> stages) {
        for (int i = 0; i < stages.size(); ++i) {
            if (!stages.get(i).isFocused()) continue;
            return i;
        }
        return -1;
    }

    public static void setStageSize(Stage stage, Rectangle2D screenBounds) {
        stage.setX(screenBounds.getMinX());
        stage.setY(screenBounds.getMinY());
        stage.setWidth(screenBounds.getMaxX() - screenBounds.getMinX());
        stage.setHeight(screenBounds.getMaxY() - screenBounds.getMinY());
    }
}

