/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.collision.CollisionQuery;

public class NeighbourCollisionQuery
implements CollisionQuery {
    private int x;
    private int y;
    private int distance;
    private boolean diag;
    private Class<?> cls;

    public void init(int x, int y, int distance, boolean diag, Class<?> cls) {
        this.x = x;
        this.y = y;
        this.distance = distance;
        this.diag = diag;
        this.cls = cls;
    }

    @Override
    public boolean checkCollision(Actor actor) {
        int dy;
        if (this.cls != null && !this.cls.isInstance(actor)) {
            return false;
        }
        int actorX = ActorVisitor.getX(actor);
        int actorY = ActorVisitor.getY(actor);
        if (actorX == this.x && actorY == this.y) {
            return false;
        }
        int ax = ActorVisitor.getX(actor);
        int ay = ActorVisitor.getY(actor);
        if (this.diag) {
            int x1 = this.x - this.distance;
            int y1 = this.y - this.distance;
            int x2 = this.x + this.distance;
            int y2 = this.y + this.distance;
            return ax >= x1 && ay >= y1 && ax <= x2 && ay <= y2;
        }
        int dx = Math.abs(ax - this.x);
        return dx + (dy = Math.abs(ay - this.y)) <= this.distance;
    }
}

