/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.debugmgr.objectbench.ObjectBenchInterface;
import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.Simulation;
import greenfoot.event.SimulationListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.gui.input.KeyboardManager;
import greenfoot.gui.input.mouse.MousePollingManager;
import greenfoot.gui.input.mouse.WorldLocator;
import greenfoot.platforms.WorldHandlerDelegate;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Simulation)
public class WorldHandler
implements SimulationListener {
    private @OnThread(value=Tag.Any, requireSynchronized=true) boolean worldIsSet;
    private volatile @OnThread(value=Tag.Any) World world;
    private int dragBeginX;
    private int dragBeginY;
    private final @OnThread(value=Tag.Any) KeyboardManager keyboardManager;
    private static @OnThread(value=Tag.Any) WorldHandler instance;
    private final @OnThread(value=Tag.Any) List<WorldListener> worldListeners = new ArrayList<WorldListener>();
    private @OnThread(value=Tag.Any) WorldHandlerDelegate handlerDelegate;
    private final @OnThread(value=Tag.Any) MousePollingManager mousePollingManager;
    private int dragOffsetX;
    private int dragOffsetY;
    private Actor dragActor;
    private boolean dragActorMoved;
    private int dragId;

    @OnThread(value=Tag.Any)
    public static synchronized void initialise(WorldHandlerDelegate helper) {
        instance = new WorldHandler(helper);
    }

    @OnThread(value=Tag.Any)
    public static synchronized void initialise() {
        instance = new WorldHandler();
    }

    @OnThread(value=Tag.Any)
    public static synchronized WorldHandler getInstance() {
        return instance;
    }

    @OnThread(value=Tag.Any)
    private WorldHandler() {
        instance = this;
        this.keyboardManager = new KeyboardManager();
        this.mousePollingManager = new MousePollingManager(null);
        this.handlerDelegate = new WorldHandlerDelegate(this){

            @Override
            public void discardWorld(World world) {
            }

            @Override
            public void instantiateNewWorld(String className, Runnable runIfError) {
            }

            @Override
            public void setWorld(World oldWorld, World newWorld) {
            }

            @Override
            public void objectAddedToWorld(Actor actor) {
            }

            @Override
            public String ask(String prompt) {
                return "";
            }

            @Override
            public void paint(World drawWorld, boolean forcePaint) {
            }

            @Override
            public void notifyStoppedWithError() {
            }
        };
    }

    @OnThread(value=Tag.Any)
    private WorldHandler(WorldHandlerDelegate handlerDelegate) {
        instance = this;
        this.handlerDelegate = handlerDelegate;
        this.mousePollingManager = new MousePollingManager(null);
        this.keyboardManager = new KeyboardManager();
    }

    @OnThread(value=Tag.Any)
    public KeyboardManager getKeyboardManager() {
        return this.keyboardManager;
    }

    @OnThread(value=Tag.Any)
    public MousePollingManager getMouseManager() {
        return this.mousePollingManager;
    }

    @OnThread(value=Tag.Simulation)
    public void startDrag(Actor actor, Point p, int dragId) {
        this.dragActor = actor;
        this.dragActorMoved = false;
        this.dragBeginX = ActorVisitor.getX(actor) * this.world.getCellSize() + this.world.getCellSize() / 2;
        this.dragBeginY = ActorVisitor.getY(actor) * this.world.getCellSize() + this.world.getCellSize() / 2;
        this.dragOffsetX = this.dragBeginX - p.x;
        this.dragOffsetY = this.dragBeginY - p.y;
        this.dragId = dragId;
        this.drag(actor, p);
    }

    public boolean isDragging() {
        return this.dragActor != null;
    }

    private static Actor getObject(World world, int x, int y) {
        if (world == null) {
            return null;
        }
        Collection<Actor> objectsThere = WorldVisitor.getObjectsAtPixel(world, x, y);
        if (objectsThere.isEmpty()) {
            return null;
        }
        Iterator<Actor> iter = objectsThere.iterator();
        Actor topmostActor = iter.next();
        int seq = ActorVisitor.getLastPaintSeqNum(topmostActor);
        while (iter.hasNext()) {
            Actor actor = iter.next();
            int actorSeq = ActorVisitor.getLastPaintSeqNum(actor);
            if (actorSeq <= seq) continue;
            topmostActor = actor;
            seq = actorSeq;
        }
        return topmostActor;
    }

    public void mouseExited(MouseEvent e) {
        if (this.dragActor != null) {
            this.dragActorMoved = false;
            Simulation.getInstance().runLater(new Simulation.SimulationRunnable(){
                private Actor dragActor;
                private int dragBeginX;
                private int dragBeginY;
                {
                    this.dragActor = WorldHandler.this.dragActor;
                    this.dragBeginX = WorldHandler.this.dragBeginX;
                    this.dragBeginY = WorldHandler.this.dragBeginY;
                }

                @Override
                public void run() {
                    ActorVisitor.setLocationInPixels(this.dragActor, this.dragBeginX, this.dragBeginY);
                    WorldHandler.this.repaint();
                }
            });
        }
    }

    public void repaint() {
        this.paint(true);
    }

    public void repaintAndWait() {
        this.repaint();
    }

    @OnThread(value=Tag.Any)
    public void instantiateNewWorld(String className) {
        this.handlerDelegate.instantiateNewWorld(className, () -> this.worldInstantiationError());
    }

    public void setInitialisingWorld(World world) {
        this.handlerDelegate.initialisingWorld(world.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public void discardWorld() {
        World discardedWorld;
        WorldHandler worldHandler = this;
        synchronized (worldHandler) {
            if (this.world == null) {
                return;
            }
            this.handlerDelegate.discardWorld(this.world);
            discardedWorld = this.world;
            this.world = null;
        }
        Simulation.getInstance().runLater(() -> this.fireWorldRemovedEvent(discardedWorld));
    }

    @OnThread(value=Tag.Any)
    public synchronized boolean checkWorldSet() {
        return this.worldIsSet;
    }

    @OnThread(value=Tag.Any)
    public synchronized void clearWorldSet() {
        this.worldIsSet = false;
    }

    @OnThread(value=Tag.Any)
    public synchronized void setWorld(final World world, boolean byUserCode) {
        this.worldIsSet = true;
        this.handlerDelegate.setWorld(this.world, world);
        this.mousePollingManager.setWorldLocator(new WorldLocator(){

            @Override
            @OnThread(value=Tag.Simulation)
            public Actor getTopMostActorAt(int x, int y) {
                return WorldHandler.getObject(world, x, y);
            }

            @Override
            @OnThread(value=Tag.Any)
            public int getTranslatedX(int x) {
                return WorldVisitor.toCellFloor(world, x);
            }

            @Override
            @OnThread(value=Tag.Any)
            public int getTranslatedY(int y) {
                return WorldVisitor.toCellFloor(world, y);
            }
        });
        this.world = world;
        Simulation.getInstance().runLater(() -> this.fireWorldCreatedEvent(world));
        this.worldChanged(byUserCode);
    }

    @OnThread(value=Tag.Any)
    private void worldChanged(boolean byUserCode) {
    }

    @OnThread(value=Tag.Any)
    private void worldInstantiationError() {
    }

    public synchronized World getWorld() {
        return this.world;
    }

    public synchronized boolean hasWorld() {
        return this.world != null;
    }

    public boolean drop(Object o, Point p) {
        World world = this.world;
        int maxHeight = WorldVisitor.getHeightInPixels(world);
        int maxWidth = WorldVisitor.getWidthInPixels(world);
        int x = (int)p.getX();
        int y = (int)p.getY();
        if (x >= maxWidth || y >= maxHeight || x < 0 || y < 0) {
            return false;
        }
        if (o instanceof Actor && ActorVisitor.getWorld((Actor)o) == null) {
            Actor actor = (Actor)o;
            this.addActorAtPixel(actor, x, y);
            return true;
        }
        if (o instanceof Actor) {
            Actor actor = (Actor)o;
            if (ActorVisitor.getWorld(actor) == null) {
                return false;
            }
            Simulation.getInstance().runLater(() -> ActorVisitor.setLocationInPixels(actor, x, y));
            this.dragActorMoved = true;
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.Simulation)
    public boolean drag(Object o, Point p) {
        World world = this.world;
        if (o instanceof Actor && world != null) {
            block5: {
                int x = WorldVisitor.toCellFloor(world, (int)p.getX() + this.dragOffsetX);
                int y = WorldVisitor.toCellFloor(world, (int)p.getY() + this.dragOffsetY);
                Actor actor = (Actor)o;
                try {
                    int oldX = ActorVisitor.getX(actor);
                    int oldY = ActorVisitor.getY(actor);
                    if (oldX == x && oldY == y) break block5;
                    if (x < WorldVisitor.getWidthInCells(world) && y < WorldVisitor.getHeightInCells(world) && x >= 0 && y >= 0) {
                        ActorVisitor.setLocationInPixels(actor, (int)p.getX() + this.dragOffsetX, (int)p.getY() + this.dragOffsetY);
                        this.dragActorMoved = true;
                        this.repaint();
                        break block5;
                    }
                    ActorVisitor.setLocationInPixels(actor, this.dragBeginX, this.dragBeginY);
                    x = WorldVisitor.toCellFloor(this.getWorld(), this.dragBeginX);
                    y = WorldVisitor.toCellFloor(this.getWorld(), this.dragBeginY);
                    this.dragActorMoved = false;
                    this.repaint();
                    return false;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.Any)
    public boolean addActorAtPixel(Actor actor, int xPixel, int yPixel) {
        World world = this.world;
        int x = WorldVisitor.toCellFloor(world, xPixel);
        int y = WorldVisitor.toCellFloor(world, yPixel);
        if (x < WorldVisitor.getWidthInCells(world) && y < WorldVisitor.getHeightInCells(world) && x >= 0 && y >= 0) {
            Simulation.getInstance().runLater(() -> {
                world.addObject(actor, x, y);
                Simulation.getInstance().paintRemote(true);
            });
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.Simulation)
    protected void fireWorldCreatedEvent(World newWorld) {
        WorldEvent worldEvent = new WorldEvent(newWorld);
        for (WorldListener worldListener : this.worldListeners) {
            worldListener.worldCreated(worldEvent);
        }
    }

    @OnThread(value=Tag.Simulation)
    public void fireWorldRemovedEvent(World discardedWorld) {
        WorldEvent worldEvent = new WorldEvent(discardedWorld);
        for (WorldListener worldListener : this.worldListeners) {
            worldListener.worldRemoved(worldEvent);
        }
    }

    @OnThread(value=Tag.Any)
    public void addWorldListener(WorldListener l) {
        this.worldListeners.add(0, l);
    }

    private void startSequence() {
        World world = this.world;
        if (world != null) {
            WorldVisitor.startSequence(world);
            this.mousePollingManager.newActStarted();
        }
    }

    @OnThread(value=Tag.Any)
    public void finishDrag(int dragId, int ax, int ay) {
        Simulation.getInstance().runLater(() -> {
            if (this.dragId == dragId) {
                if (this.dragActorMoved) {
                    ActorVisitor.setLocationInPixels(this.dragActor, this.dragBeginX, this.dragBeginY);
                    this.dragActor.setLocation(ax, ay);
                }
                this.dragActor = null;
            }
        });
    }

    @Override
    @OnThread(value=Tag.Simulation)
    public void simulationChangedSync(SimulationListener.SyncEvent e) {
        if (e == SimulationListener.SyncEvent.NEW_ACT_ROUND) {
            this.startSequence();
        } else if (e == SimulationListener.SyncEvent.STARTED) {
            this.mousePollingManager.startedRunning();
        }
    }

    @Override
    @OnThread(value=Tag.Any)
    public void simulationChangedAsync(SimulationListener.AsyncEvent e) {
    }

    public ObjectBenchInterface getObjectBench() {
        if (this.handlerDelegate instanceof ObjectBenchInterface) {
            return (ObjectBenchInterface)this.handlerDelegate;
        }
        return null;
    }

    public void objectAddedToWorld(Actor object) {
        this.handlerDelegate.objectAddedToWorld(object);
    }

    public String ask(String prompt) {
        return this.handlerDelegate.ask(prompt);
    }

    @OnThread(value=Tag.Any)
    public void continueDragging(int dragId, int x, int y) {
        Simulation.getInstance().runLater(() -> {
            if (dragId == this.dragId) {
                this.drag(this.dragActor, new Point(x, y));
                Simulation.getInstance().paintRemote(true);
            }
        });
    }

    public void notifyStoppedWithError() {
        this.handlerDelegate.notifyStoppedWithError();
    }

    public void paint(boolean forcePaint) {
        this.handlerDelegate.paint(this.world, forcePaint);
    }

    @OnThread(value=Tag.Any)
    public void worldFocusChanged(boolean focused) {
        if (focused) {
            this.keyboardManager.focusGained();
        } else {
            this.keyboardManager.focusLost();
        }
    }

    public void finishedInitialisingWorld() {
        this.handlerDelegate.finishedInitialisingWorld();
    }
}

