/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export.mygame;

import greenfoot.export.mygame.MyGameClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;

public class ProgressTrackingPart
extends FormBodyPart {
    public ProgressTrackingPart(String partName, File file, MyGameClient listener) throws FileNotFoundException {
        super(partName, (ContentBody)new ProgressTrackingFileBody(file, listener));
    }

    private static class ProgressTrackingFileBody
    extends FileBody {
        private MyGameClient listener;

        public ProgressTrackingFileBody(File file, MyGameClient listener) {
            super(file);
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream output) throws IOException {
            if (this.getContentLength() == 0L) {
                return;
            }
            byte[] buf = new byte[4096];
            try (InputStream istream = this.getInputStream();){
                int len = istream.read(buf);
                while (len != -1) {
                    output.write(buf, 0, len);
                    this.listener.progress(len);
                    len = istream.read(buf);
                }
            }
        }
    }
}

