/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input.mouse;

import greenfoot.MouseInfo;
import greenfoot.gui.input.mouse.MouseEventData;
import greenfoot.gui.input.mouse.PriorityManager;
import greenfoot.gui.input.mouse.WorldLocator;
import javafx.scene.input.MouseButton;
import threadchecker.OnThread;
import threadchecker.Tag;

public class MousePollingManager {
    private MouseEventData currentData = new MouseEventData();
    private MouseEventData futureData = new MouseEventData();
    private MouseEventData potentialNewDragData = new MouseEventData();
    private WorldLocator locator;
    private MouseEventData dragStartData = new MouseEventData();
    private boolean isDragging;
    private boolean gotNewEvent;
    private boolean gotNewDragStartEvent;

    @OnThread(value=Tag.Any)
    public MousePollingManager(WorldLocator locator) {
        this.locator = locator;
    }

    public void setWorldLocator(WorldLocator locator) {
        this.locator = locator;
    }

    @OnThread(value=Tag.Simulation)
    public synchronized void newActStarted() {
        if (this.gotNewEvent) {
            MouseEventData newData = new MouseEventData();
            this.futureData.setActors(this.locator);
            this.currentData = this.futureData;
            this.futureData = newData;
            this.potentialNewDragData = new MouseEventData();
            if (this.gotNewDragStartEvent) {
                this.dragStartData.setActors(this.locator);
                this.currentData.setDragStartActor(this.dragStartData);
                this.gotNewDragStartEvent = false;
            }
            this.gotNewEvent = false;
        } else {
            this.currentData.init();
        }
    }

    private void registerEventRecieved() {
        this.gotNewEvent = true;
    }

    @OnThread(value=Tag.Simulation)
    public boolean isMousePressed(Object obj) {
        return this.currentData.isMousePressedOn(obj);
    }

    @OnThread(value=Tag.Simulation)
    public boolean isMouseClicked(Object obj) {
        return this.currentData.isMouseClickedOn(obj);
    }

    @OnThread(value=Tag.Simulation)
    public boolean isMouseDragged(Object obj) {
        return this.currentData.isMouseDraggedOn(obj);
    }

    @OnThread(value=Tag.Simulation)
    public boolean isMouseDragEnded(Object obj) {
        return this.currentData.isMouseDragEndedOn(obj);
    }

    @OnThread(value=Tag.Simulation)
    public boolean isMouseMoved(Object obj) {
        return this.currentData.isMouseMovedOn(obj);
    }

    @OnThread(value=Tag.Simulation)
    public MouseInfo getMouseInfo() {
        return this.currentData.getMouseInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public void mouseClicked(int x, int y, MouseButton button, int clickCount) {
        if (this.locator == null) {
            return;
        }
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            MouseEventData mouseData = this.futureData;
            if (this.futureData.isMouseDragEnded()) {
                mouseData = this.potentialNewDragData;
            }
            if (!PriorityManager.isHigherPriority(500, mouseData)) {
                return;
            }
            this.registerEventRecieved();
            int tx = this.locator.getTranslatedX(x);
            int ty = this.locator.getTranslatedY(y);
            mouseData.mouseClicked(tx, ty, x, y, this.getButton(button), clickCount);
            this.isDragging = false;
        }
    }

    private int getButton(MouseButton button) {
        switch (button) {
            case PRIMARY: {
                return 1;
            }
            case MIDDLE: {
                return 2;
            }
            case SECONDARY: {
                return 3;
            }
        }
        return 0;
    }

    @OnThread(value=Tag.Any)
    public synchronized void mouseExited() {
        this.futureData.mouseExited();
        this.registerEventRecieved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public void mousePressed(int x, int y, MouseButton button) {
        if (this.locator == null) {
            return;
        }
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            MouseEventData mouseData = this.futureData;
            if (this.futureData.isMouseDragEnded()) {
                mouseData = this.potentialNewDragData;
            }
            this.dragStartData = new MouseEventData();
            int tx = this.locator.getTranslatedX(x);
            int ty = this.locator.getTranslatedY(y);
            this.dragStartData.mousePressed(tx, ty, x, y, this.getButton(button));
            this.gotNewDragStartEvent = true;
            if (!PriorityManager.isHigherPriority(501, mouseData)) {
                return;
            }
            this.registerEventRecieved();
            mouseData.mousePressed(tx, ty, x, y, this.getButton(button));
            this.isDragging = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public void mouseReleased(int x, int y, MouseButton button) {
        if (this.locator == null) {
            return;
        }
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            if (this.isDragging) {
                if (this.futureData.isMouseDragEnded()) {
                    this.futureData = this.potentialNewDragData;
                }
                if (!PriorityManager.isHigherPriority(502, this.futureData)) {
                    return;
                }
                this.registerEventRecieved();
                int tx = this.locator.getTranslatedX(x);
                int ty = this.locator.getTranslatedY(y);
                this.futureData.mouseClicked(tx, ty, x, y, this.getButton(button), 1);
                this.futureData.mouseDragEnded(tx, ty, x, y, this.getButton(button), this.dragStartData);
                this.isDragging = false;
                this.potentialNewDragData = new MouseEventData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public void mouseDragged(int x, int y, MouseButton button) {
        if (this.locator == null) {
            return;
        }
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            this.isDragging = true;
            if (!PriorityManager.isHigherPriority(506, this.futureData)) {
                return;
            }
            this.registerEventRecieved();
            int tx = this.locator.getTranslatedX(x);
            int ty = this.locator.getTranslatedY(y);
            this.futureData.mouseDragged(tx, ty, x, y, this.dragStartData.getButton(), this.dragStartData.getActor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public void mouseMoved(int x, int y) {
        if (this.locator == null) {
            return;
        }
        MousePollingManager mousePollingManager = this;
        synchronized (mousePollingManager) {
            if (!PriorityManager.isHigherPriority(503, this.futureData)) {
                return;
            }
            this.registerEventRecieved();
            int tx = this.locator.getTranslatedX(x);
            int ty = this.locator.getTranslatedY(y);
            this.futureData.mouseMoved(tx, ty, x, y);
            this.isDragging = false;
        }
    }

    public void startedRunning() {
        this.futureData = new MouseEventData();
    }
}

