/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx;

import bluej.GuiHandler;
import bluej.Main;
import bluej.pkgmgr.Project;
import greenfoot.core.ProjectManager;
import greenfoot.guifx.GreenfootStage;
import java.io.File;
import javafx.stage.Stage;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class GreenfootGuiHandler
implements GuiHandler {
    public boolean tryOpen(File path, boolean displayError) {
        Project project = Project.openProject((String)path.toString());
        if (project != null) {
            ProjectManager.instance().launchProject(project);
            return true;
        }
        return GreenfootStage.openArchive(path, null);
    }

    public void handleAbout() {
        GreenfootStage.aboutGreenfoot(null);
    }

    public void handlePreferences() {
        GreenfootStage.showPreferences();
    }

    public void handleQuit() {
        Main.wantToQuit();
    }

    public Stage initialOpenComplete(boolean projectOpen) {
        if (!projectOpen) {
            GreenfootStage stage = GreenfootStage.makeStage(null, null);
            stage.show();
            return stage;
        }
        return GreenfootStage.getOpenStage();
    }

    public void doExitCleanup() {
        GreenfootStage.closeAll();
    }
}

