/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.classes;

import bluej.Config;
import bluej.extensions2.SourceType;
import bluej.utility.Debug;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.JavaFXUtil;
import greenfoot.guifx.GreenfootStage;
import greenfoot.guifx.classes.ClassDisplay;
import greenfoot.guifx.classes.ClassDisplaySelectionManager;
import greenfoot.guifx.classes.ClassGroup;
import greenfoot.guifx.classes.GClassNode;
import greenfoot.util.GreenfootUtil;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ImportClassDialog
extends Dialog<File> {
    private final ClassDisplaySelectionManager classDisplaySelectionManager = new ClassDisplaySelectionManager();
    private final Map<String, File> filesForQualifiedClasses = new HashMap<String, File>();

    public ImportClassDialog(GreenfootStage greenfootStage) {
        this.initModality(Modality.APPLICATION_MODAL);
        this.initOwner((Window)greenfootStage);
        this.setTitle(Config.getString((String)"import.dialogTitle"));
        ClassGroup classGroup = new ClassGroup(greenfootStage);
        List<ImportableGClassNode> foundClasses = this.findImportableClasses(new File(Config.getGreenfootLibDir(), "common"));
        Collections.sort(foundClasses, Comparator.comparing(c -> c.getDisplayName()));
        classGroup.getLiveTopLevelClasses().addAll(foundClasses);
        classGroup.updateAfterAdd();
        for (ImportableGClassNode foundClass : foundClasses) {
            this.filesForQualifiedClasses.put(foundClass.getQualifiedName(), foundClass.file);
        }
        WebView docView = new WebView();
        this.classDisplaySelectionManager.addSelectionListener((FXPlatformConsumer<ClassDisplay>)((FXPlatformConsumer)selection -> {
            File htmlFile;
            File file = selection == null ? null : this.filesForQualifiedClasses.get(selection.getQualifiedName());
            docView.setVisible(false);
            if (file != null && (htmlFile = new File(GreenfootUtil.removeExtension(file.getAbsolutePath()) + ".html")).exists()) {
                try {
                    docView.getEngine().load(htmlFile.toURI().toURL().toExternalForm());
                    docView.setVisible(true);
                }
                catch (MalformedURLException e) {
                    Debug.reportError((Throwable)e);
                }
            }
        }));
        if (!foundClasses.isEmpty()) {
            this.classDisplaySelectionManager.select(foundClasses.get(0).getDisplay(greenfootStage));
        }
        this.getDialogPane().setContent((Node)new BorderPane((Node)docView, null, null, null, (Node)classGroup));
        BorderPane.setMargin((Node)classGroup, (Insets)new Insets(0.0, 8.0, 0.0, 0.0));
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        JavaFXUtil.addStyleClass((Styleable)this.getDialogPane(), (String[])new String[]{"import-class-dialog"});
        this.setResizable(true);
        this.setWidth(700.0);
        this.setHeight(550.0);
        Config.addGreenfootStylesheets((Scene)this.getDialogPane().getScene());
        this.setResultConverter(bt -> {
            ClassDisplay selected;
            if (bt == ButtonType.OK && (selected = this.classDisplaySelectionManager.getSelected()) != null) {
                return this.filesForQualifiedClasses.get(selected.getQualifiedName());
            }
            return null;
        });
    }

    private List<ImportableGClassNode> findImportableClasses(File dir) {
        File[] folders;
        ArrayList<ImportableGClassNode> foundClasses = new ArrayList<ImportableGClassNode>();
        File[] files = dir.listFiles(new ImportableClassesFileFilter());
        if (files != null) {
            for (File file : files) {
                foundClasses.add(new ImportableGClassNode(file));
            }
        }
        if ((folders = dir.listFiles(new ImportableFoldersFileFilter())) != null) {
            for (File folder : folders) {
                foundClasses.addAll(this.findImportableClasses(folder));
            }
        }
        return foundClasses;
    }

    public static File findImage(File classFile) {
        String[] extensions = new String[]{"png", "jpg", "jpeg", "gif", "bmp", "tiff"};
        File directory = classFile.getAbsoluteFile().getParentFile();
        String stemName = GreenfootUtil.removeExtension(classFile.getAbsoluteFile().getName());
        File[] allFiles = directory.listFiles();
        if (allFiles == null) {
            return null;
        }
        for (File f : allFiles) {
            for (String ext : extensions) {
                if (!f.getName().equalsIgnoreCase(stemName + "." + ext)) continue;
                return f;
            }
        }
        return null;
    }

    @OnThread(value=Tag.FXPlatform)
    private class ImportableGClassNode
    extends GClassNode {
        private final File file;

        public ImportableGClassNode(File file) {
            super(JavaFXUtil.loadImage((File)ImportClassDialog.findImage(file)), Collections.emptyList(), ImportClassDialog.this.classDisplaySelectionManager);
            this.file = file;
        }

        @Override
        public String getQualifiedName() {
            return GreenfootUtil.removeExtension(this.file.getName());
        }

        @Override
        public String getDisplayName() {
            return this.getQualifiedName();
        }

        @Override
        protected void setupClassDisplay(GreenfootStage greenfootStage, ClassDisplay display) {
            display.setOnMouseClicked(e -> {
                if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 2) {
                    ImportClassDialog.this.setResult(this.file);
                    ImportClassDialog.this.close();
                }
            });
        }
    }

    private static class ImportableClassesFileFilter
    implements FileFilter {
        private ImportableClassesFileFilter() {
        }

        @Override
        @OnThread(value=Tag.Any)
        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(".class") || pathname.getAbsolutePath().endsWith("." + SourceType.Java.toString().toLowerCase()) || pathname.getAbsolutePath().endsWith("." + SourceType.Stride.toString().toLowerCase());
        }
    }

    private static class ImportableFoldersFileFilter
    implements FileFilter {
        private ImportableFoldersFileFilter() {
        }

        @Override
        @OnThread(value=Tag.Any)
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

