/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.export;

import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.transform.Affine;

public class ImageEditCanvas
extends Canvas {
    private Image image;
    private double x;
    private double y;
    private double scaleFactor = 1.0;
    private double minScaleFactor;

    public ImageEditCanvas(int width, int height, Image image) {
        super((double)width, (double)height);
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.image = image;
        if (image != null) {
            double minScaleFactorY;
            double minScaleFactorX = this.getWidth() / image.getWidth();
            double d = this.minScaleFactor = minScaleFactorX < (minScaleFactorY = this.getHeight() / image.getHeight()) ? minScaleFactorX : minScaleFactorY;
            if (this.minScaleFactor > 1.0) {
                this.minScaleFactor = 1.0;
            }
        }
    }

    public void paintImage(GraphicsContext graphics) {
        if (this.image != null) {
            Affine oldTx = graphics.getTransform();
            double canvasWidth = this.getWidth();
            double canvasHeight = this.getHeight();
            double imageWidth = this.image.getWidth();
            double imageHeight = this.image.getHeight();
            this.x = this.ensureSuitableCoordinate(this.x, canvasWidth, imageWidth);
            this.y = this.ensureSuitableCoordinate(this.y, canvasHeight, imageHeight);
            double xSnapped = this.x;
            double ySnapped = this.y;
            if (Math.abs(this.scaleFactor - this.minScaleFactor) < 1.0E-7) {
                double xs = (imageWidth / 2.0 + xSnapped) * this.scaleFactor;
                double ys = (imageHeight / 2.0 + ySnapped) * this.scaleFactor;
                int snapThreshold = 7;
                if (Math.abs(xs) < 7.0 && Math.abs(ys) < 7.0) {
                    xSnapped = -imageWidth / 2.0;
                    ySnapped = -imageHeight / 2.0;
                }
            }
            graphics.clearRect(0.0, 0.0, canvasWidth, canvasHeight);
            graphics.translate(canvasWidth / 2.0, canvasHeight / 2.0);
            graphics.scale(this.scaleFactor, this.scaleFactor);
            graphics.translate(xSnapped, ySnapped);
            graphics.drawImage(this.image, 0.0, 0.0);
            graphics.setTransform(oldTx);
        }
    }

    private double ensureSuitableCoordinate(double coordinate, double canvasEdge, double imageEdge) {
        double maxCoordinate = -(canvasEdge / this.scaleFactor) / 2.0;
        double minCoordinate = -(imageEdge + maxCoordinate);
        if (imageEdge * this.scaleFactor <= canvasEdge) {
            return -imageEdge / 2.0;
        }
        if (coordinate > maxCoordinate) {
            return maxCoordinate;
        }
        if (coordinate < minCoordinate) {
            return minCoordinate;
        }
        return coordinate;
    }

    public void fit() {
        this.x = -this.image.getWidth() / 2.0;
        this.y = -this.image.getHeight() / 2.0;
        this.setScale(this.minScaleFactor);
    }

    public void move(double dx, double dy) {
        this.x += dx / this.scaleFactor;
        this.y += dy / this.scaleFactor;
        this.paintImage(this.getGraphicsContext2D());
    }

    public double getScale() {
        return this.scaleFactor;
    }

    public void setScale(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        if (scaleFactor < this.minScaleFactor) {
            this.scaleFactor = this.minScaleFactor;
        }
        this.paintImage(this.getGraphicsContext2D());
    }

    public double getMinimumScale() {
        return this.minScaleFactor;
    }
}

