/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.importer.scratch;

import greenfoot.importer.scratch.ScratchObject;
import greenfoot.importer.scratch.ScratchPoint;
import greenfoot.importer.scratch.ScriptableScratchMorph;
import java.math.BigDecimal;
import java.util.List;

public class ScratchSpriteMorph
extends ScriptableScratchMorph {
    public ScratchSpriteMorph(int version, List<ScratchObject> scratchObjects) {
        super(124, version, scratchObjects);
    }

    @Override
    public int fields() {
        return 9;
    }

    @Override
    protected void constructorContents(StringBuilder acc) {
        acc.append("GreenfootImage img = getImage();\n");
        acc.append("img.scale(").append(this.getBounds().getWidth().intValue()).append(", ").append(this.getBounds().getHeight().intValue()).append(");\n");
    }

    @Override
    protected String greenfootSuperClass() {
        return "Actor";
    }

    @Override
    public ScratchPoint getScaleAmount() {
        return (ScratchPoint)this.scratchObjects.get(super.fields() + 1);
    }

    public ScratchPoint getGreenfootCentre() {
        return new ScratchPoint(this.getBounds().getMiddle().x.subtract(this.getScaleAmount().x.subtract(new BigDecimal(1)).multiply(this.getCostume().getRotationCentre().x)), this.getBounds().getMiddle().y.subtract(this.getScaleAmount().y.subtract(new BigDecimal(1)).multiply(this.getCostume().getRotationCentre().y)));
    }

    @Override
    protected void addHelpers(StringBuilder acc) {
        acc.append("private void turn(int angle)\n{\nsetRotation(getRotation() + angle);\n}\n");
        acc.append("private void move(int speed)\n{\ndouble angle = Math.toRadians( getRotation() );\nint x = (int) Math.round(getX() + Math.cos(angle) * speed);\nint y = (int) Math.round(getY() + Math.sin(angle) * speed);\nsetLocation(x, y);\n}\n");
        acc.append("private boolean atWorldEdge()\n{\nif(getX() < 20 || getX() > getWorld().getWidth() - 20) return true;\nif(getY() < 20 || getY() > getWorld().getHeight() - 20) return true;\nelse return false;\n}\n");
    }
}

