/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import bluej.utility.Debug;
import greenfoot.sound.GreenfootAudioInputStream;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class JavaAudioInputStream
implements GreenfootAudioInputStream {
    private AudioInputStream stream;
    private URL url;
    private boolean readingHasStarted = false;
    private boolean open;

    public JavaAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        this.url = url;
        this.open();
    }

    @Override
    public void open() throws UnsupportedAudioFileException, IOException {
        if (!this.open) {
            this.readingHasStarted = false;
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    Debug.reportError((String)"Exception while closing java audio input stream.", (Throwable)e);
                }
            }
            this.stream = AudioSystem.getAudioInputStream(this.url);
            this.open = true;
        }
    }

    @Override
    public void restart() throws UnsupportedAudioFileException, IOException {
        if (!this.open || this.readingHasStarted() || this.stream == null) {
            this.open = false;
            this.open();
        }
    }

    private boolean readingHasStarted() {
        return this.readingHasStarted;
    }

    @Override
    public String getSource() {
        return this.url.toString();
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        this.stream.close();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JavaAudioInputStream)) {
            return false;
        }
        return this.stream.equals(((JavaAudioInputStream)obj).stream);
    }

    @Override
    public AudioFormat getFormat() {
        return this.stream.getFormat();
    }

    public long getFrameLength() {
        return this.stream.getFrameLength();
    }

    public int hashCode() {
        return this.stream.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.readingHasStarted = true;
        return this.stream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readingHasStarted = true;
        return this.stream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.readingHasStarted = true;
        return this.stream.read(b);
    }

    @Override
    public void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.readingHasStarted = true;
        return this.stream.skip(n);
    }

    public String toString() {
        return this.stream.toString();
    }
}

