/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import bluej.utility.Debug;
import greenfoot.sound.GreenfootAudioInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;

public class Mp3AudioInputStream
implements GreenfootAudioInputStream {
    private Bitstream bitstream;
    private Decoder decoder;
    private URL url;
    private boolean readingHasStarted = false;
    private BufferedInputStream inputStream;
    private AudioFormat format;
    private SampleBuffer unreadSample;
    private boolean open;

    private static void printDebug(String s) {
    }

    public Mp3AudioInputStream(URL url) throws IOException, UnsupportedAudioFileException {
        this.url = url;
        this.open();
        Header header = null;
        try {
            header = this.bitstream.readFrame();
            this.bitstream.unreadFrame();
        }
        catch (BitstreamException e) {
            throw new IOException(e.toString());
        }
        if (header == null) {
            this.bitstream.closeFrame();
            this.format = new AudioFormat(this.decoder.getOutputFrequency(), 16, this.decoder.getOutputChannels(), true, false);
        } else {
            int mode = header.mode();
            int channels = mode == 3 ? 1 : 2;
            this.format = new AudioFormat(header.frequency(), 16, channels, true, false);
        }
        Mp3AudioInputStream.printDebug(" Created mp3 stream with audioFormat: " + String.valueOf(this.format));
    }

    @Override
    public String getSource() {
        return this.url.toString();
    }

    @Override
    public void open() throws IOException, UnsupportedAudioFileException {
        if (!this.open) {
            this.readingHasStarted = false;
            this.unreadSample = null;
            if (this.bitstream != null) {
                try {
                    this.bitstream.close();
                }
                catch (BitstreamException e) {
                    Debug.reportError((String)"Exception while closing mp3 audio input stream.", (Throwable)e);
                }
            }
            this.inputStream = new BufferedInputStream(this.url.openStream());
            this.bitstream = new Bitstream((InputStream)this.inputStream);
            this.decoder = new Decoder();
            this.open = true;
        }
    }

    @Override
    public void restart() throws IOException, UnsupportedAudioFileException {
        if (!this.open || this.readingHasStarted() || this.bitstream == null) {
            this.open = false;
            this.open();
        }
    }

    private boolean readingHasStarted() {
        return this.readingHasStarted;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        try {
            this.bitstream.close();
        }
        catch (BitstreamException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int bytesRead = this.read(b, 0, 1);
        if (bytesRead < 0) {
            return -1;
        }
        if (bytesRead == 0) {
            throw new IOException("cannot read a single byte if frame size > 1");
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0) {
            throw new IllegalArgumentException("The offset must be positive. It was: " + off);
        }
        if (len < 0) {
            throw new IllegalArgumentException("The length must be positive. It was: " + len);
        }
        if (off + len > b.length) {
            throw new IllegalArgumentException("Lenght + offset must not be bigger than the array length.");
        }
        this.readingHasStarted = true;
        Mp3AudioInputStream.printDebug("read() called with params: off:" + off + "  len:" + len);
        Header header = null;
        int read = 0;
        if (this.unreadSample != null) {
            int sampleLength = this.unreadSample.getBufferLength();
            int sampleLengthInBytes = sampleLength * 2;
            if (sampleLengthInBytes > len) {
                Mp3AudioInputStream.printDebug("unreadSample too big. ");
                return 0;
            }
            this.toByteArray(this.unreadSample.getBuffer(), sampleLength, b, off);
            Mp3AudioInputStream.printDebug("UNREAD SAMPLE just read.");
            read += sampleLengthInBytes;
            this.unreadSample = null;
            this.bitstream.closeFrame();
        }
        try {
            header = this.bitstream.readFrame();
        }
        catch (BitstreamException e) {
            throw new IOException(e.toString());
        }
        while (header != null) {
            SampleBuffer sample = null;
            try {
                sample = (SampleBuffer)this.decoder.decodeFrame(header, this.bitstream);
            }
            catch (DecoderException e) {
                throw new IOException(e.toString());
            }
            Mp3AudioInputStream.printDebug("Read: " + read);
            int sampleLength = sample.getBufferLength();
            int sampleLengthInBytes = sampleLength * 2;
            Mp3AudioInputStream.printDebug("Buffer length: " + sampleLength);
            if (read + sampleLengthInBytes > len) {
                this.unreadSample = sample;
                Mp3AudioInputStream.printDebug(" saving unreadSample for later.");
                break;
            }
            this.toByteArray(sample.getBuffer(), sampleLength, b, off + read);
            Mp3AudioInputStream.printDebug("Just read bytes: " + sampleLengthInBytes);
            read += sampleLengthInBytes;
            this.bitstream.closeFrame();
            try {
                header = this.bitstream.readFrame();
            }
            catch (BitstreamException e) {
                throw new IOException(e.toString());
            }
        }
        return read;
    }

    private final void toByteArray(short[] samples, int len, byte[] b, int off) {
        int shortIndex = 0;
        while (len-- > 0) {
            short s = samples[shortIndex++];
            b[off++] = (byte)s;
            b[off++] = (byte)(s >>> 8);
        }
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }
}

