/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import greenfoot.sound.JavaAudioInputStream;
import greenfoot.sound.MidiFileSound;
import greenfoot.sound.Mp3AudioInputStream;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundClip;
import greenfoot.sound.SoundCollection;
import greenfoot.sound.SoundExceptionHandler;
import greenfoot.sound.SoundStream;
import greenfoot.util.GreenfootUtil;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundFactory {
    private static SoundFactory instance;
    private SoundCollection soundCollection = new SoundCollection();
    private static final int maxClipSize = 500000;

    private SoundFactory() {
        for (String soundFile : GreenfootUtil.getSoundFiles()) {
            Sound s = this.createSound(soundFile, true);
            if (!(s instanceof SoundClip)) continue;
            ((SoundClip)s).preLoad();
        }
    }

    public static synchronized SoundFactory getInstance() {
        if (instance == null) {
            instance = new SoundFactory();
        }
        return instance;
    }

    public SoundCollection getSoundCollection() {
        return this.soundCollection;
    }

    public Sound createSound(String file, boolean quiet) {
        block8: {
            try {
                URL url = GreenfootUtil.getURL(file, "sounds");
                int size = url.openConnection().getContentLength();
                if (this.isMidi(url)) {
                    return new MidiFileSound(url, this.soundCollection);
                }
                if (GreenfootUtil.isMp3LibAvailable() || !this.isMp3(url)) {
                    if (this.isMp3(url)) {
                        return new SoundStream(new Mp3AudioInputStream(url), this.soundCollection);
                    }
                    if (this.isJavaAudioStream(size)) {
                        return new SoundStream(new JavaAudioInputStream(url), this.soundCollection);
                    }
                    return new SoundClip(url, this.soundCollection);
                }
                SoundExceptionHandler.handleMp3LibNotAvailable();
            }
            catch (IOException e) {
                if (!quiet) {
                    SoundExceptionHandler.handleIOException(e, file);
                }
            }
            catch (UnsupportedAudioFileException e) {
                if (quiet) break block8;
                SoundExceptionHandler.handleUnsupportedAudioFileException(e, file);
            }
        }
        return null;
    }

    private boolean isJavaAudioStream(int size) {
        return size == -1 || size > 500000;
    }

    private boolean isMidi(URL url) {
        String lowerCaseName = url.toString().toLowerCase();
        return lowerCaseName.endsWith("mid") || lowerCaseName.endsWith("midi");
    }

    private boolean isMp3(URL url) {
        String lowerCaseName = url.toString().toLowerCase();
        return lowerCaseName.endsWith("mp3");
    }
}

