/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import bluej.Config;
import bluej.pkgmgr.Project;
import bluej.prefmgr.MiscPrefPanelItem;
import greenfoot.sound.SoundUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class SoundPreferencePanel
extends GridPane
implements MiscPrefPanelItem {
    private final ComboBox<Mixer> inputDevice = new ComboBox();
    private final ComboBox<Mixer> outputDevice = new ComboBox();

    public SoundPreferencePanel() {
        SoundPreferencePanel.initialize(this.inputDevice, true, mixer -> Arrays.stream(mixer.getTargetLineInfo()).anyMatch(i -> i.getLineClass().equals(TargetDataLine.class)));
        SoundPreferencePanel.initialize(this.outputDevice, false, mixer -> Arrays.stream(mixer.getSourceLineInfo()).anyMatch(i -> i.getLineClass().equals(SourceDataLine.class)));
        Label inputLabel = new Label(Config.getString((String)"greenfoot.sound.input"));
        this.add((Node)inputLabel, 0, 0);
        this.add((Node)this.inputDevice, 1, 0);
        Label outputLabel = new Label(Config.getString((String)"greenfoot.sound.output"));
        this.add((Node)outputLabel, 0, 1);
        this.add((Node)this.outputDevice, 1, 1);
        Label warning = new Label(Config.getString((String)"greenfoot.sound.warning"));
        warning.setWrapText(true);
        this.add((Node)warning, 0, 2);
        SoundPreferencePanel.setColumnSpan((Node)warning, (Integer)2);
        this.setVgap(7.0);
        this.setHgap(5.0);
        ColumnConstraints cc0 = new ColumnConstraints();
        cc0.setMinWidth(Double.NEGATIVE_INFINITY);
        cc0.setHgrow(Priority.ALWAYS);
        ColumnConstraints cc1 = new ColumnConstraints();
        cc1.setMinWidth(Double.NEGATIVE_INFINITY);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{cc0, cc1});
    }

    private static void initialize(ComboBox<Mixer> audioDropdown, boolean input, Predicate<Mixer> valid) {
        audioDropdown.getItems().clear();
        audioDropdown.getItems().add(null);
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!valid.test(mixer)) continue;
            audioDropdown.getItems().add((Object)mixer);
        }
        audioDropdown.getSelectionModel().select((Object)SoundUtils.loadMixer((List<Mixer>)audioDropdown.getItems(), input));
        audioDropdown.setConverter((StringConverter)new StringConverter<Mixer>(){

            public String toString(Mixer object) {
                return object == null ? Config.getString((String)"greenfoot.sound.device.default") : object.getMixerInfo().getName();
            }

            public Mixer fromString(String string) {
                return null;
            }
        });
    }

    public Mixer getInputMixer() {
        return (Mixer)this.inputDevice.getValue();
    }

    @OnThread(value=Tag.FXPlatform)
    public void beginEditing(Project project) {
        this.inputDevice.getSelectionModel().select((Object)SoundUtils.loadMixer((List<Mixer>)this.inputDevice.getItems(), true));
        this.outputDevice.getSelectionModel().select((Object)SoundUtils.loadMixer((List<Mixer>)this.outputDevice.getItems(), false));
    }

    @OnThread(value=Tag.FXPlatform)
    public void commitEditing(Project project) {
        Config.putPropString((String)"greenfoot.sound.device.input", (String)(this.inputDevice.getValue() == null ? "" : ((Mixer)this.inputDevice.getValue()).getMixerInfo().toString()));
        Config.putPropString((String)"greenfoot.sound.device.output", (String)(this.outputDevice.getValue() == null ? "" : ((Mixer)this.outputDevice.getValue()).getMixerInfo().toString()));
    }

    public void revertEditing(Project project) {
    }

    public List<Node> getMiscPanelContents() {
        return List.of(this);
    }

    public String getMiscPanelTitle() {
        return Config.getString((String)"greenfoot.sound.prefs");
    }
}

