/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class GraphicsUtilities {
    private GraphicsUtilities() {
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static BufferedImage createColorModelCompatibleImage(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        return new BufferedImage(cm, cm.createCompatibleWritableRaster(image.getWidth(), image.getHeight()), cm.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return GraphicsUtilities.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
    }

    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        if (image == null) {
            throw new IOException("Image format of resource not supported. Resource: " + String.valueOf(resource));
        }
        return GraphicsUtilities.toCompatibleImage(image);
    }

    public static BufferedImage loadCompatibleTranslucentImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        if (image == null) {
            throw new IOException("Image format of resource not supported. Resource: " + String.valueOf(resource));
        }
        return GraphicsUtilities.toCompatibleTranslucentImage(image);
    }

    public static BufferedImage loadCompatibleTranslucentImage(byte[] imageData) throws IOException {
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
        if (image == null) {
            throw new IOException("Image format of byte data not supported");
        }
        return GraphicsUtilities.toCompatibleTranslucentImage(image);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (image.getColorModel().equals(GraphicsUtilities.getGraphicsConfiguration().getColorModel())) {
            return image;
        }
        BufferedImage compatibleImage = GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static BufferedImage toCompatibleTranslucentImage(BufferedImage image) {
        if (image.getColorModel().equals(GraphicsUtilities.getGraphicsConfiguration().getColorModel()) && image.getColorModel().hasAlpha()) {
            return image;
        }
        BufferedImage compatibleImage = GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static void drawOutlinedText(Graphics2D g, MultiLineStringDimensions d, Color foreground, Color outline) {
        if (foreground == null) {
            foreground = Color.BLACK;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < d.lineShapes.length; ++i) {
            g.setColor(foreground);
            g.fill(d.lineShapes[i]);
            if (outline == null) continue;
            g.setColor(outline);
            g.draw(d.lineShapes[i]);
        }
    }

    private static void setFontOfPixelHeight(Graphics2D g, int style, double targetSize) {
        Font font = new Font("SansSerif", style, 1);
        int i = 1;
        while ((double)i < targetSize) {
            Font bigger = font.deriveFont((float)i);
            g.setFont(bigger);
            if (!((double)bigger.getLineMetrics("WBLMNqpyg", g.getFontRenderContext()).getHeight() < targetSize)) break;
            font = bigger;
            ++i;
        }
        g.setFont(font);
    }

    public static String[] splitLines(String string) {
        return string.replaceAll("\r", "").split("\n");
    }

    public static MultiLineStringDimensions getMultiLineStringDimensions(String[] lines, int style, double size) {
        int i;
        BufferedImage image = GraphicsUtilities.createCompatibleTranslucentImage(1, 1);
        MultiLineStringDimensions r = new MultiLineStringDimensions(lines.length);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        GraphicsUtilities.setFontOfPixelHeight(g, style, size);
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D[] lineBounds = new Rectangle2D[lines.length];
        int maxX = 1;
        int y = 0;
        for (i = 0; i < lines.length; ++i) {
            lineBounds[i] = g.getFontMetrics().getStringBounds(lines[i], g);
            maxX = Math.max(maxX, (int)Math.ceil(lineBounds[i].getWidth()));
            y = (int)((double)y + Math.ceil(lineBounds[i].getHeight()));
        }
        y = Math.max(y + 1, 1);
        r.overallBounds = new Dimension(maxX, y);
        y = 0;
        for (i = 0; i < lines.length; ++i) {
            AffineTransform translate = AffineTransform.getTranslateInstance((r.overallBounds.getWidth() - lineBounds[i].getWidth()) / 2.0, (double)y - lineBounds[i].getMinY());
            r.lineShapes[i] = new TextLayout(!lines[i].isEmpty() ? lines[i] : " ", g.getFont(), frc).getOutline(translate);
            y = (int)((double)y + Math.ceil(lineBounds[i].getHeight()));
        }
        g.dispose();
        return r;
    }

    public static class MultiLineStringDimensions {
        private Shape[] lineShapes;
        private Dimension overallBounds;

        public MultiLineStringDimensions(int length) {
            this.lineShapes = new Shape[length];
        }

        public int getWidth() {
            return this.overallBounds.width;
        }

        public int getHeight() {
            return this.overallBounds.height;
        }
    }
}

