/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import java.util.ArrayList;
import java.util.Collections;

public class HDTimer {
    private static Long sleepPrecision;
    private static long worstYieldTime;
    private static boolean inited;
    private static Long waitPrecision;

    public static synchronized void init() {
        if (!inited) {
            HDTimer.measureSleepPrecision();
            HDTimer.measureWaitPrecision();
            inited = true;
        }
    }

    private static void measureSleepPrecision() {
        int testSize = 11;
        ArrayList<Long> tests = new ArrayList<Long>();
        try {
            for (int i = 0; i < testSize; ++i) {
                long t1 = System.nanoTime();
                Thread.sleep(0L, 1);
                long t2 = System.nanoTime();
                tests.add(t2 - t1);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Collections.sort(tests);
        sleepPrecision = (Long)tests.get(testSize / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void measureWaitPrecision() {
        int testSize = 11;
        ArrayList<Long> tests = new ArrayList<Long>();
        Object lock = new Object();
        try {
            Object object = lock;
            synchronized (object) {
                for (int i = 0; i < testSize; ++i) {
                    long t1 = System.nanoTime();
                    lock.wait(0L, 1);
                    long t2 = System.nanoTime();
                    tests.add(t2 - t1);
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Collections.sort(tests);
        waitPrecision = (Long)tests.get(testSize / 2);
    }

    public static void sleep(long nanos) throws InterruptedException {
        long tStart = System.nanoTime();
        HDTimer.sleepFromTime(nanos, tStart);
    }

    private static void sleepFromTime(long nanos, long tStart) throws InterruptedException {
        long sleepNanos = nanos - sleepPrecision;
        if (nanos / sleepPrecision >= 2L) {
            long actualDelayMillis = sleepNanos / 1000000L;
            int nanoRest = (int)(sleepNanos % 1000000L);
            if (Thread.interrupted()) {
                throw new InterruptedException("HDTimer.sleepFromTime interrupted in sleep.");
            }
            Thread.sleep(actualDelayMillis, nanoRest);
        }
        while (System.nanoTime() - tStart + worstYieldTime < nanos) {
            long t1 = System.nanoTime();
            if (Thread.interrupted()) {
                throw new InterruptedException("HDTimer.sleepFromTime interrupted in yield.");
            }
            Thread.yield();
            long yieldTime = System.nanoTime() - t1;
            if (yieldTime <= worstYieldTime) continue;
            worstYieldTime = yieldTime;
        }
        while (System.nanoTime() - tStart < nanos) {
            if (!Thread.interrupted()) continue;
            throw new InterruptedException("HDTimer.sleepFromTime interrupted in busy loop.");
        }
    }

    static {
        HDTimer.init();
    }
}

