/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.vmcomm;

import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import greenfoot.guifx.GreenfootStage;
import greenfoot.vmcomm.Command;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.input.KeyCode;
import threadchecker.OnThread;
import threadchecker.Tag;

public class VMCommsMain
implements Closeable {
    public static final int DEFAULT_MAPPED_SIZE = 20000000;
    public static final int USER_AREA_OFFSET = 4096;
    public static final int USER_AREA_OFFSET_BYTES = 16384;
    public static final int SERVER_AREA_OFFSET_BYTES = 4;
    public static final int SERVER_AREA_SIZE_BYTES = 16380;
    public static final int SYNC_AREA_OFFSET_BYTES = 0;
    public static final int SYNC_AREA_SIZE_BYTES = 4;
    private final int fileSize;
    private File shmFile;
    private FileChannel fc;
    private MappedByteBuffer sharedMemoryByte;
    private IntBuffer sharedMemory;
    private FileLock putLock;
    private FileLock syncLock;
    private final AtomicInteger lastSeq = new AtomicInteger(0);
    private final List<Command> pendingCommands = new ArrayList<Command>();
    private int setSpeedCommandCount = 0;
    private int lastPaintSeq = -1;
    private int lastConsumedImg = -1;
    private boolean checkingIO = false;
    private boolean haveUpdatedImage = false;
    private boolean haveUpdatedErrorCount = false;
    private long lastExecStartTime;
    private int updatedSimulationSpeed = -1;
    private boolean worldChanged = false;
    private boolean worldPresentAfterChange = false;
    private int[] promptCodepoints = null;
    private int lastAnswer = -1;
    private int previousStoppedWithErrorCount;
    private int prevWorldCounter = 0;
    private int worldCellSize;
    private final Thread ioThread;
    private boolean delayLoop;
    private boolean vmReadyForInvocations = false;
    private int askId = -1;
    private boolean workerWaiting = false;

    public VMCommsMain(Project project) throws IOException {
        this.fileSize = Integer.parseInt(project.getUnnamedPackage().getLastSavedProperties().getProperty("shm.size", Integer.toString(20000000)));
        this.shmFile = File.createTempFile("greenfoot", "shm");
        this.shmFile.deleteOnExit();
        this.fc = new RandomAccessFile(this.shmFile, "rw").getChannel();
        this.sharedMemoryByte = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, this.fileSize);
        this.sharedMemory = this.sharedMemoryByte.asIntBuffer();
        this.putLock = this.fc.lock(4L, 16380L, false);
        this.syncLock = this.fc.lock(0L, 4L, false);
        this.ioThread = new Thread("VMCommsMain"){

            @Override
            @OnThread(value=Tag.Worker)
            public void run() {
                while (VMCommsMain.this.checkIO()) {
                }
            }
        };
        this.ioThread.start();
    }

    @Override
    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void close() {
        try {
            this.fc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.shmFile = null;
        this.fc = null;
        this.sharedMemoryByte = null;
        this.sharedMemory = null;
    }

    public FileChannel getChannel() {
        return this.fc;
    }

    public MappedByteBuffer getSharedBuffer() {
        return this.sharedMemoryByte;
    }

    public File getSharedFile() {
        return this.shmFile;
    }

    public int getSharedFileSize() {
        return this.fileSize;
    }

    private synchronized void writeCommands(List<Command> pendingCommands) {
        int pendingCountPos = this.sharedMemory.position();
        this.sharedMemory.put(pendingCommands.size());
        int numIssued = 0;
        for (Command pendingCommand : pendingCommands) {
            int totalLength = pendingCommand.extraInfo.length + 2;
            if (this.sharedMemory.position() + totalLength > 4096) {
                this.sharedMemory.put(pendingCountPos, numIssued);
                if (numIssued == 0) {
                    throw new RuntimeException("Single command exceeds buffer size");
                }
                return;
            }
            this.sharedMemory.put(pendingCommand.commandSequence);
            this.sharedMemory.put(pendingCommand.extraInfo.length + 1);
            this.sharedMemory.put(pendingCommand.commandType);
            this.sharedMemory.put(pendingCommand.extraInfo);
            ++numIssued;
        }
    }

    public int getWorldCellSize() {
        return this.worldCellSize;
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized boolean checkIO(GreenfootStage stage) {
        boolean shouldDraw;
        if (this.checkingIO) {
            return this.vmReadyForInvocations;
        }
        this.checkingIO = true;
        boolean bl = shouldDraw = !this.worldChanged || this.worldPresentAfterChange;
        if (this.worldChanged) {
            stage.worldChanged(this.worldPresentAfterChange);
            this.worldChanged = false;
        }
        if (this.haveUpdatedImage && shouldDraw) {
            IntBuffer copy = this.sharedMemory.asReadOnlyBuffer();
            copy.position(4098);
            int width = copy.get();
            int height = copy.get();
            stage.receivedWorldImage(width, height, copy);
            this.haveUpdatedImage = false;
            this.lastConsumedImg = this.lastPaintSeq;
        }
        if (this.haveUpdatedErrorCount) {
            stage.bringTerminalToFront();
            this.haveUpdatedErrorCount = false;
        }
        if (this.updatedSimulationSpeed != -1) {
            stage.notifySimulationSpeed(this.updatedSimulationSpeed);
            this.updatedSimulationSpeed = -1;
        }
        if (this.promptCodepoints != null && this.askId > this.lastAnswer) {
            stage.receivedAsk(this.askId, this.promptCodepoints);
            this.promptCodepoints = null;
        } else {
            stage.cancelAsk();
        }
        stage.setLastUserExecutionStartTime(this.lastExecStartTime, this.delayLoop);
        this.checkingIO = false;
        this.notifyAll();
        return this.vmReadyForInvocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Worker)
    private boolean checkIO() {
        block32: {
            FileChannel sharedMemoryLock = this.fc;
            this.sharedMemory.position(1);
            this.sharedMemory.put(-this.lastSeq.get());
            this.sharedMemory.put(this.lastConsumedImg);
            this.writeCommands(this.pendingCommands);
            FileLock fileLock = null;
            try {
                this.putLock.release();
                fileLock = sharedMemoryLock.lock(16384L, this.fileSize - 16384, false);
                this.syncLock.release();
                int seq = this.sharedMemory.get(4096);
                if (seq <= this.lastSeq.get()) break block32;
                this.lastSeq.set(seq);
                VMCommsMain vMCommsMain = this;
                synchronized (vMCommsMain) {
                    int delayLoopStatus;
                    int worldCounter;
                    int latestStoppedWithErrorCount;
                    this.sharedMemory.position(4097);
                    int paintSeq = this.sharedMemory.get();
                    int width = this.sharedMemory.get();
                    int height = this.sharedMemory.get();
                    if (width != 0 && height != 0 && paintSeq != this.lastPaintSeq) {
                        this.lastPaintSeq = paintSeq;
                        this.haveUpdatedImage = true;
                    }
                    this.sharedMemory.position(this.sharedMemory.position() + width * height);
                    int lastAckCommand = this.sharedMemory.get();
                    if (lastAckCommand != -1) {
                        Iterator<Command> iterator = this.pendingCommands.iterator();
                        while (iterator.hasNext()) {
                            Command pendingCommand = iterator.next();
                            if (pendingCommand.commandSequence > lastAckCommand) continue;
                            if (pendingCommand.commandType == 30) {
                                --this.setSpeedCommandCount;
                            }
                            iterator.remove();
                        }
                    }
                    if ((latestStoppedWithErrorCount = this.sharedMemory.get()) != this.previousStoppedWithErrorCount) {
                        this.previousStoppedWithErrorCount = latestStoppedWithErrorCount;
                        this.haveUpdatedErrorCount = true;
                    }
                    int highTime = this.sharedMemory.get();
                    int lowTime = this.sharedMemory.get();
                    this.lastExecStartTime = (long)highTime << 32 | (long)lowTime & 0xFFFFFFFFL;
                    int simSpeed = this.sharedMemory.get();
                    if (this.setSpeedCommandCount == 0) {
                        this.updatedSimulationSpeed = simSpeed;
                    }
                    if ((worldCounter = this.sharedMemory.get()) != this.prevWorldCounter) {
                        this.worldChanged = true;
                        this.worldPresentAfterChange = worldCounter != 0;
                        this.prevWorldCounter = worldCounter;
                    }
                    this.worldCellSize = this.sharedMemory.get();
                    int askId = this.sharedMemory.get();
                    if (askId > 0) {
                        if (askId > this.lastAnswer) {
                            this.askId = askId;
                        }
                        int askLength = this.sharedMemory.get();
                        this.promptCodepoints = new int[askLength];
                        this.sharedMemory.get(this.promptCodepoints);
                    }
                    this.delayLoop = (delayLoopStatus = this.sharedMemory.get()) == 1;
                    int vmReadyStatus = this.sharedMemory.get();
                    this.vmReadyForInvocations = vmReadyStatus == 1;
                }
            }
            catch (IOException ex) {
                Debug.reportError((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
            }
            finally {
                try {
                    this.putLock = this.fc.lock(4L, 16380L, false);
                    if (fileLock != null) {
                        fileLock.release();
                    }
                    this.syncLock = this.fc.lock(0L, 4L, false);
                }
                catch (IOException ex) {
                    Debug.reportError((Throwable)ex);
                }
            }
        }
        VMCommsMain vMCommsMain = this;
        synchronized (vMCommsMain) {
            try {
                this.workerWaiting = true;
                this.wait();
                this.workerWaiting = false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.shmFile != null;
        }
    }

    public synchronized void instantiateWorld(String className) {
        this.pendingCommands.add(new Command(26, className.codePoints().toArray()));
    }

    public synchronized void discardWorld() {
        this.pendingCommands.add(new Command(29, new int[0]));
    }

    public synchronized void sendAnswer(int askIdBeingAnswered, String answer) {
        Command answerCommand = new Command(27, answer.codePoints().toArray());
        this.pendingCommands.add(answerCommand);
        this.lastAnswer = askIdBeingAnswered;
    }

    public synchronized void sendProperty(String key, String value) {
        int[] keyCodepoints = key.codePoints().toArray();
        int[] valueCodepoints = value == null ? new int[]{} : value.codePoints().toArray();
        int[] combined = new int[1 + keyCodepoints.length + 1 + valueCodepoints.length];
        combined[0] = keyCodepoints.length;
        System.arraycopy(keyCodepoints, 0, combined, 1, keyCodepoints.length);
        combined[1 + keyCodepoints.length] = value == null ? -1 : valueCodepoints.length;
        System.arraycopy(valueCodepoints, 0, combined, 2 + keyCodepoints.length, valueCodepoints.length);
        this.pendingCommands.add(new Command(28, combined));
    }

    public synchronized void act() {
        this.pendingCommands.add(new Command(25, new int[0]));
    }

    public synchronized void runSimulation() {
        this.pendingCommands.add(new Command(21, new int[0]));
    }

    public synchronized void pauseSimulation() {
        this.pendingCommands.add(new Command(24, new int[0]));
    }

    public synchronized void continueDrag(int dragId, int x, int y) {
        this.pendingCommands.add(new Command(22, dragId, x, y));
    }

    public synchronized void endDrag(int dragId, int cellX, int cellY) {
        this.pendingCommands.add(new Command(23, dragId, cellX, cellY));
    }

    public synchronized void sendKeyEvent(int eventType, KeyCode keyCode, String keyText) {
        int[] textCodePoints = keyText.codePoints().toArray();
        int[] data = new int[textCodePoints.length + 1];
        data[0] = keyCode.ordinal();
        System.arraycopy(textCodePoints, 0, data, 1, textCodePoints.length);
        this.pendingCommands.add(new Command(eventType, data));
    }

    public synchronized void sendMouseEvent(int eventType, int x, int y, int button, int clickCount) {
        this.pendingCommands.add(new Command(eventType, x, y, button, clickCount));
    }

    public synchronized void setSimulationSpeed(int speed) {
        this.pendingCommands.add(new Command(30, speed));
        ++this.setSpeedCommandCount;
    }

    @OnThread(value=Tag.VMEventHandler)
    public synchronized void vmTerminated() {
        while (!this.workerWaiting) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.lastSeq.addAndGet(1000);
        this.pendingCommands.clear();
        this.setSpeedCommandCount = 0;
        this.lastAnswer = -1;
        this.previousStoppedWithErrorCount = 0;
        this.prevWorldCounter = 0;
        this.sharedMemoryByte.position(0);
        this.sharedMemoryByte.put(new byte[this.fileSize], 0, this.fileSize);
        this.vmReadyForInvocations = false;
    }

    public synchronized void worldFocusChanged(boolean focused) {
        this.pendingCommands.add(new Command(focused ? 40 : 41, new int[0]));
    }

    public int getLastSeq() {
        return this.lastSeq.get();
    }
}

