/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.Config;
import javafx.scene.control.Dialog;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

public class BlueJTheme {
    private static final String SMALL_ICON_SUFFIX = "-icon-32.png";
    private static final String MEDIUM_ICON_SUFFIX = "-icon-48.png";
    private static final String LARGE_ICON_SUFFIX = "-icon-256.png";
    private static String okayLabel;
    private static String cancelLabel;
    private static String closeLabel;
    private static @OnThread(value=Tag.Any) String continueLabel;
    public static final int splitPaneDividerWidth = 3;
    public static final int generalSpacingWidth = 5;
    public static final int commandButtonSpacing = 5;
    public static final int commandButtonPadding = 12;
    public static final int componentSpacingSmall = 5;
    public static final int componentSpacingLarge = 11;
    public static final int dialogCommandButtonsVertical = 17;

    private BlueJTheme() {
    }

    @OnThread(value=Tag.FX)
    public static void setWindowIconFX(Stage frame) {
        Image icon = BlueJTheme.getIconImageFX();
        if (icon != null) {
            frame.getIcons().add((Object)icon);
        }
    }

    @OnThread(value=Tag.FX)
    public static void setWindowIconFX(Dialog<?> dialog) {
        Window window = dialog.getDialogPane().getScene().getWindow();
        if (window != null && window instanceof Stage) {
            BlueJTheme.setWindowIconFX((Stage)window);
        }
    }

    @OnThread(value=Tag.FX)
    public static Image getIconImageFX() {
        String appName = Config.getApplicationName().toLowerCase();
        return BlueJTheme.getApplicationFxIcon(appName, false);
    }

    @OnThread(value=Tag.Any)
    public static String getApplicationIconFileName(String baseName, boolean getStrideEditorIcon) {
        if (Config.isMacOS() && !getStrideEditorIcon) {
            return null;
        }
        if (Config.isModernWinOS()) {
            return baseName + LARGE_ICON_SUFFIX;
        }
        if (Config.isWinOS()) {
            return baseName + SMALL_ICON_SUFFIX;
        }
        return baseName + MEDIUM_ICON_SUFFIX;
    }

    @OnThread(value=Tag.FX)
    public static Image getApplicationFxIcon(String baseName, boolean getStrideEditorIcon) {
        if (Config.isMacOS() && !getStrideEditorIcon) {
            return null;
        }
        return Config.getFixedImageAsFXImage(BlueJTheme.getApplicationIconFileName(baseName, getStrideEditorIcon));
    }

    @OnThread(value=Tag.Any)
    public static synchronized String getContinueLabel() {
        if (continueLabel == null) {
            continueLabel = Config.getString("continue");
        }
        return continueLabel;
    }
}

