/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.Config;
import javafx.animation.AnimationTimer;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.stage.Modality;

public class DataSubmissionFailedDialog
extends Dialog<Void> {
    private final AnimationTimer timer;
    private final long countdown = 20L;

    public DataSubmissionFailedDialog() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.setTitle("Data collection failure");
        Label message = new Label("Connection to the data recording server has failed.  Please tell an instructor, and then restart " + (Config.isGreenfoot() ? "Greenfoot" : "BlueJ") + " to reconnect and continue working.");
        message.setWrapText(true);
        message.setPrefWidth(300.0);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
        final Button ok = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        ok.setText("Ok (20)");
        ok.setOnAction(e -> this.close());
        ok.setDisable(true);
        this.timer = new AnimationTimer(this){
            long time = -1L;
            long prevRemaining = 20L;

            public void handle(long now) {
                if (this.time == -1L) {
                    this.time = now;
                } else {
                    long remaining = 20L - (now - this.time) / 1000000000L;
                    if (this.prevRemaining == remaining) {
                        return;
                    }
                    this.prevRemaining = remaining;
                    if (remaining > 0L) {
                        ok.setText("Ok (" + remaining + ")");
                    } else {
                        ok.setText("Ok");
                        ok.setDisable(false);
                        this.stop();
                    }
                }
            }
        };
        this.setOnShown(ev -> {
            this.timer.start();
            ok.getScene().getWindow().setOnCloseRequest(e -> {
                if (ok.isDisable()) {
                    e.consume();
                }
            });
        });
        this.getDialogPane().setContent((Node)message);
    }
}

