/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import java.io.Serializable;

public class Diagnostic
implements Serializable {
    public static int ERROR = 0;
    public static int WARNING = 1;
    public static int NOTE = 2;
    private final int type;
    private String message;
    private final String fileName;
    private final long startLine;
    private final long startColumn;
    private final long endLine;
    private final long endColumn;
    private String xpath = null;
    private int xmlStart = -1;
    private int xmlEnd = -1;
    private final DiagnosticOrigin origin;
    private final int diagnosticIdentifier;

    public Diagnostic(int type, String message) {
        this(type, message, null, -1L, -1L, -1L, -1L, DiagnosticOrigin.UNKNOWN, -1);
    }

    public Diagnostic(int type, String message, String fileName, long startLine, long startColumn, long endLine, long endColumn, DiagnosticOrigin origin, int identifier) {
        this.type = type;
        this.message = message;
        this.fileName = fileName;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.origin = origin;
        this.diagnosticIdentifier = identifier;
    }

    public int getType() {
        return this.type;
    }

    public long getEndColumn() {
        return this.endColumn;
    }

    public long getEndLine() {
        return this.endLine;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public long getStartColumn() {
        return this.startColumn;
    }

    public long getStartLine() {
        return this.startLine;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getIdentifier() {
        return this.diagnosticIdentifier;
    }

    public String getXPath() {
        return this.xpath;
    }

    public void setXPath(String XPath, int xmlStart, int xmlEnd) {
        this.xpath = XPath;
        this.xmlStart = xmlStart;
        this.xmlEnd = xmlEnd;
    }

    public int getXmlStart() {
        return this.xmlStart;
    }

    public int getXmlEnd() {
        return this.xmlEnd;
    }

    public String getOrigin() {
        return this.origin.serverOrigin;
    }

    public static enum DiagnosticOrigin {
        JAVAC("javac"),
        STRIDE_EARLY("stride_early"),
        STRIDE_LATE("stride_late"),
        UNKNOWN("unknown");

        private String serverOrigin;

        private DiagnosticOrigin(String serverOrigin) {
            this.serverOrigin = serverOrigin;
        }
    }
}

