/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.compiler.CompileInputFile;
import bluej.compiler.CompileObserver;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Compiler;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

record Job(CompileInputFile[] sources, Compiler compiler, CompileObserver observer, BPClassLoader bpClassLoader, File destDir, boolean internal, List<String> userCompileOptions, Charset fileCharset, CompileType type, CompileReason reason) {
    private static final AtomicInteger nextCompilationSequence = new AtomicInteger(1);

    public void compile() {
        block6: {
            int compilationSequence = nextCompilationSequence.getAndIncrement();
            try {
                if (this.observer != null) {
                    this.observer.startCompile(this.sources, this.reason, this.type, compilationSequence);
                }
                if (this.destDir != null) {
                    this.compiler.setDestDir(this.destDir);
                }
                this.compiler.setClasspath(this.bpClassLoader.getClassPathAsFiles());
                this.compiler.setBootClassPath(null);
                File[] actualSourceFiles = new File[this.sources.length];
                for (int i = 0; i < this.sources.length; ++i) {
                    actualSourceFiles[i] = this.sources[i].getJavaCompileInputFile();
                }
                boolean successful = this.compiler.compile(actualSourceFiles, this.observer, this.internal, this.userCompileOptions, this.fileCharset, this.type);
                if (this.observer != null) {
                    this.observer.endCompile(this.sources, successful, this.type, compilationSequence);
                }
            }
            catch (Exception e) {
                System.err.println(Config.getString("compileException") + ": " + String.valueOf(e));
                e.printStackTrace();
                if (this.observer == null) break block6;
                this.observer.endCompile(this.sources, false, this.type, compilationSequence);
            }
        }
    }
}

