/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.Reflective;
import bluej.utility.JavaReflective;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GenTypeArray
extends GenTypeSolid {
    JavaType baseType;

    public GenTypeArray(JavaType baseType) {
        this.baseType = baseType;
    }

    @Override
    public String toString(boolean stripPrefix) {
        return this.baseType.toString(stripPrefix) + "[]";
    }

    @Override
    public String toString(NameTransform nt) {
        return this.baseType.toString(nt) + "[]";
    }

    @Override
    public String toTypeArgString(NameTransform nt) {
        return this.toString(nt);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public String arrayComponentName() {
        return "[" + this.baseType.getUpperBound().arrayComponentName();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaType getCapture() {
        JavaType baseCap = this.baseType.getCapture();
        if (baseCap == this.baseType) {
            return this;
        }
        return baseCap.getArray();
    }

    @Override
    public JavaType getArrayComponent() {
        return this.baseType;
    }

    @Override
    public GenTypeSolid getLowerBound() {
        return this;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean equals(JavaType other) {
        return this.baseType.equals(other.getArrayComponent());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void erasedSuperTypes(Set<Reflective> s) {
        GenTypeSolid baseSolid = this.baseType.getUpperBound().asSolid();
        if (baseSolid != null) {
            HashSet<Reflective> bSupers = new HashSet<Reflective>();
            baseSolid.erasedSuperTypes(bSupers);
            for (Reflective r : bSupers) {
                s.add(r.getArrayOf());
            }
        } else {
            Class<Object> aClass = null;
            JavaType baseType = this.baseType.getUpperBound();
            if (baseType.typeIs(JT_VOID)) {
                aClass = Void.TYPE;
            } else if (baseType.typeIs(JT_BOOLEAN)) {
                aClass = Boolean.TYPE;
            } else if (baseType.typeIs(JT_BYTE)) {
                aClass = Byte.TYPE;
            } else if (baseType.typeIs(JT_CHAR)) {
                aClass = Character.TYPE;
            } else if (baseType.typeIs(JT_DOUBLE)) {
                aClass = Double.TYPE;
            } else if (baseType.typeIs(JT_FLOAT)) {
                aClass = Float.TYPE;
            } else if (baseType.typeIs(JT_INT)) {
                aClass = Integer.TYPE;
            } else if (baseType.typeIs(JT_LONG)) {
                aClass = Long.TYPE;
            }
            s.add(new JavaReflective(aClass).getArrayOf());
        }
    }

    @Override
    public GenTypeArray getArray() {
        return new GenTypeArray(this);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaType getErasedType() {
        JavaType baseErased = this.baseType.getErasedType();
        if (baseErased == this.baseType) {
            return this;
        }
        return baseErased.getArray();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void getParamsFromTemplate(Map<String, GenTypeParameter> map, GenTypeParameter template) {
        GenTypeParameter ntemplate = template.getArrayComponent();
        if (ntemplate != null) {
            this.baseType.getParamsFromTemplate(map, ntemplate);
        }
    }

    @Override
    public GenTypeClass[] getReferenceSupertypes() {
        return new GenTypeClass[0];
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public GenTypeParameter mapTparsToTypes(Map<String, ? extends GenTypeParameter> tparams) {
        GenTypeParameter mappedBase = this.baseType.mapTparsToTypes(tparams);
        if (mappedBase != this.baseType) {
            if (mappedBase.isWildcard()) {
                GenTypeSolid ubound = mappedBase.getUpperBound().asSolid();
                ubound = ubound == null ? null : ubound.getArray();
                GenTypeSolid lbound = mappedBase.getLowerBound();
                lbound = lbound == null ? null : lbound.getArray();
                new GenTypeWildcard(ubound, lbound);
            }
            return mappedBase.getUpperBound().getArray();
        }
        return this;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isAssignableFrom(JavaType t) {
        JavaType componentType = t.getArrayComponent();
        if (componentType != null) {
            return this.baseType.isAssignableFrom(componentType);
        }
        return false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isAssignableFromRaw(JavaType t) {
        JavaType componentType = t.getArrayComponent();
        if (componentType != null) {
            return this.baseType.isAssignableFromRaw(componentType);
        }
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }
}

