/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.gentype.ConstructorReflective;
import bluej.debugger.gentype.FieldReflective;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeSuper;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.debugger.gentype.Reflective;
import bluej.debugger.gentype.TextType;
import bluej.debugger.jdi.JdiArrayReflective;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiUtils;
import bluej.debugger.jdi.VMReference;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.javafx.FXPlatformSupplier;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import threadchecker.OnThread;
import threadchecker.Tag;

public class JdiReflective
extends Reflective {
    private ReferenceType rclass = null;
    protected String name = null;
    private ClassLoaderReference sourceLoader = null;
    private VirtualMachine sourceVM = null;

    public JdiReflective(ReferenceType rclass) {
        this.rclass = rclass;
        if (rclass == null) {
            Debug.message("JdiReflective: null ReferenceType?");
            throw new NullPointerException();
        }
    }

    @OnThread(value=Tag.Any)
    public JdiReflective(String name, ReferenceType sourceType) {
        this.name = name;
        this.sourceLoader = sourceType.classLoader();
        this.sourceVM = sourceType.virtualMachine();
    }

    public JdiReflective(String name, ClassLoaderReference classLoader, VirtualMachine vm) {
        this.name = name;
        this.sourceLoader = classLoader;
        this.sourceVM = vm;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Reflective getRelativeClass(String name) {
        VirtualMachine vm;
        ClassLoaderReference cl;
        if (this.rclass != null) {
            cl = this.rclass.classLoader();
            vm = this.rclass.virtualMachine();
        } else {
            cl = this.sourceLoader;
            vm = this.sourceVM;
        }
        ReferenceType resultClass = JdiReflective.findClass(name, cl, vm);
        if (resultClass == null) {
            return null;
        }
        return new JdiReflective(resultClass);
    }

    @OnThread(value=Tag.FXPlatform)
    protected void checkLoaded() {
        if (this.rclass == null) {
            this.rclass = JdiReflective.findClass(this.name, this.sourceLoader, this.sourceVM);
            if (this.rclass == null) {
                Debug.message("Attempt to use unloaded type: " + this.name);
                Debug.message("  name = " + this.name + ", sourceLoader = " + String.valueOf(this.sourceLoader));
                Debug.message("  (in JdiReflective.checkLoaded()");
                return;
            }
            this.name = null;
            this.sourceLoader = null;
            this.sourceVM = null;
        }
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.rclass.signature().startsWith("[")) {
            return this.rclass.signature().replace('/', '.');
        }
        return this.rclass.name();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isInterface() {
        this.checkLoaded();
        return this.rclass instanceof InterfaceType;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isStatic() {
        this.checkLoaded();
        return this.rclass.isStatic();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isPublic() {
        this.checkLoaded();
        return this.rclass.isPublic();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isFinal() {
        this.checkLoaded();
        return this.rclass.isFinal();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Reflective getArrayOf() {
        if (this.rclass != null) {
            return new JdiArrayReflective(new GenTypeClass(this), this.rclass);
        }
        return new JdiArrayReflective(new GenTypeClass(this), this.sourceLoader, this.sourceVM);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<GenTypeDeclTpar> getTypeParams() {
        this.checkLoaded();
        String gensig = JdiUtils.getJdiUtils().genericSignature(this.rclass);
        if (gensig == null) {
            return Collections.emptyList();
        }
        StringIterator s = new StringIterator(gensig);
        return this.getTypeParams(s);
    }

    @OnThread(value=Tag.FXPlatform)
    private List<GenTypeDeclTpar> getTypeParams(StringIterator s) {
        ArrayList<GenTypeDeclTpar> rlist = new ArrayList<GenTypeDeclTpar>();
        char c = s.peek();
        if (c != '<') {
            return rlist;
        }
        s.next();
        while (c != '>') {
            String paramName = JdiReflective.readClassName(s);
            if (s.current() != ':') {
                Debug.message("getTypeParams : no ':' following type parameter name in super signature?? got " + s.current());
                Debug.message("signature was: " + s.getString());
                return Collections.emptyList();
            }
            if (s.peek() == ':') {
                s.next();
            }
            ArrayList<GenTypeSolid> bounds = new ArrayList<GenTypeSolid>(3);
            while (s.current() == ':') {
                bounds.add((GenTypeSolid)JdiReflective.typeFromSignature(s, null, this.rclass));
                if (s.peek() != ':') continue;
                s.next();
            }
            rlist.add(new GenTypeDeclTpar(paramName, bounds.toArray(new GenTypeSolid[0])));
            c = s.peek();
        }
        s.next();
        return rlist;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<Reflective> getSuperTypesR() {
        this.checkLoaded();
        if (this.rclass instanceof ClassType) {
            LinkedList<Reflective> l = new LinkedList<Reflective>();
            Iterator<InterfaceType> i = ((ClassType)this.rclass).interfaces().iterator();
            while (i.hasNext()) {
                l.add(new JdiReflective(i.next()));
            }
            if (((ClassType)this.rclass).superclass() != null) {
                l.add(new JdiReflective(((ClassType)this.rclass).superclass()));
            }
            return l;
        }
        if (this.rclass instanceof InterfaceType) {
            LinkedList<Reflective> l = new LinkedList<Reflective>();
            Iterator<InterfaceType> i = ((InterfaceType)this.rclass).superinterfaces().iterator();
            while (i.hasNext()) {
                l.add(new JdiReflective(i.next()));
            }
            if (l.isEmpty()) {
                l.add(new JdiReflective("java.lang.Object", this.rclass));
            }
            return l;
        }
        return new LinkedList<Reflective>();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<GenTypeClass> getSuperTypes() {
        this.checkLoaded();
        ArrayList<GenTypeClass> rlist = new ArrayList<GenTypeClass>();
        if (JdiUtils.getJdiUtils().genericSignature(this.rclass) == null) {
            if (this.rclass instanceof ClassType) {
                ClassType ctClass = (ClassType)this.rclass;
                ClassType superclass = ctClass.superclass();
                if (superclass != null) {
                    JdiReflective r = new JdiReflective(ctClass.superclass());
                    rlist.add(new GenTypeClass(r));
                }
                List<InterfaceType> interfaces = ctClass.interfaces();
                Iterator<InterfaceType> i = interfaces.iterator();
                while (i.hasNext()) {
                    JdiReflective r = new JdiReflective(i.next());
                    rlist.add(new GenTypeClass(r));
                }
                return rlist;
            }
            InterfaceType itClass = (InterfaceType)this.rclass;
            List<InterfaceType> interfaces = itClass.superinterfaces();
            Iterator<InterfaceType> i = interfaces.iterator();
            while (i.hasNext()) {
                JdiReflective r = new JdiReflective(i.next());
                rlist.add(new GenTypeClass(r));
            }
            if (rlist.isEmpty()) {
                rlist.add(new GenTypeClass(new JdiReflective("java.lang.Object", this.rclass)));
            }
            return rlist;
        }
        StringIterator s = new StringIterator(JdiUtils.getJdiUtils().genericSignature(this.rclass));
        List<GenTypeDeclTpar> l = this.getTypeParams(s);
        HashMap<String, GenTypeDeclTpar> declTpars = new HashMap<String, GenTypeDeclTpar>();
        for (GenTypeDeclTpar declTpar : l) {
            declTpars.put(declTpar.getTparName(), declTpar);
        }
        while (s.hasNext()) {
            GenTypeClass t = JdiReflective.typeFromSignature(s, declTpars, this.rclass).asSolid().asClass();
            rlist.add(t);
        }
        return rlist;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isAssignableFrom(Reflective r) {
        if (this.equals(r)) {
            return true;
        }
        if (this.getName().equals("java.lang.Object")) {
            return true;
        }
        if (r instanceof JdiReflective) {
            JdiReflective jr = (JdiReflective)r;
            jr.checkLoaded();
            return JdiReflective.checkAssignability(this.rclass, jr.rclass);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static boolean checkAssignability(ReferenceType a, ReferenceType b) {
        List<InterfaceType> l;
        block12: {
            while (true) {
                if (a instanceof ClassType) {
                    if (b instanceof InterfaceType) {
                        l = ((ClassType)a).allInterfaces();
                        return l.contains(b);
                    }
                    break;
                }
                if (a instanceof InterfaceType) {
                    if (!(b instanceof InterfaceType)) {
                        return false;
                    }
                    break block12;
                }
                if (!(a instanceof ArrayType)) return false;
                if (!(b instanceof ArrayType)) {
                    return false;
                }
                try {
                    Type an = ((ArrayType)a).componentType();
                    Type bn = ((ArrayType)b).componentType();
                    if (!(an instanceof ReferenceType)) return false;
                    if (!(bn instanceof ReferenceType)) return false;
                    a = (ReferenceType)an;
                    b = (ReferenceType)bn;
                }
                catch (ClassNotLoadedException cnle) {
                    return false;
                }
            }
            if (!(b instanceof ClassType)) return false;
            ClassType classType = (ClassType)a;
            while (classType != null) {
                if (b.equals(classType)) {
                    return true;
                }
                classType = classType.superclass();
            }
            return false;
        }
        l = new LinkedList<InterfaceType>();
        l.addAll(((InterfaceType)a).superinterfaces());
        while (!l.isEmpty()) {
            InterfaceType it = l.get(0);
            if (a.equals(it)) {
                return true;
            }
            l.addAll(it.superinterfaces());
            l.remove(0);
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    private static ReferenceType findClass(String name, ClassLoaderReference cl, VirtualMachine vm) {
        VMReference vmr;
        if (cl != null) {
            for (ReferenceType ct : cl.visibleClasses()) {
                if (!ct.name().equals(name)) continue;
                return ct;
            }
        } else {
            for (ReferenceType ct : vm.classesByName(name)) {
                if (ct.classLoader() != null) continue;
                return ct;
            }
        }
        if ((vmr = VMReference.getVmForMachine(vm)) != null) {
            return vmr.loadClass(name, cl);
        }
        return null;
    }

    @OnThread(value=Tag.Any)
    private static String readClassName(StringIterator i) {
        char c = i.next();
        Object r = new String();
        while (c != '<' && c != ';' && c != ':') {
            r = (String)r + (c == '/' ? (char)'.' : (char)c);
            c = i.next();
        }
        return r;
    }

    @OnThread(value=Tag.FXPlatform)
    private static GenTypeParameter fromSignature(StringIterator i, Map<String, ? extends GenTypeParameter> tparams, ReferenceType parent) {
        char c = i.peek();
        if (c == '*') {
            i.next();
            JdiReflective objRef = new JdiReflective("java.lang.Object", parent);
            GenTypeClass objClass = new GenTypeClass(objRef);
            return new GenTypeUnbounded(objClass);
        }
        if (c == '+') {
            i.next();
            GenTypeSolid t = (GenTypeSolid)JdiReflective.typeFromSignature(i, null, parent);
            if (tparams != null) {
                return new GenTypeExtends(t).mapTparsToTypes((Map)tparams);
            }
            return new GenTypeExtends(t);
        }
        if (c == '-') {
            i.next();
            GenTypeSolid t = (GenTypeSolid)JdiReflective.fromSignature(i, null, parent);
            if (tparams != null) {
                return new GenTypeSuper(t).mapTparsToTypes((Map)tparams);
            }
            return new GenTypeSuper(t);
        }
        return JdiReflective.typeFromSignature(i, tparams, parent);
    }

    @OnThread(value=Tag.FXPlatform)
    public static GenTypeParameter typeFromSignature(StringIterator i, Map<String, ? extends GenTypeParameter> tparams, ReferenceType parent) {
        char c = i.next();
        if (c == '[') {
            JavaType t = JdiReflective.typeFromSignature(i, tparams, parent).getTparCapture();
            return t.getArray();
        }
        if (c == 'T') {
            String tname = JdiReflective.readClassName(i);
            if (tparams != null && tparams.get(tname) != null) {
                return tparams.get(tname);
            }
            return new GenTypeTpar(tname);
        }
        if (c == 'I') {
            return JavaPrimitiveType.getInt();
        }
        if (c == 'C') {
            return JavaPrimitiveType.getChar();
        }
        if (c == 'Z') {
            return JavaPrimitiveType.getBoolean();
        }
        if (c == 'B') {
            return JavaPrimitiveType.getByte();
        }
        if (c == 'S') {
            return JavaPrimitiveType.getShort();
        }
        if (c == 'J') {
            return JavaPrimitiveType.getLong();
        }
        if (c == 'F') {
            return JavaPrimitiveType.getFloat();
        }
        if (c == 'D') {
            return JavaPrimitiveType.getDouble();
        }
        if (c == 'V') {
            return JavaPrimitiveType.getVoid();
        }
        if (c != 'L') {
            Debug.message("Generic signature begins without 'L'?? (got " + c + ")");
        }
        String basename = JdiReflective.readClassName(i);
        JdiReflective reflective = new JdiReflective(basename, parent);
        c = i.current();
        if (c == ';') {
            return new GenTypeClass((Reflective)reflective, (List<GenTypeParameter>)null);
        }
        if (c != '<') {
            Debug.message("Generic signature: expected '<', got '" + c + "' ??");
            return null;
        }
        ArrayList<GenTypeParameter> params = new ArrayList<GenTypeParameter>();
        do {
            GenTypeParameter ptype;
            if ((ptype = JdiReflective.fromSignature(i, tparams, parent)) == null) {
                return null;
            }
            params.add(ptype);
        } while (i.peek() != '>');
        i.next();
        c = i.next();
        GenTypeClass result = new GenTypeClass((Reflective)reflective, params);
        if (c == '.') {
            return JdiReflective.innerFromSignature(i, basename, result, tparams, parent);
        }
        return result;
    }

    @OnThread(value=Tag.FXPlatform)
    private static GenTypeClass innerFromSignature(StringIterator i, String outerName, GenTypeClass outer, Map<String, ? extends GenTypeParameter> tparams, ReferenceType parent) {
        String basename = JdiReflective.readClassName(i);
        String innerName = outerName + "$" + basename;
        JdiReflective reflective = new JdiReflective(innerName, parent);
        char c = i.current();
        if (c == ';') {
            return new GenTypeClass(reflective, null, outer);
        }
        if (c == '<') {
            ArrayList<GenTypeParameter> params = new ArrayList<GenTypeParameter>();
            do {
                GenTypeParameter ptype;
                if ((ptype = JdiReflective.fromSignature(i, tparams, parent)) == null) {
                    return null;
                }
                params.add(ptype);
            } while (i.peek() != '>');
            i.next();
            c = i.next();
            GenTypeClass result = new GenTypeClass(reflective, params, outer);
            if (c == '.') {
                return JdiReflective.innerFromSignature(i, innerName, result, tparams, parent);
            }
            return result;
        }
        Debug.message("Generic signature: expected '<', got '" + c + "' ??");
        return null;
    }

    @OnThread(value=Tag.FXPlatform)
    private static JavaType getNonGenericType(String typeName, Type t, ClassLoaderReference clr, VirtualMachine vm) {
        if (t instanceof BooleanType) {
            return JavaPrimitiveType.getBoolean();
        }
        if (t instanceof ByteType) {
            return JavaPrimitiveType.getByte();
        }
        if (t instanceof CharType) {
            return JavaPrimitiveType.getChar();
        }
        if (t instanceof DoubleType) {
            return JavaPrimitiveType.getDouble();
        }
        if (t instanceof FloatType) {
            return JavaPrimitiveType.getFloat();
        }
        if (t instanceof IntegerType) {
            return JavaPrimitiveType.getInt();
        }
        if (t instanceof LongType) {
            return JavaPrimitiveType.getLong();
        }
        if (t instanceof ShortType) {
            return JavaPrimitiveType.getShort();
        }
        if (t == null) {
            return new TextType(typeName);
        }
        String tname = t.signature();
        if (tname.startsWith("[")) {
            JavaType arrayType = JdiReflective.typeFromSignature(new StringIterator(tname), null, (ReferenceType)t).asType();
            return arrayType;
        }
        tname = t.name();
        JdiReflective ref = new JdiReflective(tname, clr, vm);
        return new GenTypeClass((Reflective)ref, (List<GenTypeParameter>)null);
    }

    private static String typeNameToBinaryName(String typeName) {
        int arrIndex = typeName.indexOf(91);
        if (arrIndex == -1) {
            return typeName;
        }
        String binName = "L" + typeName.substring(0, arrIndex) + ";";
        do {
            binName = "[" + binName;
        } while ((arrIndex = typeName.indexOf(91, arrIndex + 1)) != -1);
        return binName;
    }

    @OnThread(value=Tag.FXPlatform)
    public static JavaType fromField(Field f, JdiObject parent) {
        Type t = null;
        try {
            t = f.type();
        }
        catch (ClassNotLoadedException cnle) {
            t = JdiReflective.findClass(JdiReflective.typeNameToBinaryName(f.typeName()), f.declaringType().classLoader(), f.virtualMachine());
        }
        String gensig = JdiUtils.getJdiUtils().genericSignature(f);
        if (gensig == null) {
            return JdiReflective.getNonGenericType(f.typeName(), t, parent.obj.referenceType().classLoader(), parent.obj.virtualMachine());
        }
        GenTypeClass genType = parent.getGenType();
        HashMap<String, GenTypeParameter> tparams = genType.mapToSuper(f.declaringType().name()).getMap();
        if (tparams == null) {
            JdiReflective r = new JdiReflective(f.typeName(), parent.obj.referenceType());
            return new GenTypeClass(r);
        }
        StringIterator iterator = new StringIterator(gensig);
        return JdiReflective.typeFromSignature(iterator, tparams, parent.obj.referenceType()).getTparCapture();
    }

    @OnThread(value=Tag.FXPlatform)
    public static JavaType fromField(Field f) {
        Type t;
        ReferenceType parent = f.declaringType();
        try {
            t = f.type();
        }
        catch (ClassNotLoadedException cnle) {
            t = JdiReflective.findClass(JdiReflective.typeNameToBinaryName(f.typeName()), f.declaringType().classLoader(), f.virtualMachine());
        }
        String gensig = JdiUtils.getJdiUtils().genericSignature(f);
        if (gensig == null) {
            return JdiReflective.getNonGenericType(f.typeName(), t, parent.classLoader(), parent.virtualMachine());
        }
        StringIterator iterator = new StringIterator(gensig);
        return JdiReflective.typeFromSignature(iterator, null, parent).getTparCapture();
    }

    @OnThread(value=Tag.FXPlatform)
    public static JavaType fromLocalVar(Type t, String genericSignature, String typeName, ReferenceType declaringType) {
        if (t == null) {
            t = JdiReflective.findClass(JdiReflective.typeNameToBinaryName(typeName), declaringType.classLoader(), declaringType.virtualMachine());
        }
        if (genericSignature == null) {
            return JdiReflective.getNonGenericType(typeName, t, declaringType.classLoader(), declaringType.virtualMachine());
        }
        StringIterator iterator = new StringIterator(genericSignature);
        HashMap<String, GenTypeParameter> tparams = new HashMap<String, GenTypeParameter>();
        JdiReflective.addDefaultParamBases(tparams, new JdiReflective(declaringType));
        return JdiReflective.typeFromSignature(iterator, tparams, declaringType).getTparCapture();
    }

    @OnThread(value=Tag.VMEventHandler)
    public static FXPlatformSupplier<JavaType> fromLocalVar(StackFrame sf, LocalVariable var) {
        Type t;
        Location l = sf.location();
        ReferenceType declType = l.declaringType();
        try {
            t = var.type();
        }
        catch (ClassNotLoadedException cnle) {
            t = null;
        }
        String gensig = JdiUtils.getJdiUtils().genericSignature(var);
        String typeName = var.typeName();
        Type tFinal = t;
        return () -> JdiReflective.fromLocalVar(tFinal, gensig, typeName, declType);
    }

    @OnThread(value=Tag.FXPlatform)
    private static void addDefaultParamBases(Map<String, GenTypeParameter> tparams, JdiReflective declaringType) {
        while (declaringType != null) {
            for (GenTypeDeclTpar tpar : declaringType.getTypeParams()) {
                String paramName = tpar.getTparName();
                GenTypeSolid[] ubounds = tpar.upperBounds();
                GenTypeWildcard type = new GenTypeWildcard(IntersectionType.getIntersection(ubounds), null);
                if (tparams.containsKey(paramName)) continue;
                tparams.put(paramName, type);
            }
            declaringType = declaringType.getOuterType();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private JdiReflective getOuterType() {
        this.checkLoaded();
        String myName = this.getName();
        int x = myName.indexOf(36);
        if (x != -1 && !this.rclass.isStatic()) {
            String outerName = myName.substring(0, x);
            return (JdiReflective)this.getRelativeClass(outerName);
        }
        return null;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Map<String, FieldReflective> getDeclaredFields() {
        this.checkLoaded();
        List<Field> fields = this.rclass.fields();
        HashMap<String, FieldReflective> rfields = new HashMap<String, FieldReflective>();
        for (Field field : fields) {
            String genSig = field.genericSignature();
            if (genSig == null) {
                genSig = field.signature();
            }
            StringIterator i = new StringIterator(genSig);
            JavaType ftype = JdiReflective.typeFromSignature(i, null, this.rclass).getTparCapture();
            FieldReflective fref = new FieldReflective(field.name(), ftype, field.modifiers(), this);
            rfields.put(field.name(), fref);
        }
        return rfields;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Map<String, Set<MethodReflective>> getDeclaredMethods() {
        this.checkLoaded();
        List<Method> methods = this.rclass.methods();
        HashMap<String, Set<MethodReflective>> methodMap = new HashMap<String, Set<MethodReflective>>();
        for (Method method : methods) {
            if (method.isSynthetic()) continue;
            String genSig = method.genericSignature();
            if (genSig == null) {
                genSig = method.signature();
            }
            StringIterator i = new StringIterator(genSig);
            List<GenTypeDeclTpar> tparTypes = this.getTypeParams(i);
            char c = i.next();
            if (c != '(') continue;
            ArrayList<JavaType> paramTypes = new ArrayList<JavaType>();
            while (i.peek() != ')') {
                paramTypes.add(JdiReflective.typeFromSignature(i, null, this.rclass).getTparCapture());
            }
            i.next();
            JavaType returnType = JdiReflective.typeFromSignature(i, null, this.rclass).getTparCapture();
            boolean isVarArgs = method.isVarArgs();
            int modifiers = method.modifiers();
            MethodReflective mr = new MethodReflective(method.name(), returnType, tparTypes, paramTypes, this, isVarArgs, modifiers);
            HashSet<MethodReflective> mset = (HashSet<MethodReflective>)methodMap.get(mr.getName());
            if (mset == null) {
                mset = new HashSet<MethodReflective>();
                methodMap.put(mr.getName(), mset);
            }
            mset.add(mr);
        }
        return methodMap;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<ConstructorReflective> getDeclaredConstructors() {
        this.checkLoaded();
        return this.rclass.methods().stream().filter(m -> m.isConstructor() && !m.isSynthetic()).map(con -> {
            String genSig = con.genericSignature();
            if (genSig == null) {
                genSig = con.signature();
            }
            StringIterator i = new StringIterator(genSig);
            List<GenTypeDeclTpar> tparTypes = this.getTypeParams(i);
            char c = i.next();
            if (c != '(') {
                return null;
            }
            ArrayList<JavaType> paramTypes = new ArrayList<JavaType>();
            while (i.peek() != ')') {
                paramTypes.add(JdiReflective.typeFromSignature(i, null, this.rclass).getTparCapture());
            }
            i.next();
            boolean isVarArgs = con.isVarArgs();
            return new ConstructorReflective(tparTypes, paramTypes, this, isVarArgs, con.modifiers());
        }).filter(c -> c != null).collect(Collectors.toList());
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Reflective getInnerClass(String name) {
        this.checkLoaded();
        for (ReferenceType nested : this.rclass.nestedTypes()) {
            if (!JavaNames.getBase(nested.name()).equals(name)) continue;
            return new JdiReflective(nested);
        }
        ClassLoaderReference sourceLoader = this.rclass.classLoader();
        VirtualMachine sourceVM = this.rclass.virtualMachine();
        ReferenceType nested = JdiReflective.findClass(this.getName() + "$" + name, sourceLoader, sourceVM);
        if (nested != null) {
            return new JdiReflective(nested);
        }
        return null;
    }

    @Override
    public String getModuleName() {
        try {
            return this.rclass.module() != null ? this.rclass.module().name() : null;
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @OnThread(value=Tag.Any)
    static class StringIterator {
        int i = 0;
        String s;

        public StringIterator(String s) {
            this.s = s;
            if (s == null) {
                Debug.message("StringIterator with null string??");
            }
        }

        public char current() {
            return this.s.charAt(this.i - 1);
        }

        public char next() {
            return this.s.charAt(this.i++);
        }

        public char peek() {
            return this.s.charAt(this.i);
        }

        public boolean hasNext() {
            return this.i < this.s.length();
        }

        public String getString() {
            return this.s;
        }
    }
}

