/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.Debugger;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.VMReference;
import bluej.utility.Debug;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.VMEventHandler)
class VMEventHandler
extends Thread {
    static final String DONT_RESUME = "dontResume";
    private final VMReference vm;
    private final @OnThread(value=Tag.Any) LinkedBlockingQueue<Object> incomingEvents = new LinkedBlockingQueue();
    private final @OnThread(value=Tag.Any) AtomicBoolean exiting = new AtomicBoolean(false);
    private final Thread subThread;

    @OnThread(value=Tag.Any)
    VMEventHandler(VMReference vm, final VirtualMachine vmm) {
        super("vm-event-handler");
        this.vm = vm;
        this.subThread = new Thread("VM Event Handler Helper"){

            @Override
            public void run() {
                while (!VMEventHandler.this.exiting.get()) {
                    try {
                        EventSet eventSet = vmm.eventQueue().remove();
                        VMEventHandler.this.incomingEvents.add(eventSet);
                    }
                    catch (InterruptedException eventSet) {
                    }
                    catch (VMDisconnectedException discExc) {
                        return;
                    }
                }
            }
        };
        this.subThread.start();
        this.start();
    }

    @Override
    @OnThread(value=Tag.VMEventHandler, ignoreParent=true)
    public void run() {
        while (!this.exiting.get()) {
            try {
                Object event = this.incomingEvents.take();
                if (event instanceof EventSet) {
                    Event ev;
                    EventSet eventSet = (EventSet)event;
                    boolean addToSuspendCount = true;
                    EventIterator it = eventSet.eventIterator();
                    boolean examineSaidSkipUpdates = false;
                    boolean gotBPEvent = false;
                    while (it.hasNext()) {
                        ev = it.nextEvent();
                        examineSaidSkipUpdates |= this.screenEvent(ev);
                        if (ev.request() == null || !addToSuspendCount || ev.request().getProperty(DONT_RESUME) == null || !(ev instanceof LocatableEvent)) continue;
                        LocatableEvent le = (LocatableEvent)ev;
                        le.thread().suspend();
                        addToSuspendCount = false;
                        gotBPEvent |= ev instanceof BreakpointEvent;
                    }
                    it = eventSet.eventIterator();
                    while (it.hasNext()) {
                        ev = it.nextEvent();
                        this.handleEvent(ev, examineSaidSkipUpdates, gotBPEvent);
                        if (!(ev instanceof VMDisconnectEvent)) continue;
                        this.exiting.set(true);
                    }
                    eventSet.resume();
                    continue;
                }
                if (event instanceof ThreadEvent) {
                    ThreadEvent halted = (ThreadEvent)event;
                    if (halted.state) {
                        this.vm.threadHaltedEvent(halted.thread);
                        continue;
                    }
                    this.vm.threadResumedEvent(halted.thread);
                    continue;
                }
                if (!(event instanceof Debugger.EventHandlerRunnable)) continue;
                ((Debugger.EventHandlerRunnable)event).run();
            }
            catch (InterruptedException event) {
            }
            catch (VMDisconnectedException discExc) {
                this.exiting.set(true);
            }
        }
    }

    @OnThread(value=Tag.Any)
    public synchronized void emitThreadEvent(JdiThread thr, boolean halted) {
        this.incomingEvents.add(new ThreadEvent(this, thr, halted));
    }

    private static int getStepType(StepEvent ev) {
        EventRequest req = ev.request();
        if (req instanceof StepRequest) {
            int stepDepth = ((StepRequest)req).depth();
            if (stepDepth == 1) {
                return 4;
            }
            if (stepDepth == 2) {
                return 3;
            }
        }
        return 2;
    }

    @OnThread(value=Tag.VMEventHandler)
    private boolean screenEvent(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.vm.screenBreakpointEvent((LocatableEvent)event, 5);
        }
        if (event instanceof StepEvent) {
            return this.vm.screenBreakpointEvent((LocatableEvent)event, VMEventHandler.getStepType((StepEvent)event));
        }
        return false;
    }

    private void handleEvent(Event event, boolean skipUpdate, boolean gotBP) {
        if (event instanceof VMStartEvent) {
            this.vm.vmStartEvent((VMStartEvent)event);
        } else if (!(event instanceof VMDeathEvent)) {
            if (event instanceof VMDisconnectEvent) {
                this.vm.vmDisconnectEvent();
            } else if (event instanceof ExceptionEvent) {
                this.vm.exceptionEvent((ExceptionEvent)event);
            } else if (event instanceof BreakpointEvent) {
                this.vm.breakpointEvent((LocatableEvent)event, 5, skipUpdate);
            } else if (event instanceof StepEvent) {
                if (!gotBP) {
                    this.vm.breakpointEvent((LocatableEvent)event, VMEventHandler.getStepType((StepEvent)event), skipUpdate);
                }
            } else if (event instanceof ThreadStartEvent) {
                this.vm.threadStartEvent((ThreadStartEvent)event);
            } else if (event instanceof ThreadDeathEvent) {
                this.vm.threadDeathEvent((ThreadDeathEvent)event);
            } else if (event instanceof ClassPrepareEvent) {
                this.classPrepareEvent(event);
            }
        }
    }

    private boolean classPrepareEvent(Event event) {
        ClassPrepareEvent cle = (ClassPrepareEvent)event;
        ReferenceType refType = cle.referenceType();
        if (refType.name().equals(VMReference.SERVER_CLASSNAME)) {
            this.vm.serverClassPrepared();
        }
        return true;
    }

    @OnThread(value=Tag.Any)
    public void queueRunnable(Debugger.EventHandlerRunnable runnable) {
        try {
            this.incomingEvents.put(runnable);
        }
        catch (InterruptedException e) {
            Debug.reportError(e);
        }
    }

    @OnThread(value=Tag.Any)
    private class ThreadEvent {
        JdiThread thread;
        boolean state;

        ThreadEvent(VMEventHandler vMEventHandler, JdiThread thread, boolean state) {
            this.thread = thread;
            this.state = state;
        }
    }
}

