/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.inspector.FieldInfo;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.JavaUtils;
import bluej.utility.javafx.FXFormattedPrintWriter;
import bluej.utility.javafx.JavaFXUtil;
import bluej.views.Comment;
import bluej.views.MethodView;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ResultInspector
extends Inspector {
    protected static final String resultTitle = Config.getString("debugger.inspector.result.title");
    protected static final String returnedString = Config.getString("debugger.inspector.result.returned");
    protected DebuggerObject obj;
    protected String objName;
    private ExpressionInformation expressionInformation;
    private JavaType resultType;
    private VBox contentPane;

    public ResultInspector(DebuggerObject obj, InspectorManager inspectorManager, String name, Package pkg, InvokerRecord ir, ExpressionInformation info) {
        super(inspectorManager, pkg, ir, StageStyle.DECORATED);
        this.expressionInformation = info;
        this.obj = obj;
        this.objName = name;
        this.calcResultType();
        this.makeFrame();
        this.update();
    }

    private void calcResultType() {
        GenTypeClass instanceType = this.expressionInformation.getInstanceType();
        MethodView methodView = (MethodView)this.expressionInformation.getMethodView();
        Method m = methodView.getMethod();
        JavaType methodReturnType = methodView.getGenericReturnType();
        if (methodReturnType instanceof GenTypeParameter) {
            HashMap<Object, Object> tparmap = instanceType != null ? instanceType.mapToSuper(m.getDeclaringClass().getName()).getMap() : new HashMap();
            if (tparmap == null) {
                this.resultType = JavaUtils.getJavaUtils().getRawReturnType(m);
                return;
            }
            List<GenTypeDeclTpar> tpars = JavaUtils.getJavaUtils().getTypeParams(m);
            tparmap.putAll(JavaUtils.TParamsToMap(tpars));
            methodReturnType = methodReturnType.mapTparsToTypes(tparmap).getUpperBound();
        }
        this.resultType = methodReturnType;
    }

    @Override
    protected boolean shouldAutoUpdate() {
        return false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    protected List<FieldInfo> getListData() {
        DebuggerObject resultObject;
        DebuggerField resultField = this.obj.getField(0);
        String fieldString = !this.resultType.isPrimitive() ? (!(resultObject = resultField.getValueObject(this.resultType)).isNullObject() ? resultObject.getGenType().toString(true) : this.resultType.toString(true)) : resultField.getType().toString(true);
        ArrayList<FieldInfo> rlist = new ArrayList<FieldInfo>(1);
        rlist.add(new FieldInfo(fieldString, resultField.getValueString()));
        return rlist;
    }

    protected void makeFrame() {
        this.setTitle(resultTitle);
        BlueJTheme.setWindowIconFX(this);
        VBox header = new VBox();
        Comment comment = this.expressionInformation.getComment();
        FXFormattedPrintWriter commentLabelPrintWriter = new FXFormattedPrintWriter();
        comment.print(commentLabelPrintWriter);
        Node commentLabel = commentLabelPrintWriter.getNode();
        header.getChildren().add((Object)commentLabel);
        Label sig = new Label(this.expressionInformation.getSignature());
        header.getChildren().add((Object)sig);
        JavaFXUtil.addStyleClass((Styleable)sig, "inspector-header", "inspector-result-header");
        BorderPane mainPanel = new BorderPane();
        VBox result = new VBox();
        JavaFXUtil.addStyleClass((Styleable)result, "inspector-result-details");
        String expressionDisplay = this.expressionInformation.getExpression();
        TextFlow expression = new TextFlow(new Node[]{new Text(expressionDisplay + " " + returnedString)});
        JavaFXUtil.addStyleClass((Styleable)expression, "inspector-result-details-header");
        ContextMenu copyPopup = new ContextMenu();
        copyPopup.getItems().add((Object)JavaFXUtil.makeMenuItem(Config.getString("editor.copyLabel"), () -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, expressionDisplay)), null));
        expression.setOnContextMenuRequested(arg_0 -> ResultInspector.lambda$makeFrame$1(copyPopup, (Node)expression, arg_0));
        result.getChildren().add((Object)expression);
        result.getChildren().add((Object)this.fieldList);
        mainPanel.setCenter((Node)result);
        mainPanel.setRight(this.createInspectAndGetButtons());
        BorderPane buttonPanel = new BorderPane();
        Button button = this.createCloseButton();
        buttonPanel.setRight((Node)button);
        this.contentPane = new VBox(new Node[]{header, mainPanel, buttonPanel});
        Config.addDialogStylesheets((Pane)this.contentPane);
        JavaFXUtil.addStyleClass((Styleable)this.contentPane, "inspector", "inspector-result");
        button.setDefaultButton(true);
        this.setScene(new Scene((Parent)this.contentPane));
    }

    @Override
    public Region getContent() {
        return this.contentPane;
    }

    @Override
    protected void listElementSelected(int slot) {
        DebuggerField field = this.obj.getInstanceField(0);
        if (field.isReferenceType() && !field.isNull()) {
            this.setCurrentObj(field.getValueObject(this.resultType), null, this.resultType.toString(false));
            this.setButtonsEnabled(true, true);
        } else {
            this.setCurrentObj(null, null, null);
            this.setButtonsEnabled(false, false);
        }
    }

    @Override
    protected void doInspect() {
        if (this.selectedField != null) {
            boolean isPublic = !this.getButton.isDisable();
            this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? this.ir : null, (Window)this, null);
        }
    }

    @Override
    protected void remove() {
        if (this.inspectorManager != null) {
            this.inspectorManager.removeInspector(this.obj);
        }
    }

    public String getResult() {
        DebuggerField resultField = this.obj.getField(0);
        String result = String.valueOf(resultField.getType()) + " " + resultField.getName() + " = " + resultField.getValueString();
        return result;
    }

    @Override
    protected int getPreferredRows() {
        return 2;
    }

    @Override
    protected void doGet() {
        if (this.selectedField != null) {
            GenTypeClass resultClass = this.resultType.asClass();
            this.pkg.getEditor().raisePutOnBenchEvent((Window)this, this.selectedField, resultClass, this.ir, true, Optional.empty());
        }
    }

    private static /* synthetic */ void lambda$makeFrame$1(ContextMenu copyPopup, Node expression, ContextMenuEvent e) {
        copyPopup.show(expression, e.getScreenX(), e.getScreenY());
    }
}

