/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.objectbench;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ValueCollection;
import bluej.debugmgr.objectbench.ObjectBenchEvent;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.debugmgr.objectbench.ObjectBenchListener;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.JavaNames;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.css.Styleable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.TilePane;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ObjectBench
extends ScrollPane
implements ValueCollection,
ObjectBenchInterface,
PkgMgrFrame.PkgMgrPane {
    private final @OnThread(value=Tag.Any) List<ObjectBenchListener> listenerList = new ArrayList<ObjectBenchListener>();
    private ObjectBenchPanel obp;
    private final @OnThread(value=Tag.Any) List<ObjectWrapper> objects = new ArrayList<ObjectWrapper>();
    private @OnThread(value=Tag.Any, requireSynchronized=true) ObjectWrapper selectedObject;
    private final PkgMgrFrame pkgMgrFrame;
    private @OnThread(value=Tag.FXPlatform) List<InvokerRecord> invokerRecords;

    @OnThread(value=Tag.FXPlatform)
    public ObjectBench(PkgMgrFrame pkgMgrFrame) {
        this.createComponent();
        this.pkgMgrFrame = pkgMgrFrame;
        this.updateAccessibleName();
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateAccessibleName() {
        int n;
        Object name = Config.getString("pkgmgr.objBench.title");
        name = (String)name + ": " + n + " " + Config.getString((n = this.getObjectCount()) == 1 ? "pkgmgr.objBench.suffix.singular" : "pkgmgr.objBench.suffix.plural");
    }

    @OnThread(value=Tag.Any)
    public void addObject(ObjectWrapper wrapper) {
        this.addObject(wrapper, Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public void addObject(ObjectWrapper wrapper, Optional<Point2D> animateFromScene) {
        Object newname = wrapper.getName();
        int count = 1;
        if (JavaNames.isJavaKeyword((String)newname)) {
            newname = "x" + (String)newname;
        }
        while (this.hasObject((String)newname)) {
            newname = wrapper.getName() + ++count;
        }
        wrapper.setName((String)newname);
        ObjectBench objectBench = this;
        synchronized (objectBench) {
            this.objects.add(wrapper);
        }
        JavaFXUtil.runNowOrLater(() -> {
            wrapper.setVisible(false);
            wrapper.setLayoutY(-1.0);
            this.obp.getChildren().add((Object)wrapper);
            wrapper.animateIn(animateFromScene);
            this.updateAccessibleName();
        });
    }

    @Override
    public String addObject(DebuggerObject object, GenTypeClass type, String name) {
        ObjectWrapper wrapper = ObjectWrapper.getWrapper(this.pkgMgrFrame, this, object, type, name);
        this.addObject(wrapper);
        return wrapper.getName();
    }

    @OnThread(value=Tag.Any)
    public synchronized List<ObjectWrapper> getObjects() {
        return Collections.unmodifiableList(new ArrayList<ObjectWrapper>(this.objects));
    }

    @OnThread(value=Tag.Any)
    public Iterator<ObjectWrapper> getValueIterator() {
        return this.getObjects().iterator();
    }

    @OnThread(value=Tag.Any)
    public synchronized ObjectWrapper getObject(String name) {
        for (ObjectWrapper wrapper : this.objects) {
            if (!wrapper.getName().equals(name)) continue;
            return wrapper;
        }
        return null;
    }

    @Override
    @OnThread(value=Tag.Any)
    public NamedValue getNamedValue(String name) {
        return this.getObject(name);
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean hasObject(String name) {
        return this.getObject(name) != null;
    }

    @OnThread(value=Tag.Any)
    public synchronized int getObjectCount() {
        return this.objects.size();
    }

    public synchronized void removeAllObjects(String scopeId) {
        this.setSelectedObject(null);
        for (ObjectWrapper wrapper : this.objects) {
            wrapper.prepareRemove();
            wrapper.getPackage().getDebugger().removeObject(scopeId, wrapper.getName());
        }
        this.objects.clear();
        JavaFXUtil.runNowOrLater(() -> this.obp.getChildren().clear());
        this.resetRecordingInteractions();
        this.updateAccessibleName();
    }

    public synchronized void removeObject(ObjectWrapper wrapper, String scopeId) {
        if (wrapper == this.selectedObject) {
            this.setSelectedObject(null);
        }
        DataCollector.removeObject(wrapper.getPackage(), wrapper.getName());
        wrapper.prepareRemove();
        wrapper.getPackage().getDebugger().removeObject(scopeId, wrapper.getName());
        this.objects.remove(wrapper);
        wrapper.animateOut(() -> this.obp.getChildren().remove((Object)wrapper));
        this.updateAccessibleName();
    }

    public void removeSelectedObject(String scopeId) {
        ObjectWrapper wrapper = this.getSelectedObject();
        if (wrapper != null) {
            this.removeObject(wrapper, scopeId);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void setSelectedObject(ObjectWrapper aWrapper) {
        if (this.selectedObject != null) {
            this.selectedObject.setSelected(false);
        }
        this.selectedObject = aWrapper;
        if (this.selectedObject != null && !this.selectedObject.isFocused()) {
            this.selectedObject.requestFocus();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void objectGotFocus(ObjectWrapper aWrapper) {
        if (this.selectedObject == aWrapper) {
            return;
        }
        if (this.selectedObject != null) {
            this.selectedObject.setSelected(false);
        }
        this.selectedObject = aWrapper;
        this.selectedObject.setSelected(true);
    }

    @OnThread(value=Tag.Any)
    public synchronized ObjectWrapper getSelectedObject() {
        return this.selectedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public void addObjectBenchListener(ObjectBenchListener l) {
        List<ObjectBenchListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Any)
    public void removeObjectBenchListener(ObjectBenchListener l) {
        List<ObjectBenchListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.FXPlatform)
    public void fireObjectSelectedEvent(ObjectWrapper wrapper) {
        List<ObjectBenchListener> list = this.listenerList;
        synchronized (list) {
            for (int i = this.listenerList.size() - 1; i >= 0; --i) {
                this.listenerList.get(i).objectEvent(new ObjectBenchEvent(this, 1, new NamedValue[]{wrapper}, null));
            }
        }
    }

    public synchronized void keyPressed(KeyEvent e) {
        int selectedObjectIndex = this.selectedObject == null ? -1 : this.objects.indexOf(this.selectedObject);
        switch (e.getCode()) {
            case LEFT: {
                selectedObjectIndex = selectedObjectIndex > 0 ? --selectedObjectIndex : 0;
                this.setSelectedObjectByIndex(selectedObjectIndex);
                break;
            }
            case RIGHT: {
                if (selectedObjectIndex >= this.objects.size() - 1) break;
                this.setSelectedObjectByIndex(selectedObjectIndex + 1);
                break;
            }
            case UP: {
                if ((selectedObjectIndex -= this.obp.getNumberOfColumns()) < 0) break;
                this.setSelectedObjectByIndex(selectedObjectIndex);
                break;
            }
            case DOWN: {
                if ((selectedObjectIndex += this.obp.getNumberOfColumns()) >= this.objects.size()) break;
                this.setSelectedObjectByIndex(selectedObjectIndex);
                break;
            }
            case ENTER: 
            case SPACE: 
            case CONTEXT_MENU: {
                this.showPopupMenu();
            }
        }
    }

    private synchronized void setSelectedObjectByIndex(int i) {
        this.objects.get(i).requestFocus();
    }

    private synchronized void showPopupMenu() {
        if (this.selectedObject != null) {
            this.selectedObject.showMenu();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void resetRecordingInteractions() {
        this.invokerRecords = new LinkedList<InvokerRecord>();
    }

    @OnThread(value=Tag.FXPlatform)
    public void addInteraction(InvokerRecord ir) {
        if (this.invokerRecords == null) {
            this.resetRecordingInteractions();
        }
        this.invokerRecords.add(ir);
    }

    @OnThread(value=Tag.FXPlatform)
    public String getFixtureDeclaration(String firstIndent) {
        StringBuffer sb = new StringBuffer();
        for (InvokerRecord ir : this.invokerRecords) {
            if (ir.toFixtureDeclaration(firstIndent) == null) continue;
            sb.append(ir.toFixtureDeclaration(firstIndent));
        }
        return sb.toString();
    }

    @OnThread(value=Tag.FXPlatform)
    public String getFixtureSetup(String secondIndent) {
        StringBuffer sb = new StringBuffer();
        for (InvokerRecord ir : this.invokerRecords) {
            if (ir.toFixtureSetup(secondIndent) == null) continue;
            sb.append(ir.toFixtureSetup(secondIndent));
        }
        return sb.toString();
    }

    @OnThread(value=Tag.FXPlatform)
    public String getTestMethod(String secondIndent) {
        StringBuffer sb = new StringBuffer();
        for (InvokerRecord ir : this.invokerRecords) {
            String testMethod = ir.toTestMethod(this.pkgMgrFrame, secondIndent);
            if (testMethod == null) continue;
            sb.append(testMethod);
        }
        return sb.toString();
    }

    @OnThread(value=Tag.FXPlatform)
    private synchronized void createComponent() {
        this.obp = new ObjectBenchPanel(this);
        JavaFXUtil.addStyleClass((Styleable)this, "object-bench");
        this.setContent((Node)this.obp);
        this.setFitToWidth(true);
        this.setMinViewportWidth(100.0);
        this.setMinViewportHeight(70.0);
        this.setMinWidth(135.0);
        this.setMinHeight(70.0);
        this.resetRecordingInteractions();
        this.setOnKeyPressed(this::keyPressed);
    }

    @OnThread(value=Tag.FX)
    public void requestFocus() {
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized boolean objectHasFocus() {
        return this.objects.stream().anyMatch(w -> w.isFocused());
    }

    public void highlightObject(DebuggerObject currentObject) {
        for (ObjectWrapper wrapper : this.objects) {
            wrapper.setHighlight(currentObject != null && Objects.equals(wrapper.obj, currentObject));
        }
    }

    @Override
    public Node getPkgMgrPaneNode() {
        return this;
    }

    @OnThread(value=Tag.FXPlatform)
    private final class ObjectBenchPanel
    extends TilePane {
        public ObjectBenchPanel(ObjectBench objectBench) {
            JavaFXUtil.addStyleClass((Styleable)this, "object-bench-panel");
        }

        public int getNumberOfRows() {
            int objects = this.getChildren().size();
            if (objects == 0) {
                return 1;
            }
            int objectsPerRow = (int)this.getWidth() / 100;
            return (objects + objectsPerRow - 1) / objectsPerRow;
        }

        public int getNumberOfColumns() {
            return (int)this.getWidth() / 100;
        }
    }
}

