/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.editor.flow.TrackedPosition;
import bluej.extensions2.editor.DocumentListener;
import bluej.parser.SourceLocation;
import java.io.Reader;
import java.util.List;

public interface Document {
    public void replaceText(int var1, int var2, String var3);

    public String getFullContent();

    public int getLength();

    public int getLineFromPosition(int var1);

    public int getColumnFromPosition(int var1);

    default public int getPosition(SourceLocation sourceLocation) {
        int lineStart = this.getLineStart(sourceLocation.getLine() - 1);
        int lineEnd = this.getLineEnd(sourceLocation.getLine() - 1);
        return Math.max(lineStart, Math.min(lineEnd, lineStart + sourceLocation.getColumn() - 1));
    }

    default public SourceLocation makeSourceLocation(int position) {
        return new SourceLocation(this.getLineFromPosition(position) + 1, this.getColumnFromPosition(position) + 1);
    }

    public int getLineStart(int var1);

    public int getLineEnd(int var1);

    public List<CharSequence> getLines();

    public TrackedPosition trackPosition(int var1, Bias var2);

    public void addListener(boolean var1, DocumentListener var2);

    public CharSequence getContent(int var1, int var2);

    default public int getLineCount() {
        return this.getLineFromPosition(this.getLength()) + 1;
    }

    default public int getLineLength(int lineIndex) {
        if (lineIndex == this.getLineCount() - 1) {
            return this.getLength() - this.getLineStart(lineIndex);
        }
        return this.getLineStart(lineIndex + 1) - this.getLineStart(lineIndex);
    }

    public Reader makeReader(int var1, int var2);

    public static enum Bias {
        FORWARD,
        NONE,
        BACK;

    }
}

