/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.editor.flow.ScopeColorsBorderPane;
import bluej.prefmgr.PrefMgr;
import bluej.utility.javafx.JavaFXUtil;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableIntegerValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.StringConverter;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ScopeHighlightingPrefDisplay {
    public static final int MIN = 0;
    public static final int MAX = 20;
    Slider slider = new Slider(0.0, 20.0, (double)PrefMgr.getScopeHighlightStrength().get());
    ScopeColorsBorderPane colorPanel;
    private ObjectExpression<Color> fillColorExpression;
    private ObjectExpression<Color> strokeColorExpression;

    public ScopeHighlightingPrefDisplay() {
        this.slider.setMajorTickUnit(20.0);
        this.slider.setShowTickLabels(true);
        this.slider.setShowTickMarks(true);
        this.slider.setLabelFormatter((StringConverter)new StringConverter<Double>(this){

            public String toString(Double d) {
                if (d == 0.0) {
                    return Config.getString("prefmgr.edit.highlightLighter");
                }
                if (d == 20.0) {
                    return Config.getString("prefmgr.edit.highlightDarker");
                }
                return "";
            }

            public Double fromString(String string) {
                return null;
            }
        });
        this.colorPanel = new ScopeColorsBorderPane();
        this.colorPanel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.colorPanel.scopeBackgroundColorProperty().get(), null, null)}));
        JavaFXUtil.addChangeListener(this.colorPanel.scopeBackgroundColorProperty(), bkColor -> this.colorPanel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)bkColor, null, null)})));
        JavaFXUtil.addStyleClass((Styleable)this.colorPanel, "prefmgr-scope-colour-container");
        VBox inner = JavaFXUtil.withStyleClass(new VBox(), "prefmgr-scope-colour-rectangles");
        inner.getChildren().addAll((Object[])new Node[]{this.makeRectangle((ObjectExpression<Color>)this.colorPanel.scopeClassColorProperty(), (ObjectExpression<Color>)this.colorPanel.scopeClassOuterColorProperty()), this.makeRectangle((ObjectExpression<Color>)this.colorPanel.scopeMethodColorProperty(), (ObjectExpression<Color>)this.colorPanel.scopeMethodOuterColorProperty()), this.makeRectangle((ObjectExpression<Color>)this.colorPanel.scopeIterationColorProperty(), (ObjectExpression<Color>)this.colorPanel.scopeIterationOuterColorProperty()), this.makeRectangle((ObjectExpression<Color>)this.colorPanel.scopeSelectionColorProperty(), (ObjectExpression<Color>)this.colorPanel.scopeSelectionOuterColorProperty())});
        this.colorPanel.setCenter((Node)inner);
    }

    private Rectangle makeRectangle(ObjectExpression<Color> body, ObjectExpression<Color> border) {
        Rectangle r = new Rectangle(100.0, 20.0);
        IntegerBinding sliderValue = Bindings.createIntegerBinding(this::getStrengthValue, (Observable[])new Observable[]{this.slider.valueProperty()});
        this.fillColorExpression = this.colorPanel.getReducedColor(body, (ObservableIntegerValue)sliderValue);
        this.strokeColorExpression = this.colorPanel.getReducedColor(border, (ObservableIntegerValue)sliderValue);
        r.fillProperty().bind(this.fillColorExpression);
        r.strokeProperty().bind(this.strokeColorExpression);
        return r;
    }

    protected Node getHighlightStrengthSlider() {
        return this.slider;
    }

    protected Node getColourPalette() {
        return this.colorPanel;
    }

    protected int getStrengthValue() {
        return (int)Math.round(this.slider.getValue());
    }
}

