/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2;

import bluej.debugger.DebuggerObject;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions2.BMethod;
import bluej.extensions2.BObject;
import bluej.extensions2.DirectInvoker;
import bluej.extensions2.Identifier;
import bluej.extensions2.InvocationArgumentException;
import bluej.extensions2.InvocationErrorException;
import bluej.extensions2.PackageNotFoundException;
import bluej.extensions2.ProjectNotOpenException;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.views.ConstructorView;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public class BConstructor {
    private Identifier parentId;
    private ConstructorView bluej_view;

    BConstructor(Identifier aParentId, ConstructorView i_view) {
        this.parentId = aParentId;
        this.bluej_view = i_view;
    }

    public boolean matches(Class<?>[] parameter) {
        Class<?>[] thisArgs = this.bluej_view.getParameters();
        if (thisArgs != null && thisArgs.length <= 0) {
            thisArgs = null;
        }
        if (parameter != null && parameter.length <= 0) {
            parameter = null;
        }
        if (thisArgs == null && parameter == null) {
            return true;
        }
        if (thisArgs == null || parameter == null) {
            return false;
        }
        if (thisArgs.length != parameter.length) {
            return false;
        }
        for (int index = 0; index < thisArgs.length; ++index) {
            if (thisArgs[index].isAssignableFrom(parameter[index])) continue;
            return false;
        }
        return true;
    }

    public Class<?>[] getParametersTypes() {
        return this.bluej_view.getParameters();
    }

    @OnThread(value=Tag.Worker)
    public BObject newInstance(Object[] initargs) throws ProjectNotOpenException, PackageNotFoundException, InvocationArgumentException, InvocationErrorException {
        CompletableFuture resultFuture = new CompletableFuture();
        Platform.runLater(() -> {
            try {
                PkgMgrFrame pkgFrame = this.parentId.getPackageFrame();
                DirectInvoker invoker = new DirectInvoker(pkgFrame);
                resultFuture.complete(new BMethod.Outcome.Success(pkgFrame, invoker, invoker.invokeConstructor(this.bluej_view, initargs)));
            }
            catch (ProjectNotOpenException e) {
                resultFuture.complete(new BMethod.Outcome.FailureProject(e));
            }
            catch (PackageNotFoundException e) {
                resultFuture.complete(new BMethod.Outcome.FailurePackage(e));
            }
            catch (InvocationArgumentException e) {
                resultFuture.complete(new BMethod.Outcome.FailureInvocationArgument(e));
            }
            catch (InvocationErrorException e) {
                resultFuture.complete(new BMethod.Outcome.FailureInvocationError(e));
            }
            catch (RuntimeException e) {
                resultFuture.complete(new BMethod.Outcome.FailureOther(e));
            }
        });
        try {
            BMethod.Outcome outcome = (BMethod.Outcome)resultFuture.get();
            if (outcome instanceof BMethod.Outcome.Success) {
                BMethod.Outcome.Success details = (BMethod.Outcome.Success)outcome;
                DebuggerObject result = details.result().waitForResult();
                if (result == null) {
                    return null;
                }
                String resultName = details.invoker().getResultName();
                PkgMgrFrame pmf = details.pkgMgrFrame();
                CompletableFuture resultObject = new CompletableFuture();
                Platform.runLater(() -> {
                    try {
                        resultObject.complete(new BObject(ObjectWrapper.getWrapper(pmf, pmf.getObjectBench(), result, result.getGenType(), resultName)));
                    }
                    catch (RuntimeException e) {
                        resultObject.complete(null);
                    }
                });
                return (BObject)resultObject.get();
            }
            if (outcome instanceof BMethod.Outcome.FailureProject) {
                BMethod.Outcome.FailureProject f = (BMethod.Outcome.FailureProject)outcome;
                throw f.e();
            }
            if (outcome instanceof BMethod.Outcome.FailurePackage) {
                BMethod.Outcome.FailurePackage f = (BMethod.Outcome.FailurePackage)outcome;
                throw f.e();
            }
            if (outcome instanceof BMethod.Outcome.FailureInvocationArgument) {
                BMethod.Outcome.FailureInvocationArgument f = (BMethod.Outcome.FailureInvocationArgument)outcome;
                throw f.e();
            }
            if (outcome instanceof BMethod.Outcome.FailureInvocationError) {
                BMethod.Outcome.FailureInvocationError f = (BMethod.Outcome.FailureInvocationError)outcome;
                throw f.e();
            }
            if (outcome instanceof BMethod.Outcome.FailureOther) {
                BMethod.Outcome.FailureOther f = (BMethod.Outcome.FailureOther)outcome;
                throw f.e();
            }
            throw new RuntimeException("Invocation failed impossibly, outcome was " + String.valueOf(outcome));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InvocationErrorException(e.getMessage());
        }
    }

    public int getModifiers() {
        return this.bluej_view.getModifiers();
    }

    public String toString() {
        if (this.bluej_view != null) {
            return "BConstructor: " + this.bluej_view.getLongDesc();
        }
        return "BConstructor: ";
    }
}

