/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2;

import bluej.debugger.DebuggerObject;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions2.BField;
import bluej.extensions2.BObject;
import bluej.extensions2.DirectInvoker;
import bluej.extensions2.Identifier;
import bluej.extensions2.InvocationArgumentException;
import bluej.extensions2.InvocationErrorException;
import bluej.extensions2.PackageNotFoundException;
import bluej.extensions2.ProjectNotOpenException;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.views.MethodView;
import bluej.views.View;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public class BMethod {
    private Identifier parentId;
    private MethodView bluej_view;

    BMethod(Identifier aParentId, MethodView i_bluej_view) {
        this.parentId = aParentId;
        this.bluej_view = i_bluej_view;
    }

    public boolean matches(String methodName, Class<?>[] parameter) {
        if (methodName == null) {
            return false;
        }
        if (!methodName.equals(this.bluej_view.getName())) {
            return false;
        }
        Class<?>[] thisArgs = this.bluej_view.getParameters();
        if (thisArgs != null && thisArgs.length <= 0) {
            thisArgs = null;
        }
        if (parameter != null && parameter.length <= 0) {
            parameter = null;
        }
        if (thisArgs == null && parameter == null) {
            return true;
        }
        if (thisArgs == null || parameter == null) {
            return false;
        }
        if (thisArgs.length != parameter.length) {
            return false;
        }
        for (int index = 0; index < thisArgs.length; ++index) {
            if (thisArgs[index].isAssignableFrom(parameter[index])) continue;
            return false;
        }
        return true;
    }

    public String getDeclaringClass() {
        return this.bluej_view.getClassName();
    }

    public Class<?>[] getParameterTypes() {
        return this.bluej_view.getParameters();
    }

    public String getName() {
        return this.bluej_view.getName();
    }

    public Class<?> getReturnType() {
        View aView = this.bluej_view.getReturnType();
        return aView.getViewClass();
    }

    public int getModifiers() {
        return this.bluej_view.getModifiers();
    }

    @OnThread(value=Tag.Worker)
    public Object invoke(BObject onThis, Object[] params) throws ProjectNotOpenException, PackageNotFoundException, InvocationArgumentException, InvocationErrorException {
        CompletableFuture resultFuture = new CompletableFuture();
        Platform.runLater(() -> {
            ObjectWrapper instanceWrapper = null;
            if (onThis != null) {
                instanceWrapper = onThis.getObjectWrapper();
            }
            try {
                PkgMgrFrame pkgFrame = this.parentId.getPackageFrame();
                DirectInvoker invoker = new DirectInvoker(pkgFrame);
                Outcome.Success success = new Outcome.Success(pkgFrame, invoker, invoker.invokeMethod(instanceWrapper, this.bluej_view, params));
                resultFuture.complete(success);
            }
            catch (ProjectNotOpenException e) {
                resultFuture.complete(new Outcome.FailureProject(e));
            }
            catch (PackageNotFoundException e) {
                resultFuture.complete(new Outcome.FailurePackage(e));
            }
            catch (InvocationArgumentException e) {
                resultFuture.complete(new Outcome.FailureInvocationArgument(e));
            }
            catch (InvocationErrorException e) {
                resultFuture.complete(new Outcome.FailureInvocationError(e));
            }
            catch (RuntimeException e) {
                resultFuture.complete(new Outcome.FailureOther(e));
            }
        });
        try {
            Outcome outcome = (Outcome)resultFuture.get();
            if (outcome instanceof Outcome.Success) {
                Outcome.Success details = (Outcome.Success)outcome;
                DebuggerObject result = details.result.waitForResult();
                if (result == null || result.isNullObject()) {
                    return null;
                }
                String resultName = details.invoker.getResultName();
                ObjectReference objRef = result.getObjectReference();
                ReferenceType type = objRef.referenceType();
                Field thisField = type.fieldByName("result");
                if (thisField == null) {
                    return null;
                }
                CompletableFuture resultObject = new CompletableFuture();
                Platform.runLater(() -> {
                    try {
                        resultObject.complete(Optional.ofNullable(BField.doGetVal(details.pkgMgrFrame, resultName, objRef.getValue(thisField))));
                    }
                    catch (RuntimeException e) {
                        resultObject.complete(Optional.empty());
                    }
                });
                return ((Optional)resultObject.get()).orElse(null);
            }
            if (outcome instanceof Outcome.FailureProject) {
                Outcome.FailureProject f = (Outcome.FailureProject)outcome;
                throw f.e;
            }
            if (outcome instanceof Outcome.FailurePackage) {
                Outcome.FailurePackage f = (Outcome.FailurePackage)outcome;
                throw f.e;
            }
            if (outcome instanceof Outcome.FailureInvocationArgument) {
                Outcome.FailureInvocationArgument f = (Outcome.FailureInvocationArgument)outcome;
                throw f.e;
            }
            if (outcome instanceof Outcome.FailureInvocationError) {
                Outcome.FailureInvocationError f = (Outcome.FailureInvocationError)outcome;
                throw f.e;
            }
            if (outcome instanceof Outcome.FailureOther) {
                Outcome.FailureOther f = (Outcome.FailureOther)outcome;
                throw f.e;
            }
            throw new RuntimeException("Invocation failed impossibly, outcome was " + String.valueOf(outcome));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InvocationErrorException(e.getMessage());
        }
    }

    public String toString() {
        Class<?>[] signature = this.getParameterTypes();
        Object sig = "";
        for (int i = 0; i < signature.length; ++i) {
            sig = (String)sig + signature[i].getName() + (i == signature.length - 1 ? "" : ", ");
        }
        Object mod = Modifier.toString(this.getModifiers());
        if (((String)mod).length() > 0) {
            mod = (String)mod + " ";
        }
        return (String)mod + String.valueOf(this.getReturnType()) + " " + this.getName() + "(" + (String)sig + ")";
    }

    @OnThread(value=Tag.Any)
    static sealed interface Outcome {

        @OnThread(value=Tag.Any)
        public record FailureOther(RuntimeException e) implements Outcome
        {
        }

        @OnThread(value=Tag.Any)
        public record FailureInvocationError(InvocationErrorException e) implements Outcome
        {
        }

        @OnThread(value=Tag.Any)
        public record FailureInvocationArgument(InvocationArgumentException e) implements Outcome
        {
        }

        @OnThread(value=Tag.Any)
        public record FailurePackage(PackageNotFoundException e) implements Outcome
        {
        }

        @OnThread(value=Tag.Any)
        public record FailureProject(ProjectNotOpenException e) implements Outcome
        {
        }

        @OnThread(value=Tag.Any)
        public record Success(PkgMgrFrame pkgMgrFrame, DirectInvoker invoker, DirectInvoker.OffThreadWaiter result) implements Outcome
        {
        }
    }
}

