/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2.event;

import bluej.extensions2.event.ExtensionEvent;
import java.io.File;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class CompileEvent
implements ExtensionEvent {
    private final boolean isUserGeneratedCompilation;
    private EventType eventType;
    private File[] fileNames;
    private int errorLineNumber;
    private int errorColumn;
    private int endErrorLine;
    private int endErrorColumn;
    private String errorMessage;

    public CompileEvent(EventType eventType, File[] aFileNames) {
        this.eventType = eventType;
        this.fileNames = aFileNames;
        this.isUserGeneratedCompilation = true;
    }

    public CompileEvent(EventType eventType, boolean isUserGeneratedCompilation, File[] aFileNames) {
        this.eventType = eventType;
        this.isUserGeneratedCompilation = isUserGeneratedCompilation;
        this.fileNames = aFileNames;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public File[] getFiles() {
        return this.fileNames;
    }

    public void setErrorLineNumber(int aLineNumber) {
        this.errorLineNumber = aLineNumber;
    }

    public void setErrorPosition(int[] errorPosition) {
        this.errorLineNumber = errorPosition[0];
        this.errorColumn = errorPosition[1];
        this.endErrorLine = errorPosition[2];
        this.endErrorColumn = errorPosition[3];
    }

    public int getErrorLineNumber() {
        return this.errorLineNumber;
    }

    public int[] getErrorPosition() {
        int[] r = new int[]{this.errorLineNumber, this.errorColumn, this.endErrorLine, this.endErrorColumn};
        return r;
    }

    public void setErrorMessage(String anErrorMessage) {
        this.errorMessage = anErrorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isUserGeneratedCompilation() {
        return this.isUserGeneratedCompilation;
    }

    public String toString() {
        StringBuffer aRisul = new StringBuffer(500);
        aRisul.append("CompileEvent:");
        switch (this.eventType.ordinal()) {
            case 0: {
                aRisul.append(" COMPILE_START_EVENT");
                break;
            }
            case 1: {
                aRisul.append(" COMPILE_WARNING_EVENT");
                break;
            }
            case 2: {
                aRisul.append(" COMPILE_ERROR_EVENT");
                break;
            }
            case 3: {
                aRisul.append(" COMPILE_DONE_EVENT");
                break;
            }
            case 4: {
                aRisul.append(" COMPILE_FAILED_EVENT");
            }
        }
        aRisul.append(" getFiles().length=");
        aRisul.append(this.fileNames.length);
        for (int i = 0; i < this.fileNames.length; ++i) {
            aRisul.append(" getFiles()[" + i + "]=");
            aRisul.append(this.fileNames[i]);
        }
        if (this.eventType == EventType.COMPILE_WARNING_EVENT || this.eventType == EventType.COMPILE_ERROR_EVENT) {
            aRisul.append(" errorLineNumber=" + this.errorLineNumber);
            aRisul.append(" errorMessage=" + this.errorMessage);
        }
        return aRisul.toString();
    }

    public static enum EventType {
        COMPILE_START_EVENT,
        COMPILE_WARNING_EVENT,
        COMPILE_ERROR_EVENT,
        COMPILE_DONE_EVENT,
        COMPILE_FAILED_EVENT;

    }
}

