/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.utility.Debug;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CodeFileFilter
implements FileFilter,
FilenameFilter {
    private boolean includeDirectories;
    private List<Pattern> patterns = null;
    private FileFilter parentFilter = null;
    private File projectDir;

    public CodeFileFilter(List<String> ignore, File projectDir, FileFilter parent) {
        this.projectDir = projectDir;
        this.patterns = this.makePatterns(ignore);
        this.parentFilter = parent;
    }

    public CodeFileFilter(List<String> ignore, boolean includeDirectories, File projectDir, FileFilter parent) {
        this(ignore, projectDir, parent);
        this.includeDirectories = includeDirectories;
    }

    private List<Pattern> makePatterns(List<String> ignore) {
        LinkedList<Pattern> patterns = new LinkedList<Pattern>();
        for (String patternString : ignore) {
            try {
                patterns.add(Pattern.compile(patternString));
            }
            catch (PatternSyntaxException pse) {
                Debug.message("Couldn't parse ignore pattern: " + patternString);
            }
        }
        return patterns;
    }

    private boolean matchesPatterns(String input) {
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(input);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File dir, String name) {
        File file = new File(dir, name);
        if (!this.includeDirectories && file.isDirectory()) {
            return false;
        }
        File tdir = file;
        String tname = name;
        while (!tdir.equals(this.projectDir)) {
            tname = tdir.getName();
            if ((tdir = tdir.getParentFile()) != null) continue;
            return false;
        }
        if (tname.equals("doc")) {
            return false;
        }
        if (name.equals("CVS") || dir.getName().equals("CVS")) {
            return false;
        }
        if (name.equals("CVSROOT") || dir.getName().equalsIgnoreCase("CVSROOT")) {
            return false;
        }
        if (name.equals("bluej.pkh")) {
            return false;
        }
        if (name.equals("team.defs")) {
            return false;
        }
        if (name.equals(".DS_Store")) {
            return false;
        }
        if (this.getFileType(name).equals("ctxt")) {
            return false;
        }
        if (name.charAt(name.length() - 1) == '~') {
            return false;
        }
        if (name.charAt(name.length() - 1) == '#') {
            return false;
        }
        if (name.endsWith("#backup")) {
            return false;
        }
        if (name.startsWith(".#")) {
            return false;
        }
        if (this.matchesPatterns(name)) {
            return false;
        }
        if (this.parentFilter != null) {
            return this.parentFilter.accept(new File(dir, name));
        }
        return true;
    }

    @Override
    public boolean accept(File pathname) {
        return this.accept(pathname.getParentFile(), pathname.getName());
    }

    private String getFileType(String filename) {
        int lastDotIndex = filename.lastIndexOf(46);
        if (lastDotIndex > -1 && lastDotIndex < filename.length()) {
            return filename.substring(lastDotIndex + 1);
        }
        return "";
    }
}

