/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.TeamworkCommandUnsupportedSetting;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.UnsupportedSettingException;
import bluej.groupwork.git.GitRepository;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class GitProvider
implements TeamworkProvider {
    private String gitUrlString;

    @Override
    public String getProviderName() {
        return "Git";
    }

    @Override
    public String[] getProtocols() {
        return new String[]{"https", "http", "ssh", "git"};
    }

    @Override
    public String getProtocolKey(int protocol) {
        return this.getProtocols()[protocol];
    }

    @Override
    public String getProtocolLabel(String protocolKey) {
        return protocolKey;
    }

    @Override
    public TeamworkCommandResult checkConnection(TeamSettings settings) {
        try {
            this.gitUrlString = this.makeGitUrl(settings);
            LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository();
            UsernamePasswordCredentialsProvider cp = new UsernamePasswordCredentialsProvider(settings.getUserName(), settings.getPassword());
            lsRemoteCommand.setRemote(this.gitUrlString);
            lsRemoteCommand.setCredentialsProvider((CredentialsProvider)cp);
            lsRemoteCommand.setTags(false);
            lsRemoteCommand.setHeads(false);
            lsRemoteCommand.call();
        }
        catch (GitAPIException ex) {
            if (ex instanceof TransportException) {
                TeamworkCommandResult diagnosis = GitProvider.connectionDiagnosis(this.gitUrlString);
                if (!diagnosis.isError()) {
                    if (ex.getLocalizedMessage().contains("access denied or repository not exported")) {
                        return new TeamworkCommandError(DialogManager.getMessage("team-denied-invalidUser", new String[0]), DialogManager.getMessage("team-denied-invalidUser", new String[0]));
                    }
                    if (ex.getLocalizedMessage().contains("Auth fail")) {
                        return new TeamworkCommandError(DialogManager.getMessage("team-denied-invalidUser", new String[0]), DialogManager.getMessage("team-denied-invalidUser", new String[0]));
                    }
                    if (ex.getLocalizedMessage().contains("does not appear to be a git repository")) {
                        String message = DialogManager.getMessage("team-noRepository-uri", ex.getLocalizedMessage());
                        return new TeamworkCommandError(message, message);
                    }
                    if (settings.getProtocol().contains("file") || settings.getProtocol().contains("http") || settings.getProtocol().contains("git")) {
                        String message = DialogManager.getMessage("team-noRepository-uri", ex.getLocalizedMessage());
                        return new TeamworkCommandError(message, message);
                    }
                }
                return diagnosis;
            }
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
        catch (UnsupportedSettingException ex) {
            return new TeamworkCommandUnsupportedSetting(ex.getLocalizedMessage());
        }
        return new TeamworkCommandResult();
    }

    @Override
    public Repository getRepository(File projectDir, TeamSettings settings) throws UnsupportedSettingException {
        try {
            return new GitRepository(projectDir, settings.getProtocol(), this.makeGitUrl(settings), settings.getBranch(), settings.getUserName(), settings.getPassword(), settings.getYourName(), settings.getYourEmail());
        }
        catch (UnsupportedSettingException e) {
            Debug.reportError("Unsupported Git Repository Settings " + e.getMessage());
            throw new UnsupportedSettingException(e.getLocalizedMessage());
        }
    }

    @OnThread(value=Tag.Any)
    protected String makeGitUrl(TeamSettings settings) throws UnsupportedSettingException {
        String protocol = settings.getProtocol();
        if (protocol == null || !Arrays.asList(this.getProtocols()).contains(protocol)) {
            throw new UnsupportedSettingException(Config.getString("team.error.unknownProtocol"));
        }
        String server = settings.getServer();
        if (server == null || server.isEmpty()) {
            throw new UnsupportedSettingException(Config.getString("team.error.cannotParseServer"));
        }
        int port = settings.getPort();
        String prefix = settings.getPrefix();
        if (prefix == null || prefix.isEmpty()) {
            throw new UnsupportedSettingException(Config.getString("team.error.cannotParsePath"));
        }
        String gitUrl = protocol + "://";
        if (protocol.contains("ssh")) {
            gitUrl = gitUrl + settings.getUserName() + "@";
        }
        if (server != null) {
            gitUrl = gitUrl + server;
        }
        if (port > 0) {
            gitUrl = gitUrl + ":" + port;
        }
        if (prefix.length() != 0 && !prefix.startsWith("/")) {
            gitUrl = gitUrl + "/";
        }
        gitUrl = gitUrl + prefix;
        return gitUrl;
    }

    public static TeamworkCommandResult connectionDiagnosis(String gitUrlString) {
        try {
            URI uri = new URI(gitUrlString);
            if (uri.getScheme().equals("file")) {
                return new TeamworkCommandResult();
            }
            int port = uri.getPort();
            if (port <= 0) {
                switch (uri.getScheme().toLowerCase()) {
                    case "http": {
                        port = 80;
                        break;
                    }
                    case "https": {
                        port = 443;
                        break;
                    }
                    case "ssh": {
                        port = 22;
                        break;
                    }
                    case "git": {
                        port = 9418;
                    }
                }
            }
            Socket s = new Socket(uri.getHost(), port);
            s.close();
            return new TeamworkCommandResult();
        }
        catch (IOException ex) {
            if (ex instanceof UnknownHostException) {
                return new TeamworkCommandError(DialogManager.getMessage("team-cant-connect", new String[0]), DialogManager.getMessage("team-cant-connect", new String[0]));
            }
            if (ex instanceof ConnectException) {
                return new TeamworkCommandError(DialogManager.getMessage("team-wrong-protocol", new String[0]), DialogManager.getMessage("team-wrong-protocol", new String[0]));
            }
            Debug.reportError(ex.getMessage());
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
        catch (URISyntaxException ex) {
            Debug.reportError(ex.getMessage());
            return new TeamworkCommandError(DialogManager.getMessage("team-malformed-uri", new String[0]), DialogManager.getMessage("team-malformed-uri", new String[0]));
        }
    }

    @Override
    public boolean needsEmail() {
        return true;
    }

    @Override
    public boolean needsName() {
        return true;
    }

    @Override
    public String getYourNameFromRepo(File projectPath) {
        String result = null;
        try (Git repo = Git.open((File)projectPath);){
            StoredConfig repoConfig = repo.getRepository().getConfig();
            result = repoConfig.getString("user", null, "name");
        }
        catch (IOException ex) {
            Debug.reportError("Git: Could not get user name from repository", ex);
        }
        return result;
    }

    @Override
    public String getYourEmailFromRepo(File projectPath) {
        String result = null;
        try (Git repo = Git.open((File)projectPath);){
            StoredConfig repoConfig = repo.getRepository().getConfig();
            result = repoConfig.getString("user", null, "email");
        }
        catch (IOException ex) {
            Debug.reportError("Git: Could not get user email from repository", ex);
        }
        return result;
    }
}

