/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.ui.UpdateStatus;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.Project;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ResourceDescriptor {
    public static String getResource(Project project, TeamStatusInfo info, boolean annotate) {
        boolean isPkgFile = BlueJPackageFile.isPackageFileName(info.getFile().getName());
        Object status = ResourceDescriptor.getStatusName(project, info, isPkgFile);
        if (annotate) {
            TeamStatusInfo.Status infoStatus = info.getStatus();
            switch (infoStatus) {
                case DELETED: {
                    status = (String)status + " (" + Config.getString("team.status.delete") + ")";
                    break;
                }
                case NEEDS_ADD: {
                    status = (String)status + " (" + Config.getString("team.status.add") + ")";
                    break;
                }
                case NEEDS_CHECKOUT: {
                    status = (String)status + " (" + Config.getString("team.status.new") + ")";
                    break;
                }
                case REMOVED: 
                case CONFLICT_LMRD: {
                    status = (String)status + " (" + Config.getString("team.status.removed") + ")";
                    break;
                }
                case NEEDS_MERGE: {
                    if (isPkgFile) break;
                    status = (String)status + " (" + Config.getString("team.status.needsmerge") + ")";
                    break;
                }
            }
            if (!(info.getRemoteStatus() != TeamStatusInfo.Status.NEEDS_CHECKOUT && info.getRemoteStatus() != TeamStatusInfo.Status.DELETED || isPkgFile)) {
                status = (String)status + "(" + Config.getString("team.status.needsupdate") + ")";
            }
        }
        return status;
    }

    public static String getDCVSResource(Project project, TeamStatusInfo info, boolean annotate, boolean remote) {
        boolean isPkgFile = BlueJPackageFile.isPackageFileName(info.getFile().getName());
        Object status = ResourceDescriptor.getStatusName(project, info, isPkgFile);
        if (annotate) {
            TeamStatusInfo.Status infoStatus = info.getStatus(!remote);
            switch (infoStatus) {
                case DELETED: 
                case NEEDS_ADD: 
                case NEEDS_CHECKOUT: 
                case REMOVED: 
                case CONFLICT_LMRD: 
                case NEEDS_UPDATE: 
                case NEEDS_COMMIT: {
                    status = (String)status + " - " + infoStatus.getDCVSStatusString(remote);
                    break;
                }
                case NEEDS_MERGE: {
                    if (isPkgFile) break;
                    status = (String)status + " - " + infoStatus.getDCVSStatusString(remote);
                    break;
                }
            }
        }
        return status;
    }

    public static String getDCVSResource(Project project, UpdateStatus updateStatus, boolean annotate, boolean remote) {
        if (updateStatus.infoStatus != null) {
            return ResourceDescriptor.getDCVSResource(project, updateStatus.infoStatus, annotate, remote);
        }
        return updateStatus.stringStatus;
    }

    private static String getStatusName(Project project, TeamStatusInfo info, boolean isPkgFile) {
        Object packageName = project.getPackageForFile(info.getFile());
        Object object = packageName = packageName == null ? "" : packageName;
        if (!((String)packageName).isEmpty()) {
            packageName = "[" + (String)packageName + "] ";
        }
        String status = isPkgFile ? (String)packageName + Config.getString("team.commit.layout") : (String)packageName + info.getFile().getName();
        return status;
    }
}

