/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamViewFilter;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.UpdateFilter;
import bluej.groupwork.actions.UpdateAction;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.FileRendererCell;
import bluej.groupwork.ui.UpdateStatus;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.Project;
import bluej.utility.DialogManager;
import bluej.utility.FXWorker;
import bluej.utility.Utility;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class UpdateFilesFrame
extends FXCustomizedDialog<Void> {
    private CheckBox includeLayoutCheckbox;
    private ActivityIndicator progressBar;
    private UpdateAction updateAction;
    private Button updateButton;
    private UpdateWorker updateWorker;
    private Project project;
    private Repository repository;
    private ObservableList<UpdateStatus> updateListModel;
    private Set<TeamStatusInfo> changedLayoutFiles = new HashSet<TeamStatusInfo>();
    private Set<File> forcedLayoutFiles = new HashSet<File>();
    private static UpdateStatus noFilesToUpdate = new UpdateStatus(Config.getString("team.noupdatefiles"));
    private static UpdateStatus needUpdate = new UpdateStatus(Config.getString("team.pullNeeded"));
    private boolean includeLayout = true;
    private boolean pullWithNoChanges = false;

    public UpdateFilesFrame(Project project) {
        super(null, "team.update.title", "team-update-files");
        this.project = project;
        this.updateAction.useButton(project, (ButtonBase)this.updateButton);
        this.buildUI();
    }

    @Override
    protected Node wrapButtonBar(Node original) {
        this.updateAction = new UpdateAction(this);
        this.updateButton = new Button();
        this.updateButton.requestFocus();
        this.progressBar = new ActivityIndicator();
        this.progressBar.setRunning(false);
        HBox updateButtonPane = new HBox();
        JavaFXUtil.addStyleClass((Styleable)updateButtonPane, "button-hbox");
        updateButtonPane.getChildren().addAll((Object[])new Node[]{this.progressBar, this.updateButton, original});
        return updateButtonPane;
    }

    private void buildUI() {
        VBox mainPane = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPane, "main-pane");
        this.updateListModel = FXCollections.observableArrayList();
        Label updateFilesLabel = new Label(Config.getString("team.update.files"));
        ListView updateFiles = new ListView(this.updateListModel);
        updateFiles.setCellFactory(param -> new FileRendererCell(this.project));
        updateFiles.setEditable(false);
        ScrollPane updateFileScrollPane = new ScrollPane((Node)updateFiles);
        updateFileScrollPane.setFitToWidth(true);
        updateFileScrollPane.setFitToHeight(true);
        this.includeLayoutCheckbox = new CheckBox(Config.getString("team.update.includelayout"));
        this.includeLayoutCheckbox.setDisable(true);
        this.includeLayoutCheckbox.setOnAction(event -> {
            CheckBox layoutCheck = (CheckBox)event.getSource();
            this.includeLayout = layoutCheck.isSelected();
            this.resetForcedFiles();
            if (this.includeLayout) {
                this.addModifiedLayouts();
            } else {
                this.removeModifiedLayouts();
            }
        });
        mainPane.getChildren().addAll((Object[])new Node[]{updateFilesLabel, updateFileScrollPane, this.includeLayoutCheckbox});
        this.getDialogPane().setContent((Node)mainPane);
        this.prepareButtonPane();
    }

    private void prepareButtonPane() {
        this.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        this.setOnCloseRequest(event -> {
            if (this.updateWorker != null) {
                this.updateWorker.abort();
            }
            if (this.updateAction != null) {
                this.updateAction.cancel();
            }
            this.close();
        });
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.show();
            this.updateAction.setEnabled(false);
            this.includeLayoutCheckbox.setSelected(false);
            this.includeLayoutCheckbox.setDisable(true);
            this.changedLayoutFiles.clear();
            this.forcedLayoutFiles.clear();
            this.updateListModel.clear();
            this.repository = this.project.getRepository();
            if (this.repository != null) {
                block6: {
                    try {
                        this.project.saveAllEditors();
                        this.project.saveAll();
                    }
                    catch (IOException ioe) {
                        String msg = DialogManager.getMessage("team-error-saving-project", new String[0]);
                        if (msg == null) break block6;
                        String msgFinal = msg = Utility.mergeStrings(msg, ioe.getLocalizedMessage());
                        DialogManager.showErrorTextFX(this.asWindow(), msgFinal);
                    }
                }
                this.startProgress();
                this.updateWorker = new UpdateWorker();
                this.updateWorker.start();
            } else {
                this.hide();
            }
        } else {
            this.hide();
        }
    }

    private void removeModifiedLayouts() {
        this.updateListModel.removeIf(updateStatus -> this.changedLayoutFiles.stream().anyMatch(statusInfo -> updateStatus.infoStatus != null && statusInfo.getFile().equals(updateStatus.infoStatus.getFile())));
        if (this.updateListModel.isEmpty()) {
            if (this.pullWithNoChanges) {
                this.updateListModel.add((Object)needUpdate);
            } else {
                this.updateListModel.add((Object)noFilesToUpdate);
                this.updateAction.setEnabled(false);
            }
        }
    }

    private void addModifiedLayouts() {
        this.updateListModel.remove((Object)noFilesToUpdate);
        this.updateListModel.remove((Object)needUpdate);
        this.updateAction.setEnabled(true);
        for (TeamStatusInfo statusInfo : this.changedLayoutFiles) {
            this.updateListModel.add((Object)new UpdateStatus(statusInfo));
        }
    }

    public void startProgress() {
        this.progressBar.setRunning(true);
    }

    public void stopProgress() {
        this.progressBar.setRunning(false);
    }

    public void disableLayoutCheck() {
        this.includeLayoutCheckbox.setDisable(true);
    }

    private void resetForcedFiles() {
        HashSet<File> forcedFiles = new HashSet<File>(this.forcedLayoutFiles);
        if (this.includeLayout) {
            forcedFiles.addAll(this.changedLayoutFiles.stream().map(TeamStatusInfo::getFile).collect(Collectors.toSet()));
        }
        this.updateAction.setFilesToForceUpdate(forcedFiles);
    }

    class UpdateWorker
    extends FXWorker
    implements StatusListener {
        List<TeamStatusInfo> response = new ArrayList<TeamStatusInfo>();
        TeamworkCommand command;
        TeamworkCommandResult result;
        private boolean aborted;
        private StatusHandle statusHandle;

        @OnThread(value=Tag.FXPlatform)
        public UpdateWorker() {
            FileFilter filter = UpdateFilesFrame.this.project.getTeamSettingsController().getFileFilter(false);
            this.command = UpdateFilesFrame.this.repository.getStatus(this, filter, true);
        }

        @Override
        @OnThread(value=Tag.Any)
        public void gotStatus(TeamStatusInfo info) {
            this.response.add(info);
        }

        @Override
        @OnThread(value=Tag.Worker)
        public void statusComplete(StatusHandle statusHandle) {
            UpdateFilesFrame.this.pullWithNoChanges = statusHandle.pullNeeded();
            this.statusHandle = statusHandle;
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            this.result = this.command.getResult();
            return this.response;
        }

        @Override
        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void finished() {
            UpdateFilesFrame.this.stopProgress();
            if (!this.aborted) {
                if (this.result.isError()) {
                    UpdateFilesFrame.this.dialogThenHide(() -> TeamUtils.handleServerResponseFX(this.result, UpdateFilesFrame.this.asWindow()));
                } else {
                    HashSet<File> filesToUpdate = new HashSet<File>();
                    HashSet<File> modifiedLayoutFiles = new HashSet<File>();
                    List<TeamStatusInfo> info = this.response;
                    this.getUpdateFileSet(info, filesToUpdate, modifiedLayoutFiles);
                    HashSet<File> updateFiles = new HashSet<File>();
                    for (File file2 : filesToUpdate) {
                        if (filesToUpdate.contains(file2.getParentFile())) continue;
                        updateFiles.add(file2);
                    }
                    UpdateFilesFrame.this.forcedLayoutFiles.removeIf(file -> filesToUpdate.contains(file.getParentFile()));
                    UpdateFilesFrame.this.updateAction.setStatusHandle(this.statusHandle);
                    UpdateFilesFrame.this.updateAction.setFilesToUpdate(updateFiles);
                    UpdateFilesFrame.this.resetForcedFiles();
                    if (UpdateFilesFrame.this.includeLayout && !UpdateFilesFrame.this.changedLayoutFiles.isEmpty()) {
                        for (TeamStatusInfo statusInfo : UpdateFilesFrame.this.changedLayoutFiles) {
                            UpdateFilesFrame.this.updateListModel.add((Object)new UpdateStatus(statusInfo));
                        }
                    }
                    if (UpdateFilesFrame.this.updateListModel.isEmpty() && !UpdateFilesFrame.this.pullWithNoChanges) {
                        UpdateFilesFrame.this.updateListModel.add((Object)noFilesToUpdate);
                    } else {
                        if (UpdateFilesFrame.this.pullWithNoChanges && UpdateFilesFrame.this.updateListModel.isEmpty()) {
                            UpdateFilesFrame.this.updateListModel.add((Object)needUpdate);
                        }
                        UpdateFilesFrame.this.updateAction.setEnabled(true);
                    }
                }
            }
        }

        private void getUpdateFileSet(List<TeamStatusInfo> info, Set<File> filesToUpdate, Set<File> modifiedLayoutFiles) {
            this.getUpdateFileSetDist(info, filesToUpdate, modifiedLayoutFiles);
            if (!UpdateFilesFrame.this.changedLayoutFiles.isEmpty()) {
                UpdateFilesFrame.this.includeLayoutCheckbox.setDisable(false);
                UpdateFilesFrame.this.includeLayoutCheckbox.setSelected(UpdateFilesFrame.this.includeLayout);
            }
        }

        private void getUpdateFileSetDist(List<TeamStatusInfo> info, Set<File> filesToUpdate, Set<File> modifiedLayoutFiles) {
            UpdateFilter filter = new UpdateFilter();
            TeamViewFilter viewFilter = new TeamViewFilter();
            for (TeamStatusInfo statusInfo : info) {
                TeamStatusInfo.Status status = statusInfo.getStatus(false);
                if (!filter.acceptDist(status)) continue;
                if (!BlueJPackageFile.isPackageFileName(statusInfo.getFile().getName())) {
                    UpdateFilesFrame.this.updateListModel.add((Object)new UpdateStatus(statusInfo));
                    filesToUpdate.add(statusInfo.getFile());
                    continue;
                }
                if (!viewFilter.accept(statusInfo)) continue;
                if (status != TeamStatusInfo.Status.NEEDS_UPDATE && status != TeamStatusInfo.Status.NEEDS_MERGE) {
                    UpdateFilesFrame.this.updateListModel.add((Object)new UpdateStatus(statusInfo));
                    UpdateFilesFrame.this.forcedLayoutFiles.add(statusInfo.getFile());
                    continue;
                }
                modifiedLayoutFiles.add(statusInfo.getFile());
                UpdateFilesFrame.this.changedLayoutFiles.add(statusInfo);
            }
        }
    }
}

