/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.parser.AssistContent;
import bluej.pkgmgr.target.role.Kind;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.utility.JavaUtils;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Label;
import javafx.scene.text.Font;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public final class AssistContentThreadSafe {
    private final String name;
    private final List<AssistContent.ParamInfo> params;
    private final String type;
    private final AssistContent.Access access;
    private final String declaringClass;
    private final AssistContent.CompletionKind kind;
    private final Kind typeKind;
    private final String javadoc;
    private final List<String> superTypes;
    private final String packageName;

    @OnThread(value=Tag.FXPlatform)
    public AssistContentThreadSafe(AssistContent copyFrom) {
        this.name = copyFrom.getName();
        this.params = copyFrom.getParams();
        this.type = copyFrom.getType();
        this.access = copyFrom.getAccessPermission();
        this.declaringClass = copyFrom.getDeclaringClass();
        this.kind = copyFrom.getKind();
        this.javadoc = copyFrom.getJavadoc();
        this.superTypes = copyFrom.getSuperTypes();
        this.typeKind = copyFrom.getTypeKind();
        this.packageName = copyFrom.getPackage();
    }

    @OnThread(value=Tag.FXPlatform)
    public static AssistContentThreadSafe copy(AssistContent copyFrom) {
        return new AssistContentThreadSafe(copyFrom);
    }

    @OnThread(value=Tag.Any)
    public AssistContentThreadSafe(AssistContent.Access access, String declaringClass, String javadoc, AssistContent.CompletionKind kind, String name, String packageName, List<AssistContent.ParamInfo> params, List<String> superTypes, String type, Kind typeKind) {
        this.access = access;
        this.declaringClass = declaringClass;
        this.javadoc = javadoc;
        this.kind = kind;
        this.name = name;
        this.packageName = packageName;
        this.params = params;
        this.superTypes = superTypes;
        this.type = type;
        this.typeKind = typeKind;
    }

    public String getName() {
        return this.name;
    }

    public List<AssistContent.ParamInfo> getParams() {
        return this.params;
    }

    public String getType() {
        return this.type;
    }

    public AssistContent.Access getAccessPermission() {
        return this.access;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public AssistContent.CompletionKind getKind() {
        return this.kind;
    }

    public String getJavadoc() {
        return this.javadoc;
    }

    public String getPackage() {
        return this.packageName;
    }

    public static Comparator<AssistContentThreadSafe> getComparator(String targetType) {
        return (a, b) -> {
            int compareTypes;
            if (targetType != null && (compareTypes = Integer.compare(targetType.equals(a.getType()) ? 0 : 1, targetType.equals(b.getType()) ? 0 : 1)) != 0) {
                return compareTypes;
            }
            int compareNames = a.getName().toLowerCase().compareTo(b.getName().toLowerCase());
            if (compareNames != 0) {
                return compareNames;
            }
            int aParams = a.getParams() == null ? -1 : a.getParams().size();
            int bParams = b.getParams() == null ? -1 : b.getParams().size();
            return Integer.compare(aParams, bParams);
        };
    }

    public List<String> getSuperTypes() {
        return Collections.unmodifiableList(this.superTypes);
    }

    public Kind getTypeKind() {
        return this.typeKind;
    }

    @OnThread(value=Tag.FXPlatform)
    public String getDocHTML() {
        String header = (this.getType() == null ? "" : Utility.escapeAngleBrackets(this.getType())) + " <b>" + this.getName() + "</b>";
        if (this.getParams() != null) {
            header = header + "(" + this.getParams().stream().map(p -> {
                String type = Utility.escapeAngleBrackets(p.getUnqualifiedType());
                if (p.getFormalName() != null) {
                    return type + "&nbsp;" + p.getFormalName();
                }
                return type;
            }).collect(Collectors.joining(", ")) + ")";
        }
        header = header + "<br><br>";
        Font font = new Label().getFont();
        String start = "<html><body style='font-family:" + font.getFamily() + ";font-size:" + font.getSize() + ";'>";
        String end = "</body></html>";
        String javadoc = this.getJavadoc() != null ? this.getJavadoc() : "";
        return start + header + JavaUtils.javadocToHtml(javadoc.replace("\n\n", "<br><br>")) + end;
    }

    public boolean accessibleFromPackage(String pkgName) {
        if (this.access == null) {
            return true;
        }
        switch (this.access) {
            case PRIVATE: {
                return false;
            }
            case PROTECTED: 
            case PACKAGE: {
                return pkgName.equals(this.packageName);
            }
            case PUBLIC: {
                return true;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssistContentThreadSafe that = (AssistContentThreadSafe)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.access != that.access) {
            return false;
        }
        if (this.declaringClass != null ? !this.declaringClass.equals(that.declaringClass) : that.declaringClass != null) {
            return false;
        }
        if (this.kind != that.kind) {
            return false;
        }
        if (this.typeKind != that.typeKind) {
            return false;
        }
        if (this.javadoc != null ? !this.javadoc.equals(that.javadoc) : that.javadoc != null) {
            return false;
        }
        if (this.superTypes != null ? !this.superTypes.equals(that.superTypes) : that.superTypes != null) {
            return false;
        }
        return !(this.packageName == null ? that.packageName != null : !this.packageName.equals(that.packageName));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.access != null ? this.access.hashCode() : 0);
        result = 31 * result + (this.declaringClass != null ? this.declaringClass.hashCode() : 0);
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        result = 31 * result + (this.typeKind != null ? this.typeKind.hashCode() : 0);
        result = 31 * result + (this.javadoc != null ? this.javadoc.hashCode() : 0);
        result = 31 * result + (this.superTypes != null ? this.superTypes.hashCode() : 0);
        result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AssistContentThreadSafe{access=" + String.valueOf((Object)this.access) + ", name='" + this.name + "', params=(" + (this.params == null ? "<blank>" : this.params.stream().map(AssistContent.ParamInfo::toString).collect(Collectors.joining(","))) + "), type='" + this.type + "', declaringClass='" + this.declaringClass + "', kind=" + String.valueOf((Object)this.kind) + ", typeKind=" + String.valueOf((Object)this.typeKind) + ", javadoc='" + String.valueOf(this.javadoc == null ? "null" : Integer.valueOf(this.javadoc.hashCode())) + "', superTypes=" + String.valueOf(this.superTypes) + ", packageName='" + this.packageName + "'}";
    }

    public Element toXML() {
        Element el = new Element("acts");
        if (this.name != null) {
            el.addAttribute(new Attribute("name", this.name));
        }
        if (this.type != null) {
            el.addAttribute(new Attribute("type", this.type));
        }
        if (this.access != null) {
            el.addAttribute(new Attribute("access", this.access.toString()));
        }
        if (this.declaringClass != null) {
            el.addAttribute(new Attribute("declaringClass", this.declaringClass));
        }
        if (this.kind != null) {
            el.addAttribute(new Attribute("kind", this.kind.toString()));
        }
        if (this.typeKind != null) {
            el.addAttribute(new Attribute("typeKind", this.typeKind.toString()));
        }
        if (this.packageName != null) {
            el.addAttribute(new Attribute("packageName", this.packageName));
        }
        if (this.params != null) {
            throw new IllegalStateException();
        }
        if (this.superTypes != null) {
            Element superTypesEl = new Element("superTypes");
            for (String superType : this.superTypes) {
                Element superEl = new Element("superType");
                superEl.addAttribute(new Attribute("superType", superType));
                superTypesEl.appendChild((Node)superEl);
            }
            el.appendChild((Node)superTypesEl);
        }
        if (this.javadoc != null) {
            Element javadocEl = new Element("javadoc");
            CodeElement.preserveWhitespace(javadocEl);
            javadocEl.appendChild(this.javadoc);
            el.appendChild((Node)javadocEl);
        }
        return el;
    }

    public AssistContentThreadSafe(Element el) {
        if (!el.getLocalName().equals("acts")) {
            throw new IllegalArgumentException();
        }
        this.name = el.getAttributeValue("name");
        this.type = el.getAttributeValue("type");
        this.access = (AssistContent.Access)AssistContentThreadSafe.loadEnum((Enum[])AssistContent.Access.values(), (String)el.getAttributeValue("access"));
        this.declaringClass = el.getAttributeValue("declaringClass");
        this.kind = (AssistContent.CompletionKind)AssistContentThreadSafe.loadEnum((Enum[])AssistContent.CompletionKind.values(), (String)el.getAttributeValue("kind"));
        this.typeKind = (Kind)AssistContentThreadSafe.loadEnum((Enum[])Kind.values(), (String)el.getAttributeValue("typeKind"));
        this.packageName = el.getAttributeValue("packageName");
        Object paramsList = null;
        ArrayList<String> superTypesList = null;
        String javadocStr = null;
        block8: for (int i = 0; i < el.getChildElements().size(); ++i) {
            Element subEl = el.getChildElements().get(i);
            switch (subEl.getLocalName()) {
                case "superTypes": {
                    superTypesList = new ArrayList<String>();
                    for (int j = 0; j < subEl.getChildElements().size(); ++j) {
                        Element superTypeEl = subEl.getChildElements().get(j);
                        superTypesList.add(superTypeEl.getAttributeValue("superType"));
                    }
                    continue block8;
                }
                case "javadoc": {
                    javadocStr = subEl.getChild(0).getValue();
                }
            }
        }
        this.params = paramsList;
        this.superTypes = superTypesList;
        this.javadoc = javadocStr;
    }

    private static <E extends Enum<E>> E loadEnum(E[] values, String src) {
        for (E e : values) {
            if (!((Enum)e).toString().equals(src)) continue;
            return e;
        }
        return null;
    }
}

