/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.parser.AssistContent;
import bluej.pkgmgr.JavadocResolver;
import bluej.utility.JavaUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class MethodCompletion
extends AssistContent {
    private final @OnThread(value=Tag.Any) MethodReflective method;
    private JavadocResolver javadocResolver;
    private Map<String, GenTypeParameter> typeArgs;

    public MethodCompletion(MethodReflective method, Map<String, GenTypeParameter> typeArgs, JavadocResolver javadocResolver) {
        this.method = method;
        if (typeArgs != null) {
            List<GenTypeDeclTpar> mtpars = method.getTparTypes();
            if (!mtpars.isEmpty()) {
                HashMap<String, GenTypeParameter> fullArgMap = new HashMap<String, GenTypeParameter>();
                fullArgMap.putAll(typeArgs);
                for (GenTypeDeclTpar mtpar : mtpars) {
                    fullArgMap.put(mtpar.getTparName(), mtpar);
                }
                this.typeArgs = fullArgMap;
            } else {
                this.typeArgs = typeArgs;
            }
        }
        this.javadocResolver = javadocResolver;
    }

    @Override
    public String getDeclaringClass() {
        return this.method.getDeclaringType().getSimpleName();
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getName() {
        return this.method.getName();
    }

    @Override
    public String getType() {
        return this.convertToSolid(this.method.getReturnType()).toString(true);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public String getJavadoc() {
        String jd = this.method.getJavaDoc();
        if (jd == null && this.javadocResolver != null) {
            this.javadocResolver.getJavadoc(this.method.getDeclaringType(), Collections.singletonList(this.method));
            jd = this.method.getJavaDoc();
            if (jd == null) {
                this.method.setJavaDoc("");
            }
        }
        return jd;
    }

    private JavaType convertToSolid(JavaType type) {
        if (!type.isPrimitive()) {
            type = this.typeArgs != null ? type.mapTparsToTypes(this.typeArgs).getTparCapture() : type.getErasedType();
        }
        return type;
    }

    static String buildDummyName(JavaType paramType, String paramName) {
        if (paramName != null) {
            return "_" + paramName + "_";
        }
        return "_" + paramType.toString(true) + "_";
    }

    @Override
    public AssistContent.CompletionKind getKind() {
        return AssistContent.CompletionKind.METHOD;
    }

    @OnThread(value=Tag.FXPlatform)
    public String getSignature() {
        StringBuilder sig = new StringBuilder();
        sig.append(this.getType()).append(" ").append(this.getName()).append("(").append(this.getParams().stream().map(AssistContent.ParamInfo::getQualifiedType).collect(Collectors.joining(","))).append(")");
        return sig.toString();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<AssistContent.ParamInfo> getParams() {
        this.getJavadoc();
        ArrayList<AssistContent.ParamInfo> r = new ArrayList<AssistContent.ParamInfo>();
        List<JavaType> paramTypes = this.method.getParamTypes();
        List<String> paramNames = this.method.getParamNames();
        for (int i = 0; i < paramTypes.size(); ++i) {
            JavaType t = this.convertToSolid(paramTypes.get(i));
            String paramName = paramNames == null ? null : paramNames.get(i);
            r.add(new AssistContent.ParamInfo(t.toString(), paramName, MethodCompletion.buildDummyName(t, paramName), this.javadocForParam(paramName)));
        }
        return r;
    }

    @OnThread(value=Tag.FXPlatform)
    private Supplier<String> javadocForParam(String paramName) {
        String javadocSrc = this.getJavadoc();
        return () -> {
            JavaUtils.Javadoc javadoc = JavaUtils.parseJavadoc(javadocSrc);
            if (javadoc == null) {
                return null;
            }
            String target = "param " + paramName;
            for (String block : javadoc.getBlocks()) {
                if (!block.startsWith(target) || !Character.isWhitespace(block.charAt(target.length()))) continue;
                return block.substring(target.length() + 1).trim();
            }
            return null;
        };
    }

    @Override
    public AssistContent.Access getAccessPermission() {
        return MethodCompletion.fromModifiers(this.method.getModifiers());
    }
}

