/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.entity;

import bluej.debugger.gentype.ConstructorReflective;
import bluej.debugger.gentype.FieldReflective;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.debugger.gentype.Reflective;
import bluej.utility.JavaReflective;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class ParsedArrayReflective
extends Reflective {
    private Reflective component;
    private String className;

    public ParsedArrayReflective(Reflective component, String componentName) {
        this.component = component;
        this.className = "[" + componentName;
    }

    @Override
    public String getName() {
        return this.className;
    }

    @Override
    public String getSimpleName() {
        return this.component.getSimpleName() + "[]";
    }

    @Override
    public Reflective getArrayOf() {
        return new ParsedArrayReflective(this, this.className);
    }

    @Override
    public Map<String, FieldReflective> getDeclaredFields() {
        return Collections.singletonMap("length", new FieldReflective("length", JavaPrimitiveType.getInt(), 17, this));
    }

    @Override
    public Map<String, Set<MethodReflective>> getDeclaredMethods() {
        return Collections.singletonMap("clone", Collections.singleton(new MethodReflective("clone", new GenTypeClass(new JavaReflective(Object.class)), new ArrayList<GenTypeDeclTpar>(), new ArrayList<JavaType>(), this, false, 1)));
    }

    @Override
    public List<ConstructorReflective> getDeclaredConstructors() {
        return Collections.emptyList();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Reflective getRelativeClass(String name) {
        return this.component.getRelativeClass(name);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<GenTypeClass> getSuperTypes() {
        List<GenTypeClass> componentSupers = this.component.getSuperTypes();
        ListIterator<GenTypeClass> i = componentSupers.listIterator();
        while (i.hasNext()) {
            i.set(i.next().getArray());
        }
        componentSupers.add(new GenTypeClass(new JavaReflective(Object.class)));
        return componentSupers;
    }

    @Override
    public List<Reflective> getSuperTypesR() {
        JavaReflective obj = new JavaReflective(Object.class);
        return Collections.singletonList(obj);
    }

    @Override
    public List<GenTypeDeclTpar> getTypeParams() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAssignableFrom(Reflective r) {
        return false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isInterface() {
        return false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isPublic() {
        return this.component.isPublic();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isStatic() {
        return this.component.isStatic();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isFinal() {
        return this.component.isFinal();
    }

    @Override
    public Reflective getInnerClass(String name) {
        return null;
    }

    @Override
    public String getModuleName() {
        return this.component.getModuleName();
    }
}

