/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.Selection;
import bluej.utility.JavaUtils;
import bluej.utility.SortedProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public final class ClassInfo {
    private static final String[] unitTestClasses = new String[]{"junit.framework.TestCase"};
    private boolean foundPublicClass = false;
    private String name;
    private String superclass;
    private List<String> implemented = new ArrayList<String>();
    private List<String> used = new ArrayList<String>();
    private List<String> permits = new ArrayList<String>();
    private List<SavedComment> comments = new LinkedList<SavedComment>();
    private List<String> typeParameterTexts = new ArrayList<String>();
    private Selection typeParametersSelection;
    private Selection extendsReplaceSelection;
    private Selection superReplaceSelection;
    private boolean isInterface = false;
    private boolean isAbstract = false;
    private boolean isUnitTest = false;
    private boolean isEnum = false;
    private boolean hadParseError = false;
    private Selection extendsInsertSelection;
    private Selection implementsInsertSelection;
    private List<Selection> interfaceSelections;
    private boolean packageStatementExists = false;
    private Selection packageStatementSelection = new Selection(1, 1);
    private Selection packageNameSelection = new Selection(1, 1);
    private Selection packageSemiSelection = new Selection(1, 1);
    private String packageName = "";

    public boolean foundPublicClass() {
        return this.foundPublicClass;
    }

    public void setName(String name, boolean pub) {
        this.name = name;
        if (pub) {
            this.foundPublicClass = true;
        }
    }

    public void setSuperclass(String name) {
        if (name.equals(this.name)) {
            return;
        }
        this.superclass = name;
        if (this.used.contains(name)) {
            this.used.remove(name);
        }
        for (int i = 0; i < unitTestClasses.length; ++i) {
            if (!name.equals(unitTestClasses[i])) continue;
            this.isUnitTest = true;
        }
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public void addImplements(String name) {
        if (name.equals(this.name)) {
            return;
        }
        if (!this.implemented.contains(name)) {
            this.implemented.add(name);
        }
    }

    public void addPermits(String name) {
        if (name.equals(this.name)) {
            return;
        }
        if (!this.permits.contains(name)) {
            this.permits.add(name);
        }
    }

    public void addUsed(String name) {
        if (name.equals(this.name)) {
            return;
        }
        if (name.equals(this.superclass)) {
            return;
        }
        if (!this.used.contains(name)) {
            this.used.add(name);
        }
    }

    public void addComment(String target, String comment, String paramnames) {
        comment = JavaUtils.javadocToString(comment);
        this.comments.add(new SavedComment(this, target, comment, paramnames));
    }

    public void setInterface(boolean b) {
        this.isInterface = b;
    }

    public void setAbstract(boolean b) {
        this.isAbstract = b;
    }

    public void setParseError(boolean err) {
        this.hadParseError = err;
    }

    public void setExtendsInsertSelection(Selection s) {
        this.extendsInsertSelection = s;
    }

    public Selection getExtendsInsertSelection() {
        return this.extendsInsertSelection;
    }

    public void setImplementsInsertSelection(Selection s) {
        this.implementsInsertSelection = s;
    }

    public Selection getImplementsInsertSelection() {
        return this.implementsInsertSelection;
    }

    public void setExtendsReplaceSelection(Selection s) {
        this.extendsReplaceSelection = s;
    }

    public Selection getExtendsReplaceSelection() {
        return this.extendsReplaceSelection;
    }

    public void setSuperReplaceSelection(Selection s) {
        this.superReplaceSelection = s;
    }

    public Selection getSuperReplaceSelection() {
        return this.superReplaceSelection;
    }

    public void setInterfaceSelections(List<Selection> selections) {
        this.interfaceSelections = selections;
    }

    public void addTypeParameterText(String typeParameterText) {
        this.typeParameterTexts.add(typeParameterText);
    }

    public List<String> getTypeParameterTexts() {
        return this.typeParameterTexts;
    }

    public List<Selection> getInterfaceSelections() {
        return this.interfaceSelections;
    }

    public boolean hasInterfaceSelections() {
        return this.interfaceSelections != null && this.interfaceSelections.size() > 0;
    }

    public void setPackageSelections(Selection pkgStatement, Selection pkgName, String pkgNameText, Selection pkgSemi) {
        this.packageStatementSelection = pkgStatement;
        this.packageNameSelection = pkgName;
        this.packageName = pkgNameText;
        this.packageSemiSelection = pkgSemi;
        this.packageStatementExists = true;
    }

    public boolean hasPackageStatement() {
        return this.packageStatementExists;
    }

    public Selection getPackageStatementSelection() {
        return this.packageStatementSelection;
    }

    public Selection getPackageNameSelection() {
        return this.packageNameSelection;
    }

    public Selection getPackageSemiSelection() {
        return this.packageSemiSelection;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getImplements() {
        return this.implemented;
    }

    public void setTypeParametersSelection(Selection s) {
        this.typeParametersSelection = s;
    }

    public boolean hasTypeParameter() {
        return this.typeParametersSelection != null;
    }

    public List<String> getUsed() {
        return this.used;
    }

    public List<String> getPermits() {
        return this.permits;
    }

    public Properties getComments() {
        SortedProperties props = new SortedProperties();
        props.setProperty("numComments", String.valueOf(this.comments.size()));
        Iterator<SavedComment> it = this.comments.iterator();
        int i = 0;
        while (it.hasNext()) {
            SavedComment c = it.next();
            c.save(props, "comment" + i);
            ++i;
        }
        return props;
    }

    public List<SavedComment> getCommentsAsList() {
        return Collections.unmodifiableList(this.comments);
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isUnitTest() {
        return this.isUnitTest;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean hadParseError() {
        return this.hadParseError;
    }

    public class SavedComment {
        public final String target;
        public final String comment;
        public final String paramnames;

        public SavedComment(ClassInfo this$0, String target, String comment, String paramnames) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.target = target;
            this.comment = comment;
            this.paramnames = paramnames;
        }

        public void save(Properties p, String prefix) {
            p.put(prefix + ".target", this.target);
            if (this.comment != null) {
                p.setProperty(prefix + ".text", this.comment);
            }
            if (this.paramnames != null) {
                p.setProperty(prefix + ".params", this.paramnames);
            }
        }
    }
}

