/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.Pair;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class AboutDialogTemplate
extends Dialog<Void> {
    public AboutDialogTemplate(Window parent, String version, String websiteURL, Image image, String[] translators, String[] previousTeamMembers) {
        this.initOwner(parent);
        this.initModality(Modality.WINDOW_MODAL);
        this.setTitle(Config.getString("menu.help.about"));
        this.setDialogPane(new DialogPane(this){

            @OnThread(value=Tag.FX)
            protected Node createButtonBar() {
                ButtonBar buttonBar = (ButtonBar)super.createButtonBar();
                buttonBar.setButtonOrder("_C_");
                return buttonBar;
            }
        });
        Config.addDialogStylesheets((Pane)this.getDialogPane());
        this.getDialogPane().getButtonTypes().add((Object)ButtonType.CLOSE);
        TabPane tabs = JavaFXUtil.withStyleClass(new TabPane(new Tab[]{this.createMainTab(version, websiteURL, image), this.createContributorsTab(translators, previousTeamMembers)}), "about-tabs");
        this.getDialogPane().setContent((Node)tabs);
        this.setResizable(false);
    }

    private Tab createMainTab(String version, String websiteURL, Image image) {
        BorderPane aboutPanel = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)aboutPanel, "about-dialog-content");
        aboutPanel.setCenter((Node)JavaFXUtil.withStyleClass(new ImageView(image), "about-dialog-image"));
        VBox bottom = JavaFXUtil.withStyleClass(new VBox(), "about-more-info");
        aboutPanel.setBottom((Node)bottom);
        String teamText = String.join((CharSequence)", ", "Neil Brown", "Michael K\u00f6lling", "Pierre Weill-Tessier.");
        bottom.getChildren().add((Object)((Node)JavaFXUtil.withStyleClass(new Label(Config.getString("about.theTeam") + " " + teamText), "about-team")));
        bottom.getChildren().add((Object)new Label(""));
        bottom.getChildren().add((Object)((Node)JavaFXUtil.withStyleClass(new Label(Config.getString("about.version") + " " + version), "about-version")));
        bottom.getChildren().add((Object)((Node)JavaFXUtil.withStyleClass(new Label("Build ID: " + Config.getBuildID()), "about-version")));
        bottom.getChildren().add((Object)((Node)JavaFXUtil.withStyleClass(new Label(Config.getString("about.java.version") + " " + System.getProperty("java.version")), "about-version-last")));
        bottom.getChildren().add((Object)new Label(Config.getString("about.vm") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")"));
        bottom.getChildren().add((Object)new Label(Config.getString("about.javafx") + " " + System.getProperty("javafx.runtime.version")));
        bottom.getChildren().add((Object)new Label(Config.getString("about.runningOn") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")"));
        Button debugLogShow = new Button(Config.getString("about.openFolder"));
        debugLogShow.setOnAction(e -> {
            try {
                if (Config.isWinOS()) {
                    Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", Config.getUserConfigDir().getAbsolutePath()});
                } else if (Config.isMacOS()) {
                    Runtime.getRuntime().exec(new String[]{"open", Config.getUserConfigDir().getAbsolutePath()});
                } else if (Config.isLinux()) {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", Config.getUserConfigDir().getAbsolutePath()});
                }
            }
            catch (IOException ex) {
                Debug.reportError(ex);
            }
        });
        HBox debugLog = new HBox(new Node[]{new Label(Config.getString("about.logfile") + " " + String.valueOf(Config.getUserConfigFile(Config.debugLogName))), debugLogShow});
        JavaFXUtil.addStyleClass((Styleable)debugLog, "about-debuglog");
        debugLog.setAlignment(Pos.BASELINE_LEFT);
        bottom.getChildren().add((Object)debugLog);
        try {
            URL softwareURL = new URL(websiteURL);
            Hyperlink link = new Hyperlink(softwareURL.toString());
            link.setOnMouseClicked(e -> Utility.openWebBrowser(softwareURL.toExternalForm()));
            HBox hbox = new HBox(new Node[]{new Label(Config.getString("about.moreInformation")), link});
            hbox.setAlignment(Pos.CENTER);
            JavaFXUtil.addStyleClass((Styleable)hbox, "about-info-link");
            bottom.getChildren().add((Object)hbox);
        }
        catch (MalformedURLException softwareURL) {
            // empty catch block
        }
        Tab tab = new Tab(Config.getString("about.general.title"), (Node)aboutPanel);
        tab.setClosable(false);
        return tab;
    }

    private Tab createContributorsTab(String[] translators, String[] previousTeamMembers) {
        Tab tab = new Tab(Config.getString("about.contributors.title"));
        tab.setClosable(false);
        VBox vbox = new VBox();
        if (previousTeamMembers != null) {
            Label teamTitle = new Label("\n" + Config.getString("about.previousTeamMembers.title") + "\n");
            teamTitle.getStyleClass().add((Object)"about-contributors-title");
            String names = String.join((CharSequence)", ", previousTeamMembers);
            Label teamLabel = new Label(names + ".");
            teamLabel.setPrefWidth(500.0);
            teamLabel.setWrapText(true);
            vbox.getChildren().addAll((Object[])new Node[]{teamTitle, teamLabel});
        }
        if (translators != null) {
            Label translatorTitle = new Label("\n" + Config.getString("about.translators.title") + "\n");
            translatorTitle.getStyleClass().add((Object)"about-contributors-title");
            vbox.getChildren().add((Object)translatorTitle);
            ObservableList pairs = FXCollections.observableArrayList();
            for (int i = 0; i < translators.length - 1; i += 2) {
                pairs.add((Object)new Pair((Object)translators[i], (Object)translators[i + 1]));
            }
            TableView tableView = new TableView(pairs);
            tableView.getStyleClass().add((Object)"about-translators-table");
            tableView.setEditable(false);
            TableColumn languageColumn = new TableColumn();
            languageColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper((String)((Pair)param.getValue()).getKey()));
            TableColumn nameColumn = new TableColumn();
            nameColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper((String)((Pair)param.getValue()).getValue()));
            tableView.getColumns().setAll((Object[])new TableColumn[]{languageColumn, nameColumn});
            vbox.getChildren().add((Object)tableView);
        }
        tab.setContent((Node)vbox);
        return tab;
    }
}

